/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DriverExtendedDeleteImpl {
    public static boolean delete(Node[] nodes) throws IOException {
        JDBCDriver[] jdbcDrivers = DriverExtendedDeleteImpl.getJDBCDrivers(nodes);
        if (jdbcDrivers == null) {
            return false;
        }
        DatabaseConnection firstConnection = DriverExtendedDeleteImpl.findFirstConnection(jdbcDrivers);
        if (firstConnection == null) {
            return false;
        }
        if (!DriverExtendedDeleteImpl.canDeleteDrivers(jdbcDrivers, firstConnection)) {
            return true;
        }
        for (int i = 0; i < nodes.length; ++i) {
            try {
                nodes[i].destroy();
                continue;
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return true;
    }

    private static JDBCDriver[] getJDBCDrivers(Node[] nodes) {
        JDBCDriver[] jdbcDrivers = new JDBCDriver[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            DriverNode driverInfo = (DriverNode)((Object)nodes[i].getLookup().lookup(DriverNode.class));
            if (driverInfo == null) {
                return null;
            }
            jdbcDrivers[i] = driverInfo.getDatabaseDriver().getJDBCDriver();
            if (jdbcDrivers[i] != null) continue;
            return null;
        }
        return jdbcDrivers;
    }

    private static DatabaseConnection findFirstConnection(JDBCDriver[] jdbcDrivers) {
        DatabaseConnection[] dbconns = ConnectionList.getDefault().getConnections();
        for (int i = 0; i < jdbcDrivers.length; ++i) {
            int j;
            for (j = 0; j < dbconns.length; ++j) {
                if (!jdbcDrivers[i].getName().equals(dbconns[j].getDriverName())) continue;
                return dbconns[j];
            }
            for (j = 0; j < dbconns.length; ++j) {
                if (!jdbcDrivers[i].getClassName().equals(dbconns[j].getDriver())) continue;
                return dbconns[j];
            }
        }
        return null;
    }

    private static boolean canDeleteDrivers(JDBCDriver[] jdbcDrivers, DatabaseConnection firstConnection) {
        String title;
        String message;
        if (jdbcDrivers.length == 1) {
            String format = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDriver");
            message = MessageFormat.format(format, jdbcDrivers[0].getDisplayName(), firstConnection.getDatabaseConnection().getDisplayName());
            title = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDriverTitle");
        } else {
            String format = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDrivers");
            message = MessageFormat.format(format, new Integer(jdbcDrivers.length));
            title = NbBundle.getMessage(DriverExtendedDeleteImpl.class, (String)"MSG_ConfirmDeleteDriversTitle");
        }
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, title, 0)) == NotifyDescriptor.YES_OPTION;
    }
}

