/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.projectsui.BreakpointAnnotationProvider;
import org.netbeans.modules.debugger.jpda.projectsui.LineTranslations;

public class BreakpointAnnotationManager
extends DebuggerManagerAdapter {
    private volatile JPDADebugger currentDebugger = null;
    private BreakpointAnnotationProvider bap;

    private BreakpointAnnotationProvider getAnnotationProvider() {
        if (this.bap == null) {
            this.bap = BreakpointAnnotationProvider.getInstance();
        }
        return this.bap;
    }

    public String[] getProperties() {
        return new String[]{"breakpoints", "debuggerEngines"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            JPDABreakpoint b = (JPDABreakpoint)breakpoint;
            b.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.getAnnotationProvider().postAnnotationRefresh(b, false, true);
            if (b instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)b;
                LineTranslations.getTranslations().registerForLineUpdates(lb);
            }
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            JPDABreakpoint b = (JPDABreakpoint)breakpoint;
            b.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.getAnnotationProvider().postAnnotationRefresh(b, true, false);
            if (b instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)b;
                LineTranslations.getTranslations().unregisterFromLineUpdates(lb);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JPDADebugger debugger;
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if ("currentEngine".equals(propertyName)) {
            this.setCurrentDebugger(DebuggerManager.getDebuggerManager().getCurrentEngine());
        }
        if ("breakpointsActive".equals(propertyName) && (debugger = this.currentDebugger) != null) {
            this.getAnnotationProvider().setBreakpointsActive(debugger.getBreakpointsActive());
        }
        if (!("enabled".equals(propertyName) || "validity".equals(propertyName) || "condition".equals(propertyName) || "url".equals(propertyName) || "lineNumber".equals(propertyName) || "className".equals(propertyName) || "fieldName".equals(propertyName) || "classFilters".equals(propertyName) || "classExclusionFilters".equals(propertyName) || "methodName".equals(propertyName) || "signature".equals(propertyName))) {
            return;
        }
        JPDABreakpoint b = (JPDABreakpoint)evt.getSource();
        DebuggerManager manager = DebuggerManager.getDebuggerManager();
        Breakpoint[] bkpts = manager.getBreakpoints();
        boolean found = false;
        for (int x = 0; x < bkpts.length; ++x) {
            if (b != bkpts[x]) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.getAnnotationProvider().postAnnotationRefresh(b, true, true);
    }

    private void setCurrentDebugger(DebuggerEngine engine) {
        JPDADebugger oldDebugger = this.currentDebugger;
        if (oldDebugger != null) {
            oldDebugger.removePropertyChangeListener("breakpointsActive", (PropertyChangeListener)((Object)this));
        }
        boolean active = true;
        JPDADebugger debugger = null;
        if (engine != null && (debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class)) != null) {
            debugger.addPropertyChangeListener("breakpointsActive", (PropertyChangeListener)((Object)this));
            active = debugger.getBreakpointsActive();
        }
        this.currentDebugger = debugger;
        this.getAnnotationProvider().setBreakpointsActive(active);
    }
}

