/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpGetProperty;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.RunnerRestGetProperty;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;

@RunnerHttpClass(runner=RunnerHttpGetProperty.class)
@RunnerRestClass(runner=RunnerRestGetProperty.class)
public class CommandGetProperty
extends Command {
    private static final Logger LOGGER = new Logger(CommandGetProperty.class);
    private static final String COMMAND = "get";
    String propertyPattern;

    public static ResultMap<String, String> getProperties(PayaraServer server, String propertyPattern) throws PayaraIdeException {
        String METHOD = "getProperties";
        Future future = ServerAdmin.exec(server, new CommandGetProperty(propertyPattern));
        try {
            return (ResultMap)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new PayaraIdeException(LOGGER.excMsg("getProperties", "exception", propertyPattern), ee);
        }
    }

    public static ResultMap<String, String> getProperties(PayaraServer server, String propertyPattern, long timeout) throws PayaraIdeException {
        String METHOD = "getProperties";
        Future future = ServerAdmin.exec(server, new CommandGetProperty(propertyPattern));
        try {
            return (ResultMap)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new PayaraIdeException(LOGGER.excMsg("getProperties", "exception", propertyPattern), ee);
        }
        catch (TimeoutException te) {
            throw new PayaraIdeException(LOGGER.excMsg("getProperties", "exceptionWithTimeout", propertyPattern, Long.toString(timeout)), te);
        }
    }

    public CommandGetProperty(String property) {
        super(COMMAND);
        this.propertyPattern = property;
    }
}

