/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.payara.tooling.PayaraToolsConfig;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.Result;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;

public abstract class Runner
implements Callable<Result> {
    private static final Logger LOGGER = new Logger(Runner.class);
    public static final int HTTP_CONNECTION_TIMEOUT = 3000;
    public static final int HTTP_RETRY_DELAY = 3000;
    static final char QUERY_SEPARATOR = '?';
    static final char PARAM_SEPARATOR = '&';
    static final char ITEM_SEPARATOR = ':';
    static final char PARAM_ASSIGN_VALUE = '=';
    static final String TRUE_VALUE = "true";
    static final String FALSE_VALUE = "false";
    private static volatile ExecutorService executor;
    private static volatile Authenticator authenticator;
    protected boolean silentFailureAllowed = false;
    protected String path;
    boolean retry = false;
    boolean auth = true;
    protected PayaraServer server;
    final Command command;
    Result result;
    final String query;
    protected TaskStateListener[] stateListeners;
    private URL urlToConnectTo;
    private URLConnection conn;
    private HttpURLConnection hconn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExecutorService serializedExecutor() {
        if (executor != null) {
            return executor;
        }
        Class<Runner> clazz = Runner.class;
        synchronized (Runner.class) {
            if (executor == null) {
                executor = Executors.newFixedThreadPool(1);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Authenticator authenticator) {
        Class<Runner> clazz = Runner.class;
        synchronized (Runner.class) {
            if (Runner.authenticator != null) {
                throw new IllegalStateException();
            }
            Runner.authenticator = authenticator;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static Authenticator getAuthenticator() {
        return authenticator;
    }

    static ExecutorService parallelExecutor(int size) {
        return Executors.newFixedThreadPool(size);
    }

    static String toString(boolean value) {
        return value ? TRUE_VALUE : FALSE_VALUE;
    }

    static boolean toBoolean(String constant) throws CommandException {
        if (constant == null || constant.length() < 1) {
            throw new CommandException("Invalid String representing boolean constant.");
        }
        switch (constant.charAt(0)) {
            case 'T': 
            case 't': {
                if (constant.regionMatches(true, 1, "rue", 1, 3)) {
                    return true;
                }
                throw new CommandException("Invalid String representing boolean constant.");
            }
            case 'F': 
            case 'f': {
                if (constant.regionMatches(true, 1, "alse", 1, 4)) {
                    return false;
                }
                throw new CommandException("Invalid String representing boolean constant.");
            }
        }
        throw new CommandException("Invalid String representing boolean constant.");
    }

    protected abstract Result createResult();

    public abstract boolean getDoOutput();

    public abstract boolean acceptsGzip();

    protected abstract String constructCommandUrl() throws CommandException;

    protected abstract String getRequestMethod();

    protected abstract void handleSend(HttpURLConnection var1) throws IOException;

    protected abstract boolean readResponse(InputStream var1, HttpURLConnection var2);

    protected abstract boolean processResponse();

    Runner(PayaraServer server, Command command, String path) {
        this(server, command, path, null);
    }

    Runner(PayaraServer server, Command command, String path, String query) {
        this.server = server;
        this.command = command;
        this.path = path;
        this.query = query;
    }

    String getQuery() {
        return this.query;
    }

    Command getCommand() {
        return this.command;
    }

    public Result getResult() {
        return this.result;
    }

    protected boolean isSilentFailureAllowed() {
        return this.silentFailureAllowed;
    }

    public void setSilentFailureAllowed(boolean silentFailureAllowed) {
        this.silentFailureAllowed = silentFailureAllowed;
    }

    public void setStateListeners(TaskStateListener[] listeners) {
        this.stateListeners = listeners;
    }

    public String getContentType() {
        return null;
    }

    String getCommandWithQuery() {
        String commandString = this.command.getCommand();
        if (this.query == null) {
            return commandString;
        }
        StringBuilder sb = new StringBuilder(commandString.length() + 1 + this.query.length());
        sb.append(commandString);
        sb.append('?');
        sb.append(this.query);
        return sb.toString();
    }

    String[] stateChangeArgs(String exMessage, boolean display) {
        return new String[]{this.server.getName(), this.command.getCommand(), exMessage, Boolean.toString(display)};
    }

    String[] stateChangeArgs(String exMessage) {
        return new String[]{this.server.getName(), this.command.getCommand(), exMessage, Boolean.toString(false)};
    }

    Result handleStateChange(TaskState newTaskState, TaskEvent taskEvent, String ... args) {
        this.result.state = newTaskState;
        if (this.stateListeners != null) {
            for (int i = 0; i < this.stateListeners.length; ++i) {
                if (this.stateListeners[i] == null) continue;
                this.stateListeners[i].operationStateChanged(newTaskState, taskEvent, args);
            }
        }
        return this.result;
    }

    public void setReadyState() {
        this.result = this.createResult();
        this.handleStateChange(TaskState.READY, TaskEvent.SUBMIT, this.stateChangeArgs(null));
    }

    Future<? extends Result> execute() {
        this.setReadyState();
        return Runner.serializedExecutor().submit(this);
    }

    Future<? extends Result> execute(ExecutorService executor) {
        this.setReadyState();
        return executor.submit(this);
    }

    protected void prepareHttpConnection(HttpURLConnection conn) throws CommandException {
        String METHOD = "prepareHttpConnection";
        conn.setAllowUserInteraction(false);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setConnectTimeout(3000);
        String adminUser = this.server.getAdminUser();
        String adminPassword = this.server.getAdminPassword();
        LOGGER.log(Level.FINEST, "prepareHttpConnection", "setting", new Object[]{new Integer(3000), adminUser, adminPassword});
        try {
            conn.setRequestMethod(this.getRequestMethod());
        }
        catch (ProtocolException pe) {
            throw new CommandException("Cannos set headers for HTTP connection", pe);
        }
        conn.setDoOutput(this.getDoOutput());
        String contentType = this.getContentType();
        if (contentType != null && contentType.length() > 0) {
            conn.setRequestProperty("Content-Type", contentType);
            conn.setChunkedStreamingMode(0);
        }
        if (adminPassword != null && adminPassword.length() > 0) {
            String authString = ServerUtils.basicAuthCredentials(adminUser, adminPassword);
            LOGGER.log(Level.FINEST, "prepareHttpConnection", "using");
            conn.setRequestProperty("Authorization", "Basic " + authString);
        }
        if (this.acceptsGzip()) {
            conn.setRequestProperty("Accept-Encoding", "gzip");
        }
    }

    protected void handleSecureConnection(HttpsURLConnection conn) {
        String METHOD = "handleSecureConnection";
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, tm, null);
            conn.setSSLSocketFactory(context.getSocketFactory());
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession ssls) {
                    return true;
                }
            });
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            LOGGER.log(Level.INFO, "handleSecureConnection", "issue", conn.getURL());
            LOGGER.log(Level.INFO, "handleSecureConnection", "exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleReceive(HttpURLConnection hconn) throws IOException {
        String METHOD = "handleReceive";
        boolean receiveResult = false;
        InputStream httpInputStream = hconn.getInputStream();
        try {
            receiveResult = this.readResponse(httpInputStream, hconn);
        }
        finally {
            try {
                httpInputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "handleReceive", "exception", ioe);
            }
        }
        return receiveResult;
    }

    private void initCallAttributes() {
        this.urlToConnectTo = null;
        this.conn = null;
        this.hconn = null;
    }

    private static URLConnection openURLConnection(URL urlToConnectTo) throws IOException {
        if (!PayaraToolsConfig.getProxyForLoopback()) {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(urlToConnectTo.getHost());
            }
            catch (UnknownHostException ex) {
                addr = null;
            }
            if (addr != null && addr.isLoopbackAddress()) {
                return urlToConnectTo.openConnection(Proxy.NO_PROXY);
            }
        }
        return urlToConnectTo.openConnection();
    }

    private StateChange handleHTTPConnection() throws IOException {
        URL oldUrlToConnectTo;
        String METHOD = "handleHTTPConnection";
        do {
            oldUrlToConnectTo = this.urlToConnectTo;
            this.hconn = (HttpURLConnection)this.conn;
            if (this.conn instanceof HttpsURLConnection) {
                this.handleSecureConnection((HttpsURLConnection)this.conn);
            }
            this.prepareHttpConnection(this.hconn);
            LOGGER.log(Level.FINEST, "handleHTTPConnection", "connect", new Object[]{this.server.getHost(), Integer.toString(this.server.getAdminPort())});
            Authenticator extAuth = Runner.getAuthenticator();
            if (extAuth != null) {
                Authenticator.setDefault(extAuth);
            }
            this.hconn.connect();
            this.handleSend(this.hconn);
            int respCode = this.hconn.getResponseCode();
            StateChange change = this.handleHTTPResponse(respCode);
            if (change == null) continue;
            return change;
        } while (this.urlToConnectTo != oldUrlToConnectTo);
        return null;
    }

    private StateChange handleHTTPResponse(int responseCode) throws IOException {
        String METHOD = "handleHTTPResponse";
        LOGGER.log(Level.FINE, "handleHTTPResponse", "response", responseCode);
        if (responseCode == 401 || responseCode == 403) {
            this.auth = false;
            this.result.auth = false;
            return new StateChange(this, TaskState.FAILED, TaskEvent.AUTH_FAILED_HTTP, this.stateChangeArgs(null, true));
        }
        if (responseCode == 502) {
            return new StateChange(this, TaskState.FAILED, TaskEvent.BAD_GATEWAY, this.stateChangeArgs(null, true));
        }
        if (responseCode == 302 || responseCode == 301) {
            String newUrl = this.hconn.getHeaderField("Location");
            if (null == newUrl || "".equals(newUrl.trim())) {
                LOGGER.log(Level.SEVERE, "handleHTTPResponse", "invalidRedirect", this.urlToConnectTo.toString());
            } else {
                LOGGER.log(Level.FINE, "handleHTTPResponse", "locationMoved", newUrl);
                this.urlToConnectTo = new URL(newUrl);
                this.conn = Runner.openURLConnection(this.urlToConnectTo);
                this.hconn.disconnect();
            }
        }
        return null;
    }

    private void logCommandFailure(String method) {
        LOGGER.log(Level.FINE, method, "failure", new Object[]{this.hconn.toString(), this.hconn.getContentType(), this.hconn.getContentEncoding()});
        Map<String, List<String>> ms2ls = this.hconn.getHeaderFields();
        LOGGER.log(Level.FINE, method, "headerFields");
        for (Map.Entry<String, List<String>> e : ms2ls.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (String v : e.getValue()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(v);
            }
            sb.append("]");
            LOGGER.log(Level.FINE, method, "headerField", new String[]{e.getKey(), sb.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result call() {
        String commandUrl;
        String METHOD = "call";
        boolean httpSucceeded = false;
        boolean commandSucceeded = false;
        this.initCallAttributes();
        this.handleStateChange(TaskState.RUNNING, TaskEvent.CMD_RUNNING, this.stateChangeArgs(null));
        try {
            commandUrl = this.constructCommandUrl();
        }
        catch (CommandException ce) {
            return this.handleStateChange(TaskState.FAILED, TaskEvent.CMD_EXCEPTION, this.stateChangeArgs(ce.getLocalizedMessage()));
        }
        int retries = 1;
        LOGGER.log(Level.FINEST, "call", "thread", new Object[]{commandUrl, Thread.currentThread().getName()});
        try {
            this.urlToConnectTo = new URL(commandUrl);
            while (!httpSucceeded && retries-- > 0) {
                try {
                    this.conn = Runner.openURLConnection(this.urlToConnectTo);
                    if (this.conn instanceof HttpURLConnection) {
                        StateChange change = this.handleHTTPConnection();
                        if (change != null) {
                            Result result = change.handleStateChange();
                            return result;
                        }
                        boolean receiveResult = this.handleReceive(this.hconn);
                        boolean processResult = this.processResponse();
                        boolean bl = commandSucceeded = receiveResult && processResult;
                        if (!this.auth) {
                            Result result = this.handleStateChange(TaskState.FAILED, TaskEvent.AUTH_FAILED, this.stateChangeArgs(null, true));
                            return result;
                        }
                        if (!commandSucceeded && !this.isSilentFailureAllowed() && LOGGER.isLoggable(Level.FINE)) {
                            this.logCommandFailure("call");
                        }
                        httpSucceeded = true;
                    } else {
                        LOGGER.log(Level.INFO, "call", "unexpectedConnection", this.urlToConnectTo);
                    }
                }
                catch (ProtocolException ex) {
                    this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ex.getLocalizedMessage(), true));
                    retries = 0;
                }
                catch (ConnectException ce) {
                    Result result = this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ce.getLocalizedMessage()));
                    return result;
                }
                catch (IOException ex) {
                    if (retries <= 0) {
                        Result result = this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ex.getLocalizedMessage()));
                        return result;
                    }
                }
                catch (RuntimeException ex) {
                    Result result = this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ex.getLocalizedMessage()));
                    return result;
                }
                finally {
                    if (null != this.hconn) {
                        this.hconn.disconnect();
                    }
                }
                if (httpSucceeded || retries <= 0) continue;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    LOGGER.log(Level.INFO, "call", "sleepInterrupted", ie);
                }
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, "call", "malformedURLException", ex);
        }
        if (!commandSucceeded) return this.handleStateChange(TaskState.FAILED, TaskEvent.CMD_FAILED, this.stateChangeArgs(null));
        return this.handleStateChange(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, this.stateChangeArgs(null));
    }

    protected static class StateChange {
        private final Runner runner;
        private final TaskState taskState;
        private final TaskEvent taskEvent;
        private final String[] args;

        protected StateChange(Runner runner, TaskState taskState, TaskEvent taskEvent, String ... args) {
            this.runner = runner;
            this.taskState = taskState;
            this.taskEvent = taskEvent;
            this.args = args;
        }

        protected Result handleStateChange() {
            return this.runner.handleStateChange(this.taskState, this.taskEvent, this.args);
        }
    }
}

