/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.config;

import java.net.URL;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;

public class Config {
    final URL[] configFiles;
    final int[] index;

    public Config(URL defaultConfig, Next ... nextConfig) {
        int indexSize = nextConfig == null ? 1 : nextConfig.length + 1;
        this.index = new int[PayaraVersion.length];
        this.configFiles = new URL[indexSize];
        int i = 0;
        this.configFiles[i] = defaultConfig;
        Next config = nextConfig != null && i < nextConfig.length ? nextConfig[i] : null;
        for (PayaraVersion version : PayaraVersion.values()) {
            int versionIndex = version.ordinal();
            if (config != null && config.version.ordinal() <= version.ordinal()) {
                this.configFiles[++i] = config.configFile;
                config = i < nextConfig.length ? nextConfig[i] : null;
            }
            this.index[versionIndex] = i;
        }
    }

    public static class Next {
        URL configFile;
        PayaraVersion version;

        public Next(PayaraVersion version, URL configFile) {
            this.configFile = configFile;
            this.version = version;
        }
    }
}

