/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.scripting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.netbeans.spi.scripting.EngineProvider;
import org.openide.util.Lookup;

public final class Scripting {
    private boolean allowAllAccess;

    private Scripting() {
    }

    public static ScriptEngineManager createManager() {
        return Scripting.newBuilder().build();
    }

    public static Scripting newBuilder() {
        return new Scripting();
    }

    public Scripting allowAllAccess(boolean allAccess) {
        this.allowAllAccess = allAccess;
        return this;
    }

    public ScriptEngineManager build() {
        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        if (l == null) {
            l = Scripting.class.getClassLoader();
        }
        return new EngineManager(this.allowAllAccess, l);
    }

    private static final class EngineManager
    extends ScriptEngineManager {
        private final List<ScriptEngineFactory> extra;
        private final boolean allowAllAccess;
        private static final Class<?> nashornScriptEngineFactory;

        EngineManager(boolean allowAllAccess, ClassLoader loader) {
            super(loader);
            this.allowAllAccess = allowAllAccess;
            if (allowAllAccess) {
                this.getBindings().put("allowAllAccess", (Object)true);
            }
            this.extra = EngineManager.populateExtras(this);
            for (ScriptEngineFactory f : this.extra) {
                this.registerEngineName(f.getEngineName(), f);
                for (String ext : f.getExtensions()) {
                    this.registerEngineExtension(ext, f);
                }
                for (String mime : f.getMimeTypes()) {
                    this.registerEngineMimeType(mime, f);
                }
            }
        }

        private static List<ScriptEngineFactory> populateExtras(EngineManager m) {
            ArrayList<? extends ScriptEngineFactory> extra = new ArrayList<ScriptEngineFactory>();
            for (EngineProvider p : Lookup.getDefault().lookupAll(EngineProvider.class)) {
                extra.addAll(p.factories(m));
            }
            return Collections.unmodifiableList(extra);
        }

        @Override
        public List<ScriptEngineFactory> getEngineFactories() {
            ArrayList<ScriptEngineFactory> all = new ArrayList<ScriptEngineFactory>();
            all.addAll(super.getEngineFactories());
            all.addAll(this.extra);
            ListIterator<GraalJSWrapperFactory> it = all.listIterator();
            while (it.hasNext()) {
                ScriptEngineFactory f = (ScriptEngineFactory)it.next();
                if (!f.getNames().contains("Graal.js") && !this.isNashornFactory(f)) continue;
                it.set(new GraalJSWrapperFactory(f));
            }
            return all;
        }

        @Override
        public ScriptEngine getEngineByExtension(String extension) {
            return this.postConfigure(super.getEngineByExtension(extension));
        }

        @Override
        public ScriptEngine getEngineByMimeType(String mimeType) {
            return this.postConfigure(super.getEngineByMimeType(mimeType));
        }

        @Override
        public ScriptEngine getEngineByName(String shortName) {
            return this.postConfigure(super.getEngineByName(shortName));
        }

        private ScriptEngine postConfigure(ScriptEngine eng) {
            if (eng == null) {
                return null;
            }
            if (eng.getFactory().getNames().contains("Graal.js")) {
                Bindings b = eng.getBindings(100);
                if (this.allowAllAccess) {
                    b.put("polyglot.js.nashorn-compat", (Object)true);
                } else {
                    b.put("polyglot.js.allowHostAccess", (Object)true);
                }
                b.put("polyglot.js.allowHostClassLookup", s -> this.allowHostClassLookup(eng, (String)s));
            }
            if (this.isNashornFactory(eng.getFactory())) {
                return this.secureEngineEngine(eng);
            }
            return eng;
        }

        private boolean isNashornFactory(ScriptEngineFactory f) {
            return nashornScriptEngineFactory.isInstance(f);
        }

        private ScriptEngine secureEngineEngine(ScriptEngine prototypeEngine) {
            ScriptEngine[] engine = new ScriptEngine[]{prototypeEngine};
            try {
                ScriptEngineFactory f = engine[0].getFactory();
                Class<?> factoryClass = f.getClass();
                ClassLoader factoryClassLoader = factoryClass.getClassLoader();
                Class<?> filterClass = Class.forName("jdk.nashorn.api.scripting.ClassFilter", true, factoryClassLoader);
                Method createMethod = factoryClass.getMethod("getScriptEngine", filterClass);
                Object filter = Proxy.newProxyInstance(factoryClassLoader, new Class[]{filterClass}, (proxy, method, args) -> this.allowHostClassLookup(engine[0], (String)args[0]));
                engine[0] = (ScriptEngine)createMethod.invoke((Object)f, filter);
                return engine[0];
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                return engine[0];
            }
        }

        private boolean allowHostClassLookup(ScriptEngine engine, String className) {
            return this.allowAllAccess;
        }

        static {
            Class<Object> klass;
            try {
                klass = Class.forName("jdk.nashorn.api.scripting.NashornScriptEngineFactory");
            }
            catch (ClassNotFoundException ex) {
                klass = String.class;
            }
            nashornScriptEngineFactory = klass;
        }

        private final class GraalJSWrapperFactory
        implements ScriptEngineFactory {
            private final ScriptEngineFactory original;

            GraalJSWrapperFactory(ScriptEngineFactory original) {
                this.original = original;
            }

            @Override
            public String getEngineName() {
                return this.original.getEngineName();
            }

            @Override
            public String getEngineVersion() {
                return this.original.getEngineVersion();
            }

            @Override
            public List<String> getExtensions() {
                return this.original.getExtensions();
            }

            @Override
            public List<String> getMimeTypes() {
                return this.original.getMimeTypes();
            }

            @Override
            public List<String> getNames() {
                return this.original.getNames();
            }

            @Override
            public String getLanguageName() {
                return this.original.getLanguageName();
            }

            @Override
            public String getLanguageVersion() {
                return this.original.getLanguageVersion();
            }

            @Override
            public Object getParameter(String key) {
                return this.original.getParameter(key);
            }

            @Override
            public String getMethodCallSyntax(String obj, String m, String ... args) {
                return this.original.getMethodCallSyntax(obj, m, args);
            }

            @Override
            public String getOutputStatement(String toDisplay) {
                return this.original.getOutputStatement(toDisplay);
            }

            @Override
            public String getProgram(String ... statements) {
                return this.original.getProgram(statements);
            }

            @Override
            public ScriptEngine getScriptEngine() {
                return EngineManager.this.postConfigure(this.original.getScriptEngine());
            }
        }
    }
}

