/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.libs.git.GitRevisionInfo;

public final class GitCherryPickResult {
    private final CherryPickStatus status;
    private final List<File> conflicts;
    private final List<File> failures;
    private final GitRevisionInfo currentHead;
    private final List<GitRevisionInfo> cherryPickedCommits;

    GitCherryPickResult(CherryPickStatus status, List<File> conflicts, List<File> failures, GitRevisionInfo currentHead, List<GitRevisionInfo> cherryPickedCommits) {
        this.status = status;
        this.currentHead = currentHead;
        this.conflicts = conflicts;
        this.failures = failures;
        this.cherryPickedCommits = cherryPickedCommits;
    }

    public CherryPickStatus getCherryPickStatus() {
        return this.status;
    }

    public GitRevisionInfo getCurrentHead() {
        return this.currentHead;
    }

    public Collection<File> getConflicts() {
        return Collections.unmodifiableList(this.conflicts);
    }

    public Collection<File> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public GitRevisionInfo[] getCherryPickedCommits() {
        return this.cherryPickedCommits.toArray(new GitRevisionInfo[this.cherryPickedCommits.size()]);
    }

    public static enum CherryPickStatus {
        OK,
        ABORTED,
        FAILED,
        UNCOMMITTED,
        CONFLICTING;

    }
}

