/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateNodeBuilder;
import com.oracle.truffle.regex.tregex.dfa.NFATransitionSet;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class DFAStateTransitionBuilder
extends TransitionBuilder<NFATransitionSet>
implements JsonConvertible {
    private int id = -1;
    private DFAStateNodeBuilder source;
    private DFAStateNodeBuilder target;

    DFAStateTransitionBuilder(CharSet matcherBuilder, NFATransitionSet transitionSet) {
        super(transitionSet, matcherBuilder);
    }

    public DFAStateTransitionBuilder createNodeSplitCopy() {
        return new DFAStateTransitionBuilder(this.getMatcherBuilder(), (NFATransitionSet)this.getTransitionSet());
    }

    public DFAStateTransitionBuilder createMerged(TransitionBuilder<NFATransitionSet> other, CharSet mergedMatcher) {
        return new DFAStateTransitionBuilder(mergedMatcher, ((NFATransitionSet)this.getTransitionSet()).createMerged(other.getTransitionSet()));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public DFAStateNodeBuilder getSource() {
        return this.source;
    }

    public void setSource(DFAStateNodeBuilder source) {
        this.source = source;
    }

    public DFAStateNodeBuilder getTarget() {
        return this.target;
    }

    public void setTarget(DFAStateNodeBuilder target) {
        this.target = target;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.source + " -" + this.getMatcherBuilder() + "-> " + this.target;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonArray nfaTransitions = Json.array(((NFATransitionSet)this.getTransitionSet()).stream().map(t -> Json.val(t.getId())));
        if (this.target.getAnchoredFinalStateTransition() != null) {
            nfaTransitions.append(Json.val(this.target.getAnchoredFinalStateTransition().getId()));
        }
        if (this.target.getUnAnchoredFinalStateTransition() != null) {
            nfaTransitions.append(Json.val(this.target.getUnAnchoredFinalStateTransition().getId()));
        }
        return Json.obj(Json.prop("id", this.id), Json.prop("source", this.source.getId()), Json.prop("target", this.target.getId()), Json.prop("matcherBuilder", this.getMatcherBuilder().toString()), Json.prop("nfaTransitions", nfaTransitions));
    }
}

