/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.automaton.IndexedState;
import com.oracle.truffle.regex.tregex.nfa.ASTNodeSet;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class NFAState
implements IndexedState,
JsonConvertible {
    private static final byte FLAGS_NONE = 0;
    private static final byte FLAG_HAS_PREFIX_STATES = 1;
    private static final byte FLAG_FORWARD_ANCHORED_FINAL_STATE = 2;
    private static final byte FLAG_FORWARD_UN_ANCHORED_FINAL_STATE = 4;
    private static final byte FLAG_REVERSE_ANCHORED_FINAL_STATE = 8;
    private static final byte FLAG_REVERSE_UN_ANCHORED_FINAL_STATE = 16;
    private static final byte MASK_FORWARD_FINAL_STATES = 6;
    private static final byte MASK_REVERSE_FINAL_STATES = 24;
    private static final NFAStateTransition[] EMPTY_TRANSITIONS = new NFAStateTransition[0];
    private final short id;
    private final ASTNodeSet<? extends RegexASTNode> stateSet;
    @CompilerDirectives.CompilationFinal
    private byte flags;
    @CompilerDirectives.CompilationFinal
    private short transitionToAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short transitionToUnAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short revTransitionToAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short revTransitionToUnAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private NFAStateTransition[] next;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private NFAStateTransition[] prev;
    private short prevLength = 0;
    private List<Integer> possibleResults;
    private final CharSet matcherBuilder;
    private final Set<LookBehindAssertion> finishedLookBehinds;

    public NFAState(short id, ASTNodeSet<? extends RegexASTNode> stateSet, CharSet matcherBuilder, Set<LookBehindAssertion> finishedLookBehinds, boolean hasPrefixStates) {
        this(id, stateSet, hasPrefixStates ? (byte)1 : 0, EMPTY_TRANSITIONS, EMPTY_TRANSITIONS, null, matcherBuilder, finishedLookBehinds);
    }

    private NFAState(short id, ASTNodeSet<? extends RegexASTNode> stateSet, byte flags, CharSet matcherBuilder, Set<LookBehindAssertion> finishedLookBehinds) {
        this(id, stateSet, flags, EMPTY_TRANSITIONS, EMPTY_TRANSITIONS, null, matcherBuilder, finishedLookBehinds);
    }

    private NFAState(short id, ASTNodeSet<? extends RegexASTNode> stateSet, byte flags, NFAStateTransition[] next, NFAStateTransition[] prev, List<Integer> possibleResults, CharSet matcherBuilder, Set<LookBehindAssertion> finishedLookBehinds) {
        this.id = id;
        this.stateSet = stateSet;
        this.flags = flags;
        this.next = next;
        this.prev = prev;
        this.possibleResults = possibleResults;
        this.matcherBuilder = matcherBuilder;
        this.finishedLookBehinds = finishedLookBehinds;
    }

    public NFAState createTraceFinderCopy(short copyID) {
        return new NFAState(copyID, this.getStateSet(), this.getFlags(), this.matcherBuilder, this.finishedLookBehinds);
    }

    public CharSet getCharSet() {
        return this.matcherBuilder;
    }

    public Set<LookBehindAssertion> getFinishedLookBehinds() {
        return this.finishedLookBehinds;
    }

    public ASTNodeSet<? extends RegexASTNode> getStateSet() {
        return this.stateSet;
    }

    private boolean isFlagSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    private void setFlag(byte flag, boolean value) {
        this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
    }

    byte getFlags() {
        return this.flags;
    }

    public boolean hasPrefixStates() {
        return this.isFlagSet((byte)1);
    }

    public void setHasPrefixStates(boolean value) {
        this.setFlag((byte)1, value);
    }

    public boolean isFinalState(boolean forward) {
        return forward ? this.isForwardFinalState() : this.isReverseFinalState();
    }

    public boolean isAnchoredFinalState(boolean forward) {
        return this.isFlagSet(forward ? (byte)2 : 8);
    }

    public boolean isUnAnchoredFinalState(boolean forward) {
        return this.isFlagSet(forward ? (byte)4 : 16);
    }

    public boolean isForwardFinalState() {
        return this.isFlagSet((byte)6);
    }

    public boolean isForwardAnchoredFinalState() {
        return this.isFlagSet((byte)2);
    }

    public void setForwardAnchoredFinalState(boolean value) {
        this.setFlag((byte)2, value);
    }

    public boolean isForwardUnAnchoredFinalState() {
        return this.isFlagSet((byte)4);
    }

    public void setForwardUnAnchoredFinalState(boolean value) {
        this.setFlag((byte)4, value);
    }

    public boolean isReverseFinalState() {
        return this.isFlagSet((byte)24);
    }

    public boolean isReverseAnchoredFinalState() {
        return this.isFlagSet((byte)8);
    }

    public void setReverseAnchoredFinalState(boolean value) {
        this.setFlag((byte)8, value);
    }

    public boolean isReverseUnAnchoredFinalState() {
        return this.isFlagSet((byte)16);
    }

    public void setReverseUnAnchoredFinalState(boolean value) {
        this.setFlag((byte)16, value);
    }

    public boolean hasTransitionToAnchoredFinalState(boolean forward) {
        return (forward ? this.transitionToAnchoredFinalState : this.revTransitionToAnchoredFinalState) >= 0;
    }

    public short getTransitionToAnchoredFinalStateId(boolean forward) {
        return forward ? this.transitionToAnchoredFinalState : this.revTransitionToAnchoredFinalState;
    }

    public NFAStateTransition getTransitionToAnchoredFinalState(boolean forward) {
        assert (this.hasTransitionToAnchoredFinalState(forward));
        return forward ? this.next[this.transitionToAnchoredFinalState] : this.prev[this.revTransitionToAnchoredFinalState];
    }

    public boolean hasTransitionToUnAnchoredFinalState(boolean forward) {
        return (forward ? this.transitionToUnAnchoredFinalState : this.revTransitionToUnAnchoredFinalState) >= 0;
    }

    public NFAStateTransition getTransitionToUnAnchoredFinalState(boolean forward) {
        assert (this.hasTransitionToUnAnchoredFinalState(forward));
        return forward ? this.next[this.transitionToUnAnchoredFinalState] : this.prev[this.revTransitionToUnAnchoredFinalState];
    }

    public short getTransitionToUnAnchoredFinalStateId(boolean forward) {
        return forward ? this.transitionToUnAnchoredFinalState : this.revTransitionToUnAnchoredFinalState;
    }

    public boolean hasTransitionToFinalState(boolean forward) {
        return this.hasTransitionToAnchoredFinalState(forward) || this.hasTransitionToUnAnchoredFinalState(forward);
    }

    public int getFirstTransitionToFinalStateIndex(boolean forward) {
        assert (this.hasTransitionToFinalState(forward));
        return Math.min(Short.toUnsignedInt(this.getTransitionToAnchoredFinalStateId(forward)), Short.toUnsignedInt(this.getTransitionToUnAnchoredFinalStateId(forward)));
    }

    public NFAStateTransition getFirstTransitionToFinalState(boolean forward) {
        return this.getNext(forward)[this.getFirstTransitionToFinalStateIndex(forward)];
    }

    public NFAStateTransition[] getNext() {
        return this.next;
    }

    public NFAStateTransition[] getNext(boolean forward) {
        return forward ? this.next : this.prev;
    }

    public void addLoopBackNext(NFAStateTransition transition) {
        this.updateFinalStateTransitions(transition, (short)this.next.length);
        this.next = Arrays.copyOf(this.next, this.next.length + 1);
        this.next[this.next.length - 1] = transition;
    }

    public void removeLoopBackNext() {
        this.next = Arrays.copyOf(this.next, this.next.length - 1);
        if (this.transitionToAnchoredFinalState == this.next.length) {
            this.transitionToAnchoredFinalState = (short)-1;
        }
        if (this.transitionToUnAnchoredFinalState == this.next.length) {
            this.transitionToUnAnchoredFinalState = (short)-1;
        }
    }

    public void setNext(NFAStateTransition[] transitions, boolean createReverseTransitions) {
        this.next = transitions;
        for (short i = 0; i < transitions.length; i = (short)(i + 1)) {
            NFAStateTransition t = transitions[i];
            this.updateFinalStateTransitions(t, i);
            if (!createReverseTransitions) continue;
            t.getTarget().prevLength = (short)(t.getTarget().prevLength + 1);
        }
    }

    private void updateFinalStateTransitions(NFAStateTransition transition, short i) {
        if (this.transitionToAnchoredFinalState == -1 && transition.getTarget().isForwardAnchoredFinalState()) {
            this.transitionToAnchoredFinalState = i;
        }
        if (this.transitionToUnAnchoredFinalState == -1 && transition.getTarget().isForwardUnAnchoredFinalState()) {
            this.transitionToUnAnchoredFinalState = i;
        }
    }

    public void removeNext(NFAState state) {
        int remove = this.indexOfTransition(state);
        if (remove == -1) {
            return;
        }
        NFAStateTransition[] newNext = new NFAStateTransition[this.next.length - 1];
        System.arraycopy(this.next, 0, newNext, 0, remove);
        System.arraycopy(this.next, remove + 1, newNext, remove, newNext.length - remove);
        this.next = newNext;
        if (this.transitionToAnchoredFinalState == remove) {
            this.transitionToAnchoredFinalState = (short)-1;
        } else if (this.transitionToAnchoredFinalState > remove) {
            this.transitionToAnchoredFinalState = (short)(this.transitionToAnchoredFinalState - 1);
        }
        if (this.transitionToUnAnchoredFinalState == remove) {
            this.transitionToUnAnchoredFinalState = (short)-1;
        } else if (this.transitionToUnAnchoredFinalState > remove) {
            this.transitionToUnAnchoredFinalState = (short)(this.transitionToUnAnchoredFinalState - 1);
        }
    }

    private int indexOfTransition(NFAState target) {
        for (int i = 0; i < this.next.length; ++i) {
            if (this.next[i].getTarget() != target) continue;
            return i;
        }
        return -1;
    }

    public void linkPrev() {
        for (NFAStateTransition t : this.next) {
            if (t.getTarget().prev == EMPTY_TRANSITIONS) {
                t.getTarget().prev = new NFAStateTransition[t.getTarget().prevLength];
            }
            t.getTarget().prevLength = (short)(t.getTarget().prevLength - 1);
            if (this.isReverseAnchoredFinalState()) {
                t.getTarget().revTransitionToAnchoredFinalState = t.getTarget().prevLength;
            }
            if (this.isReverseUnAnchoredFinalState()) {
                t.getTarget().revTransitionToUnAnchoredFinalState = t.getTarget().prevLength;
            }
            t.getTarget().prev[t.getTarget().prevLength] = t;
        }
    }

    public void setPrev(NFAStateTransition[] transitions) {
        this.prev = transitions;
    }

    public NFAStateTransition[] getPrev() {
        return this.prev;
    }

    public NFAStateTransition[] getPrev(boolean forward) {
        return forward ? this.prev : this.next;
    }

    @Override
    public short getId() {
        return this.id;
    }

    public List<Integer> getPossibleResults() {
        if (this.possibleResults == null) {
            return Collections.emptyList();
        }
        return this.possibleResults;
    }

    public boolean hasPossibleResults() {
        return this.possibleResults != null && !this.possibleResults.isEmpty();
    }

    public void addPossibleResult(int index) {
        int searchResult;
        if (this.possibleResults == null) {
            this.possibleResults = new ArrayList<Integer>();
        }
        if ((searchResult = Collections.binarySearch(this.possibleResults, index)) < 0) {
            this.possibleResults.add((searchResult + 1) * -1, index);
        }
    }

    public boolean isDead(boolean forward) {
        return !this.isFinalState(forward) && (this.getNext(forward).length == 0 || this.getNext(forward).length == 1 && this.getNext(forward)[0].getTarget(forward) == this);
    }

    @CompilerDirectives.TruffleBoundary
    public String idToString() {
        return this.getStateSet().stream().map(x -> String.valueOf(x.getId())).collect(Collectors.joining(",", "(", ")")) + "[" + this.id + "]";
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.idToString();
    }

    public boolean equals(Object o) {
        return o instanceof NFAState && this.id == ((NFAState)o).id;
    }

    public int hashCode() {
        return this.id;
    }

    @CompilerDirectives.TruffleBoundary
    private JsonArray sourceSectionsToJson() {
        return Json.array(this.getStateSet().stream().map(x -> this.getStateSet().getAst().getSourceSections((RegexASTNode)x)).filter(Objects::nonNull).flatMap(Collection::stream).map(x -> Json.obj(Json.prop("start", x.getCharIndex()), Json.prop("end", x.getCharEndIndex()))));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson() {
        return Json.obj(Json.prop("id", this.id), Json.prop("stateSet", this.getStateSet().stream().map(x -> Json.val(x.getId()))), Json.prop("sourceSections", this.sourceSectionsToJson()), Json.prop("matcherBuilder", this.matcherBuilder.toString()), Json.prop("forwardAnchoredFinalState", this.isForwardAnchoredFinalState()), Json.prop("forwardUnAnchoredFinalState", this.isForwardUnAnchoredFinalState()), Json.prop("reverseAnchoredFinalState", this.isReverseAnchoredFinalState()), Json.prop("reverseUnAnchoredFinalState", this.isReverseUnAnchoredFinalState()), Json.prop("next", Arrays.stream(this.next).map(x -> Json.val(x.getId()))), Json.prop("prev", Arrays.stream(this.prev).map(x -> Json.val(x.getId()))));
    }

    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson(boolean forward) {
        return Json.obj(Json.prop("id", this.id), Json.prop("stateSet", this.getStateSet().stream().map(x -> Json.val(x.getId()))), Json.prop("sourceSections", this.sourceSectionsToJson()), Json.prop("matcherBuilder", this.matcherBuilder.toString()), Json.prop("anchoredFinalState", this.isAnchoredFinalState(forward)), Json.prop("unAnchoredFinalState", this.isUnAnchoredFinalState(forward)), Json.prop("transitions", Arrays.stream(this.getNext(forward)).map(x -> Json.val(x.getId()))));
    }
}

