/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import java.util.Arrays;

public final class TRegexBacktrackingNFAExecutorLocals
extends TRegexExecutorLocals {
    private final int stackFrameSize;
    private int[] stack;
    private int sp;
    private final int[] result;
    private int lastResultSp = -1;
    private boolean forward = true;

    public TRegexBacktrackingNFAExecutorLocals(Object input, int fromIndex, int index, int maxIndex, int nCaptureGroups) {
        super(input, fromIndex, maxIndex, index);
        this.stackFrameSize = 2 + nCaptureGroups * 2;
        this.stack = new int[this.stackFrameSize * 8];
        this.sp = 0;
        this.result = new int[nCaptureGroups * 2];
        this.setIndex(fromIndex);
        Arrays.fill(this.stack, this.sp + 2, this.stackFrameSize, -1);
    }

    public void switchDirection() {
        this.forward = !this.forward;
    }

    public void apply(NFAStateTransition t) {
        t.getGroupBoundaries().apply(this.stack, this.sp + 2, this.getIndex());
    }

    public void push(NFAStateTransition t) {
        if (this.stack.length < this.sp + this.stackFrameSize * 2) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
        }
        System.arraycopy(this.stack, this.sp, this.stack, this.sp + this.stackFrameSize, this.stackFrameSize);
        t.getGroupBoundaries().apply(this.stack, this.sp + 2, this.getIndex());
        int n = this.sp;
        this.stack[n] = this.stack[n] + 1;
        this.stack[this.sp + 1] = t.getTarget().getId();
        this.sp += this.stackFrameSize;
    }

    public void pushResult(NFAStateTransition t) {
        System.arraycopy(this.stack, this.sp + 2, this.result, 0, this.result.length);
        t.getGroupBoundaries().apply(this.result, 0, this.getIndex());
        this.lastResultSp = this.sp;
    }

    public boolean canPopResult() {
        return this.lastResultSp == this.sp;
    }

    public int[] popResult() {
        return this.result;
    }

    public boolean canPop() {
        return this.sp > 0;
    }

    public int pop() {
        assert (this.sp > 0);
        this.sp -= this.stackFrameSize;
        return this.stack[this.sp + 1];
    }

    @Override
    public int getIndex() {
        return this.stack[this.sp];
    }

    @Override
    public void setIndex(int i) {
        this.stack[this.sp] = i;
    }

    @Override
    public void incIndex(int i) {
        int n = this.sp;
        this.stack[n] = this.stack[n] + (this.forward ? i : -i);
    }

    public int[] toResult() {
        return Arrays.copyOfRange(this.stack, this.sp + 2, this.sp + this.stackFrameSize);
    }

    @CompilerDirectives.TruffleBoundary
    public void printStack(int curPc) {
        for (int i = this.sp; i >= 0; i -= this.stackFrameSize) {
            System.out.print(String.format("pc: %3d, i: %3d, cg: [", i == this.sp ? curPc : this.stack[i + 1], this.stack[i]));
            for (int j = i + 2; j < i + this.stackFrameSize - 1; ++j) {
                System.out.print(String.format("%2d, ", this.stack[j]));
            }
            System.out.println(String.format("%2d]", this.stack[i + this.stackFrameSize - 1]));
        }
    }
}

