/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public final class PreCalcResultVisitor
extends DepthFirstTraversalRegexASTVisitor {
    private final boolean extractLiteral;
    private final boolean unrollGroups;
    private int index = 0;
    private final char[] literal;
    private final char[] mask;
    private final PreCalculatedResultFactory result;
    private PreCalcResultVisitor groupUnroller;

    private PreCalcResultVisitor(RegexAST ast, boolean extractLiteral) {
        this.result = new PreCalculatedResultFactory(ast.getNumberOfCaptureGroups());
        this.extractLiteral = extractLiteral;
        if (extractLiteral) {
            this.literal = new char[ast.getRoot().getMinPath()];
            this.mask = ast.getProperties().hasCharClasses() ? new char[ast.getRoot().getMinPath()] : null;
        } else {
            this.literal = null;
            this.mask = null;
        }
        this.unrollGroups = true;
    }

    private PreCalcResultVisitor(boolean extractLiteral, boolean unrollGroups, int index, char[] literal, char[] mask, PreCalculatedResultFactory result) {
        this.extractLiteral = extractLiteral;
        this.unrollGroups = unrollGroups;
        this.index = index;
        this.literal = literal;
        this.mask = mask;
        this.result = result;
    }

    public static PreCalcResultVisitor run(RegexAST ast, boolean extractLiteral) {
        PreCalcResultVisitor visitor = new PreCalcResultVisitor(ast, extractLiteral);
        visitor.run(ast.getRoot());
        visitor.result.setLength(visitor.index);
        return visitor;
    }

    public static PreCalculatedResultFactory createResultFactory(RegexAST ast) {
        PreCalcResultVisitor visitor = new PreCalcResultVisitor(ast, false);
        visitor.run(ast.getRoot());
        visitor.result.setLength(visitor.index);
        return visitor.result;
    }

    public String getLiteral() {
        return new String(this.literal);
    }

    public boolean hasMask() {
        return this.mask != null;
    }

    public String getMask() {
        return this.mask == null ? null : new String(this.mask);
    }

    public PreCalculatedResultFactory getResultFactory() {
        return this.result;
    }

    @Override
    protected void visit(BackReference backReference) {
        throw new IllegalArgumentException();
    }

    @Override
    protected void visit(Group group) {
        if (group.isCapturing()) {
            this.result.setStart(group.getGroupNumber(), this.index);
        }
    }

    @Override
    protected void leave(Group group) {
        if (group.isCapturing()) {
            this.result.setEnd(group.getGroupNumber(), this.index);
        }
        if (this.unrollGroups && group.hasQuantifier()) {
            assert (group.getQuantifier().getMin() == group.getQuantifier().getMax());
            if (this.groupUnroller == null) {
                this.groupUnroller = new PreCalcResultVisitor(this.extractLiteral, false, this.index, this.literal, this.mask, this.result);
            }
            this.groupUnroller.index = this.index;
            for (int i = 0; i < group.getQuantifier().getMin() - 1; ++i) {
                this.groupUnroller.run(group);
            }
            this.index = this.groupUnroller.index;
        }
    }

    @Override
    protected void visit(Sequence sequence) {
    }

    @Override
    protected void visit(PositionAssertion assertion) {
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        throw new IllegalArgumentException();
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        throw new IllegalArgumentException();
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        assert (!characterClass.hasQuantifier() || characterClass.getQuantifier().getMin() == characterClass.getQuantifier().getMax());
        for (int i = 0; i < (characterClass.hasQuantifier() ? characterClass.getQuantifier().getMin() : 1); ++i) {
            if (this.extractLiteral) {
                if (this.mask == null) {
                    this.literal[this.index] = (char)characterClass.getCharSet().getLo(0);
                } else {
                    characterClass.extractSingleChar(this.literal, this.mask, this.index);
                }
            }
            ++this.index;
        }
    }

    @Override
    protected void visit(MatchFound matchFound) {
    }
}

