/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.data;

import java.io.File;
import org.netbeans.modules.glassfish.tooling.data.DataException;
import org.netbeans.modules.glassfish.tooling.data.GlassFishAdminInterface;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;

public class GlassFishServerEntity
implements GlassFishServer {
    private String name;
    private String url;
    private String host;
    private int port;
    private int adminPort;
    private String adminUser;
    private String adminPassword;
    private String domainsFolder;
    private String domainName;
    private String serverHome;
    private String serverRoot;
    private GlassFishVersion version;
    private GlassFishAdminInterface adminInterface;

    public GlassFishServerEntity() {
    }

    public GlassFishServerEntity(String serverName, String serverRoot, String serverHome, String serverUrl) {
        if (serverRoot == null) {
            throw new DataException("GlassFish installation root directory is null");
        }
        if (serverHome == null) {
            throw new DataException("GlassFish home directory is null");
        }
        if (serverUrl == null) {
            throw new DataException("GlassFish URL is null");
        }
        File root = new File(serverHome);
        if (!root.isDirectory()) {
            throw new DataException("GlassFish installation root directory {0} does not exist", serverHome);
        }
        File home = new File(serverHome);
        if (!home.isDirectory()) {
            throw new DataException("GlassFish home directory {0} does not exist", serverHome);
        }
        this.version = ServerUtils.getServerVersion(serverHome);
        if (this.version == null) {
            throw new DataException("Unknown GlassFish version in home directory {0}", serverHome);
        }
        this.name = serverName;
        this.url = serverUrl;
        this.serverRoot = serverRoot;
        this.serverHome = serverHome;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    @Override
    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    @Override
    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    @Override
    public String getDomainsFolder() {
        return this.domainsFolder;
    }

    public void setDomainsFolder(String domainsFolder) {
        this.domainsFolder = domainsFolder;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public String getServerHome() {
        return this.serverHome;
    }

    public void setServerHome(String serverHome) {
        this.serverHome = serverHome;
    }

    @Override
    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    @Override
    public GlassFishVersion getVersion() {
        return this.version;
    }

    public void setVersion(GlassFishVersion version) {
        this.version = version;
    }

    @Override
    public GlassFishAdminInterface getAdminInterface() {
        return this.adminInterface;
    }

    public void setAdminInterface(GlassFishAdminInterface adminInterface) {
        this.adminInterface = adminInterface;
    }

    @Override
    public boolean isRemote() {
        return this.domainsFolder == null;
    }
}

