/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;

    public JcePGPDataEncryptorBuilder(int n) {
        this.encAlgorithm = n;
        if (n == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    public JcePGPDataEncryptorBuilder setWithIntegrityPacket(boolean bl) {
        this.withIntegrityPacket = bl;
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public JcePGPDataEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public PGPDataEncryptor build(byte[] byArray) throws PGPException {
        return new MyPGPDataEncryptor(byArray);
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final Cipher c;

        MyPGPDataEncryptor(byte[] byArray) throws PGPException {
            this.c = JcePGPDataEncryptorBuilder.this.helper.createStreamCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.withIntegrityPacket);
            try {
                if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                    byte[] byArray2 = new byte[this.c.getBlockSize()];
                    this.c.init(1, (Key)PGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, byArray), new IvParameterSpec(byArray2));
                } else {
                    this.c.init(1, PGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, byArray));
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new PGPException("imvalid algorithm parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
        }

        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.c);
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

