# "Catalog of Parameters for 150 Milky Way Globular Clusters",
#
# 2003 Update, by William E. Harris.
# http://physwww.physics.mcmaster.ca/~harris/mwgc.dat
# Bibliography: http://physwww.mcmaster.ca/%7Eharris/mwgc.ref
#
# Supplemented by diameters <=> 25mu isophote from
# Brian A. Skiff/Lowell Observatory, NGC/IC project,
# http://www.ngcic.org/data_archive/gc.txt.
#
# Supplemented by diameters <=> 25mu isophote from
# the SEDS 2007 catalog (H. Frommert)
# http://www.seds.org/~spider/spider/MWGC/mwgc.html.
#
# Supplemented by a cross-index for alternate identifiers
# generated from and compatible with the SIMBAD world data base,
# using the batch interface
# http://simbad.u-strasbg.fr/simbad/sim-fscript.
#
# Adapted for Celestia with Perl script: globulars.pl Revision: 1.0.0 
# Processed 2009-2-4 3 34 0 11:41:11 UTC
#
# by Dr. Fridger Schrempp, fridger.schrempp@desy.de
# ------------------------------------------------------ 


Globular "47 Tuc:NGC 104:Melotte 1:HD 2051:RBS 55:GCl 1:C 0021-723:xi Tuc"
{
        RA          	    0.4014  # [hours]
        Dec         	  -72.0808  # [degrees]
        Distance    	 1.468e+04  # [ly]
        Radius      	     106.7  # [ly], mu25 Isophote
        CoreRadius  	       0.4  # [arcmin]
        KingConcentration     2.03  # c = log10(r_t/r_c)
        AbsMag      	     -9.42  # [V mags]
        Axis       	[ -0.7429  -0.2364  -0.6263]
        Angle       	     175.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 104"
}

Globular "NGC 288:Melotte 3:GCl 2:C 0050-268"
{
        RA          	    0.8797  # [hours]
        Dec         	  -26.5900  # [degrees]
        Distance    	  2.87e+04  # [ly]
        Radius      	     54.27  # [ly], mu25 Isophote
        CoreRadius  	      1.42  # [arcmin]
        KingConcentration     0.96  # c = log10(r_t/r_c)
        AbsMag      	     -6.74  # [V mags]
        Axis       	[  0.7644   0.4432   0.4683]
        Angle       	     148.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 288"
}

Globular "NGC 362:Melotte 4:LI-SMC 158:GCl 3:C 0100-711"
{
        RA          	    1.0539  # [hours]
        Dec         	  -70.8483  # [degrees]
        Distance    	 2.772e+04  # [ly]
        Radius      	     56.45  # [ly], mu25 Isophote
        CoreRadius  	      0.19  # [arcmin]
        KingConcentration     1.93  # c = log10(r_t/r_c)
        AbsMag      	     -8.41  # [V mags]
        Axis       	[ -0.7974  -0.2191  -0.5622]
        Angle       	     176.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 362"
}

Globular "NGC 1261:GCl 5:C 0310-554"
{
        RA          	    3.2042  # [hours]
        Dec         	  -55.2169  # [degrees]
        Distance    	 5.349e+04  # [ly]
        Radius      	      52.9  # [ly], mu25 Isophote
        CoreRadius  	      0.39  # [arcmin]
        KingConcentration     1.27  # c = log10(r_t/r_c)
        AbsMag      	     -7.81  # [V mags]
        Axis       	[  0.9332   0.1748    0.314]
        Angle       	     169.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1261"
}

Globular "Pal 1:ZW VII 7:LEDA 13165:C 0325+794"
{
        RA          	    3.5564  # [hours]
        Dec         	   79.5806  # [degrees]
        Distance    	 3.555e+04  # [ly]
        Radius      	     14.48  # [ly], mu25 Isophote
        CoreRadius  	      0.22  # [arcmin]
        KingConcentration     1.61  # c = log10(r_t/r_c)
        AbsMag      	     -2.47  # [V mags]
        Axis       	[  0.6602   0.7462 -0.08515]
        Angle       	      49.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 1"
}

Globular "AM 1:Name E1:LEDA 14098:ESO 201-10:C 0354-498:C 0353-497"
{
        RA          	    3.9172  # [hours]
        Dec         	  -49.6144  # [degrees]
        Distance    	 3.976e+05  # [ly]
        Radius      	     28.91  # [ly], mu25 Isophote
        CoreRadius  	      0.15  # [arcmin]
        KingConcentration     1.11  # c = log10(r_t/r_c)
        AbsMag      	     -4.71  # [V mags]
        Axis       	[  0.9623   0.1438   0.2309]
        Angle       	     163.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Name E1"
}

Globular "Eridanus:Name ERI star cluster:Name CL ERID 1:C 0422-213"
{
        RA          	    4.0679  # [hours]
        Dec         	   -1.0175  # [degrees]
        Distance    	 2.942e+05  # [ly]
        Radius      	     42.79  # [ly], mu25 Isophote
        CoreRadius  	      0.25  # [arcmin]
        KingConcentration     1.10  # c = log10(r_t/r_c)
        AbsMag      	     -5.14  # [V mags]
        Axis       	[  0.9559   0.2442   0.1634]
        Angle       	     116.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Eridanus"
}

Globular "Pal 2:C 0443+313"
{
        RA          	    4.7681  # [hours]
        Dec         	   31.3808  # [degrees]
        Distance    	 9.002e+04  # [ly]
        Radius      	     28.81  # [ly], mu25 Isophote
        CoreRadius  	      0.24  # [arcmin]
        KingConcentration     1.45  # c = log10(r_t/r_c)
        AbsMag      	     -8.01  # [V mags]
        Axis       	[  0.9706   0.2293  0.07269]
        Angle       	     83.75  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 2"
}

Globular "NGC 1851:GCl 9:C 0512-400"
{
        RA          	    5.2350  # [hours]
        Dec         	  -40.0472  # [degrees]
        Distance    	 3.947e+04  # [ly]
        Radius      	     68.88  # [ly], mu25 Isophote
        CoreRadius  	      0.06  # [arcmin]
        KingConcentration     2.29  # c = log10(r_t/r_c)
        AbsMag      	     -8.33  # [V mags]
        Axis       	[  0.9947  0.06136  0.08233]
        Angle       	     153.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1851"
}

Globular "M 79:NGC 1904:GCl 10:C 0522-245"
{
        RA          	    5.4028  # [hours]
        Dec         	  -24.5242  # [degrees]
        Distance    	 4.208e+04  # [ly]
        Radius      	     58.75  # [ly], mu25 Isophote
        CoreRadius  	      0.16  # [arcmin]
        KingConcentration     1.72  # c = log10(r_t/r_c)
        AbsMag      	     -7.86  # [V mags]
        Axis       	[  0.9965  0.05857  0.05969]
        Angle       	     138.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 1904"
}

Globular "NGC 2298:C 0647-359"
{
        RA          	    6.8164  # [hours]
        Dec         	  -36.0053  # [degrees]
        Distance    	  3.49e+04  # [ly]
        Radius      	     25.38  # [ly], mu25 Isophote
        CoreRadius  	      0.34  # [arcmin]
        KingConcentration     1.28  # c = log10(r_t/r_c)
        AbsMag      	      -6.3  # [V mags]
        Axis       	[  0.9939 -0.06913 -0.08623]
        Angle       	     149.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2298"
}

Globular "NGC 2419:GCl 12:C 0734+390"
{
        RA          	    7.6356  # [hours]
        Dec         	   38.8819  # [degrees]
        Distance    	 2.746e+05  # [ly]
        Radius      	     183.7  # [ly], mu25 Isophote
        CoreRadius  	      0.35  # [arcmin]
        KingConcentration     1.40  # c = log10(r_t/r_c)
        AbsMag      	     -9.58  # [V mags]
        Axis       	[  0.9412  -0.3281 -0.08082]
        Angle       	     77.93  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2419"
}

Globular "Pyxis:C J0908-373:C J0907-372"
{
        RA          	    9.1325  # [hours]
        Dec         	  -37.2214  # [degrees]
        Distance    	 1.295e+05  # [ly]
        Radius      	     37.67  # [ly], mu25 Isophote
        CoreRadius  	      1.38  # [arcmin]
        KingConcentration     0.65  # c = log10(r_t/r_c)
        AbsMag      	     -5.75  # [V mags]
        Axis       	[  0.9122  -0.2529  -0.3225]
        Angle       	     153.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pyxis"
}

Globular "NGC 2808:GCl 13:C 0911-646"
{
        RA          	    9.2006  # [hours]
        Dec         	  -64.8631  # [degrees]
        Distance    	 3.131e+04  # [ly]
        Radius      	     63.76  # [ly], mu25 Isophote
        CoreRadius  	      0.26  # [arcmin]
        KingConcentration     1.78  # c = log10(r_t/r_c)
        AbsMag      	     -9.39  # [V mags]
        Axis       	[  0.9135  -0.1673  -0.3708]
        Angle       	     178.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 2808"
}

Globular "Name E3:Name E 3:ESO 37-1:C 0921-770"
{
        RA          	    9.3497  # [hours]
        Dec         	  -77.2825  # [degrees]
        Distance    	 1.403e+04  # [ly]
        Radius      	      20.4  # [ly], mu25 Isophote
        CoreRadius  	      1.87  # [arcmin]
        KingConcentration     0.75  # c = log10(r_t/r_c)
        AbsMag      	     -2.77  # [V mags]
        Axis       	[ -0.9047   0.1322   0.4051]
        Angle       	     170.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Name E3"
}

Globular "Pal 3:Name SEX C:SPB 132:UGC 5439:C 1003+003"
{
        RA          	   10.0919  # [hours]
        Dec         	    0.0714  # [degrees]
        Distance    	 3.024e+05  # [ly]
        Radius      	     70.36  # [ly], mu25 Isophote
        CoreRadius  	      0.48  # [arcmin]
        KingConcentration     1.00  # c = log10(r_t/r_c)
        AbsMag      	      -5.7  # [V mags]
        Axis       	[  0.8153  -0.4843  -0.3174]
        Angle       	     123.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 3"
}

Globular "NGC 3201:GCl 15:C 1015-461"
{
        RA          	   10.2933  # [hours]
        Dec         	  -46.4111  # [degrees]
        Distance    	 1.631e+04  # [ly]
        Radius      	     47.44  # [ly], mu25 Isophote
        CoreRadius  	      1.43  # [arcmin]
        KingConcentration     1.30  # c = log10(r_t/r_c)
        AbsMag      	     -7.46  # [V mags]
        Axis       	[  0.8424  -0.2975  -0.4492]
        Angle       	       163  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 3201"
}

Globular "Pal 4:UGCA 237:GCl 17:C 1126+292"
{
        RA          	   11.4878  # [hours]
        Dec         	   28.9736  # [degrees]
        Distance    	 3.562e+05  # [ly]
        Radius      	     67.34  # [ly], mu25 Isophote
        CoreRadius  	      0.55  # [arcmin]
        KingConcentration     0.78  # c = log10(r_t/r_c)
        AbsMag      	     -6.02  # [V mags]
        Axis       	[  0.6096  -0.7505  -0.2554]
        Angle       	     112.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 4"
}

Globular "NGC 4147:GCl 18:C 1207+188"
{
        RA          	   12.1683  # [hours]
        Dec         	   18.5419  # [degrees]
        Distance    	 6.295e+04  # [ly]
        Radius      	     40.29  # [ly], mu25 Isophote
        CoreRadius  	       0.1  # [arcmin]
        KingConcentration     1.80  # c = log10(r_t/r_c)
        AbsMag      	     -6.16  # [V mags]
        Axis       	[  0.5761  -0.7466  -0.3326]
        Angle       	     124.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4147"
}

Globular "NGC 4372:GCl 19:C 1223-724"
{
        RA          	   12.4292  # [hours]
        Dec         	  -72.6592  # [degrees]
        Distance    	 1.892e+04  # [ly]
        Radius      	     13.76  # [ly], mu25 Isophote
        CoreRadius  	      1.75  # [arcmin]
        KingConcentration     1.30  # c = log10(r_t/r_c)
        AbsMag      	     -7.77  # [V mags]
        Axis       	[ -0.6658     0.26   0.6994]
        Angle       	     175.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4372"
}

Globular "Ruprecht 106:C 1236-508:C 1235-509"
{
        RA          	   12.6444  # [hours]
        Dec         	  -51.1503  # [degrees]
        Distance    	 6.915e+04  # [ly]
        Radius      	     20.11  # [ly], mu25 Isophote
        CoreRadius  	         1  # [arcmin]
        KingConcentration     0.70  # c = log10(r_t/r_c)
        AbsMag      	     -6.35  # [V mags]
        Axis       	[  0.6416  -0.3967  -0.6565]
        Angle       	     170.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Ruprecht 106"
}

Globular "M 68:NGC 4590:HD 110032:GCl 20:C 1236-264"
{
        RA          	   12.6578  # [hours]
        Dec         	  -26.7428  # [degrees]
        Distance    	 3.327e+04  # [ly]
        Radius      	     53.23  # [ly], mu25 Isophote
        CoreRadius  	      0.69  # [arcmin]
        KingConcentration     1.64  # c = log10(r_t/r_c)
        AbsMag      	     -7.35  # [V mags]
        Axis       	[  0.6203  -0.5384  -0.5704]
        Angle       	     154.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4590"
}

Globular "NGC 4833:GCl 21:C 1256-706"
{
        RA          	   12.9931  # [hours]
        Dec         	  -70.8747  # [degrees]
        Distance    	  2.12e+04  # [ly]
        Radius      	     43.17  # [ly], mu25 Isophote
        CoreRadius  	         1  # [arcmin]
        KingConcentration     1.25  # c = log10(r_t/r_c)
        AbsMag      	     -8.16  # [V mags]
        Axis       	[ -0.6092   0.2878   0.7389]
        Angle       	     177.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 4833"
}

Globular "M 53:NGC 5024:GCl 22:C 1310+184"
{
        RA          	   13.2153  # [hours]
        Dec         	   18.1692  # [degrees]
        Distance    	 5.806e+04  # [ly]
        Radius      	     109.8  # [ly], mu25 Isophote
        CoreRadius  	      0.36  # [arcmin]
        KingConcentration     1.78  # c = log10(r_t/r_c)
        AbsMag      	      -8.7  # [V mags]
        Axis       	[  0.4714  -0.8044  -0.3615]
        Angle       	     133.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5024"
}

Globular "NGC 5053:GCl 23:C 1313+179"
{
        RA          	   13.2742  # [hours]
        Dec         	   17.6981  # [degrees]
        Distance    	 5.349e+04  # [ly]
        Radius      	      77.8  # [ly], mu25 Isophote
        CoreRadius  	      1.98  # [arcmin]
        KingConcentration     0.84  # c = log10(r_t/r_c)
        AbsMag      	     -6.72  # [V mags]
        Axis       	[  0.4668  -0.8052  -0.3658]
        Angle       	     134.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5053"
}

Globular "Omega Cen:NGC 5139:HD 116790:GCl 24:C 1323-472"
{
        RA          	   13.4458  # [hours]
        Dec         	  -47.4769  # [degrees]
        Distance    	 1.729e+04  # [ly]
        Radius      	     138.3  # [ly], mu25 Isophote
        CoreRadius  	       1.4  # [arcmin]
        KingConcentration     1.61  # c = log10(r_t/r_c)
        AbsMag      	    -10.29  # [V mags]
        Axis       	[  0.5561  -0.4524  -0.6972]
        Angle       	     169.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5139"
}

Globular "M 3:NGC 5272:GCl 25:C 1339+286"
{
        RA          	   13.7031  # [hours]
        Dec         	   28.3756  # [degrees]
        Distance    	 3.392e+04  # [ly]
        Radius      	     88.81  # [ly], mu25 Isophote
        CoreRadius  	      0.55  # [arcmin]
        KingConcentration     1.84  # c = log10(r_t/r_c)
        AbsMag      	     -8.93  # [V mags]
        Axis       	[   0.392  -0.8693  -0.3009]
        Angle       	     133.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5272"
}

Globular "NGC 5286:GCl 26:C 1343-511"
{
        RA          	   13.7739  # [hours]
        Dec         	  -51.3733  # [degrees]
        Distance    	 3.588e+04  # [ly]
        Radius      	      57.4  # [ly], mu25 Isophote
        CoreRadius  	      0.29  # [arcmin]
        KingConcentration     1.46  # c = log10(r_t/r_c)
        AbsMag      	     -8.61  # [V mags]
        Axis       	[  0.5221  -0.4397  -0.7308]
        Angle       	       172  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5286"
}

Globular "AM 4:C 1353-269"
{
        RA          	   13.9306  # [hours]
        Dec         	  -27.1728  # [degrees]
        Distance    	 9.752e+04  # [ly]
        Radius      	     42.55  # [ly], mu25 Isophote
        CoreRadius  	      0.42  # [arcmin]
        KingConcentration     0.50  # c = log10(r_t/r_c)
        AbsMag      	      -1.6  # [V mags]
        Axis       	[  0.4853  -0.5978  -0.6381]
        Angle       	     160.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=AM 4"
}

Globular "NGC 5466:GCl 27:C 1403+287"
{
        RA          	   14.0908  # [hours]
        Dec         	   28.5344  # [degrees]
        Distance    	 5.186e+04  # [ly]
        Radius      	     67.89  # [ly], mu25 Isophote
        CoreRadius  	      1.64  # [arcmin]
        KingConcentration     1.32  # c = log10(r_t/r_c)
        AbsMag      	     -6.96  # [V mags]
        Axis       	[  0.3545  -0.8841  -0.3046]
        Angle       	     137.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5466"
}

Globular "NGC 5634:GCl 28:C 1427-057"
{
        RA          	   14.4936  # [hours]
        Dec         	   -5.9764  # [degrees]
        Distance    	 8.219e+04  # [ly]
        Radius      	     65.75  # [ly], mu25 Isophote
        CoreRadius  	      0.21  # [arcmin]
        KingConcentration     1.60  # c = log10(r_t/r_c)
        AbsMag      	     -7.69  # [V mags]
        Axis       	[  0.3925  -0.7416  -0.5441]
        Angle       	     154.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5634"
}

Globular "NGC 5694:GCl 29:C 1436-263"
{
        RA          	   14.6600  # [hours]
        Dec         	  -26.5383  # [degrees]
        Distance    	 1.132e+05  # [ly]
        Radius      	     70.78  # [ly], mu25 Isophote
        CoreRadius  	      0.06  # [arcmin]
        KingConcentration     1.85  # c = log10(r_t/r_c)
        AbsMag      	     -7.81  # [V mags]
        Axis       	[  0.4021  -0.6297  -0.6647]
        Angle       	     163.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5694"
}

Globular "IC 4499:GCl 30:C 1452-820"
{
        RA          	   15.0050  # [hours]
        Dec         	  -82.2136  # [degrees]
        Distance    	 6.165e+04  # [ly]
        Radius      	     71.73  # [ly], mu25 Isophote
        CoreRadius  	      0.96  # [arcmin]
        KingConcentration     1.11  # c = log10(r_t/r_c)
        AbsMag      	     -7.33  # [V mags]
        Axis       	[  -0.379   0.2491   0.8912]
        Angle       	       174  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=IC 4499"
}

Globular "NGC 5824:GCl 31:C 1500-328"
{
        RA          	   15.0661  # [hours]
        Dec         	  -33.0678  # [degrees]
        Distance    	 1.044e+05  # [ly]
        Radius      	     112.3  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     2.49  # c = log10(r_t/r_c)
        AbsMag      	     -8.84  # [V mags]
        Axis       	[  0.3609  -0.6018  -0.7125]
        Angle       	     167.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5824"
}

Globular "Pal 5:Name Serpens Dwarf:UGC 9792:GCl 32:C 1513+000"
{
        RA          	   15.2681  # [hours]
        Dec         	   -0.1114  # [degrees]
        Distance    	 7.567e+04  # [ly]
        Radius      	     35.22  # [ly], mu25 Isophote
        CoreRadius  	      3.25  # [arcmin]
        KingConcentration     0.70  # c = log10(r_t/r_c)
        AbsMag      	     -5.17  # [V mags]
        Axis       	[  0.2984  -0.7974  -0.5245]
        Angle       	     157.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 5"
}

Globular "NGC 5897:GCl 33:C 1514-208"
{
        RA          	   15.2900  # [hours]
        Dec         	  -21.0103  # [degrees]
        Distance    	 4.044e+04  # [ly]
        Radius      	     64.71  # [ly], mu25 Isophote
        CoreRadius  	      1.96  # [arcmin]
        KingConcentration     0.79  # c = log10(r_t/r_c)
        AbsMag      	     -7.21  # [V mags]
        Axis       	[  0.3232  -0.6832  -0.6548]
        Angle       	     164.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5897"
}

Globular "M 5:NGC 5904:GCl 34:C 1516+022"
{
        RA          	   15.3092  # [hours]
        Dec         	    2.0828  # [degrees]
        Distance    	 2.446e+04  # [ly]
        Radius      	     81.83  # [ly], mu25 Isophote
        CoreRadius  	      0.42  # [arcmin]
        KingConcentration     1.83  # c = log10(r_t/r_c)
        AbsMag      	     -8.81  # [V mags]
        Axis       	[  0.2905  -0.8094  -0.5105]
        Angle       	     157.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5904"
}

Globular "NGC 5927:VDBH 173:GCl 35:C 1524-505"
{
        RA          	   15.4667  # [hours]
        Dec         	  -50.6728  # [degrees]
        Distance    	 2.479e+04  # [ly]
        Radius      	     21.63  # [ly], mu25 Isophote
        CoreRadius  	      0.42  # [arcmin]
        KingConcentration     1.60  # c = log10(r_t/r_c)
        AbsMag      	      -7.8  # [V mags]
        Axis       	[  0.3228  -0.4929   -0.808]
        Angle       	     174.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5927"
}

Globular "NGC 5946:VDBH 175:GCl 36:C 1531-504"
{
        RA          	   15.5911  # [hours]
        Dec         	  -50.6594  # [degrees]
        Distance    	 3.457e+04  # [ly]
        Radius      	     15.09  # [ly], mu25 Isophote
        CoreRadius  	      0.08  # [arcmin]
        KingConcentration     2.48  # c = log10(r_t/r_c)
        AbsMag      	      -7.2  # [V mags]
        Axis       	[  0.3074  -0.4956  -0.8123]
        Angle       	     175.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5946"
}

Globular "VDBH 176:ESO 224-8:C 1535-499"
{
        RA          	   15.6519  # [hours]
        Dec         	  -50.0506  # [degrees]
        Distance    	 5.088e+04  # [ly]
        Radius      	      22.2  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -4.35  # [V mags]
        Axis       	[  0.2997  -0.5012  -0.8118]
        Angle       	       175  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=VDBH 176"
}

Globular "NGC 5986:GCl 37:ESO 329-18:C 1542-376"
{
        RA          	   15.7675  # [hours]
        Dec         	  -37.7861  # [degrees]
        Distance    	 3.392e+04  # [ly]
        Radius      	     47.36  # [ly], mu25 Isophote
        CoreRadius  	      0.63  # [arcmin]
        KingConcentration     1.22  # c = log10(r_t/r_c)
        AbsMag      	     -8.44  # [V mags]
        Axis       	[  0.2798  -0.5888  -0.7583]
        Angle       	     171.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 5986"
}

Globular "Lynga 7:VDBH 184:ESO 178-11:C 1607-551"
{
        RA          	   16.1842  # [hours]
        Dec         	  -55.3144  # [degrees]
        Distance    	 2.348e+04  # [ly]
        Radius      	     8.539  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -6.86  # unknown!! Data base average used
        Axis       	[  0.2344  -0.4722  -0.8497]
        Angle       	     177.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Lynga 7"
}

Globular "Pal 14:Cl Arp 1:GCl 38:C 1608+150"
{
        RA          	   16.1844  # [hours]
        Dec         	   14.9581  # [degrees]
        Distance    	  2.41e+05  # [ly]
        Radius      	     77.13  # [ly], mu25 Isophote
        CoreRadius  	      0.94  # [arcmin]
        KingConcentration     0.75  # c = log10(r_t/r_c)
        AbsMag      	     -4.73  # [V mags]
        Axis       	[  0.1805  -0.8855  -0.4281]
        Angle       	     162.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 14"
}

Globular "M 80:NGC 6093:GCl 39:C 1614-228"
{
        RA          	   16.2839  # [hours]
        Dec         	  -22.9750  # [degrees]
        Distance    	 3.262e+04  # [ly]
        Radius      	     47.44  # [ly], mu25 Isophote
        CoreRadius  	      0.15  # [arcmin]
        KingConcentration     1.95  # c = log10(r_t/r_c)
        AbsMag      	     -8.23  # [V mags]
        Axis       	[  0.2075  -0.6945  -0.6889]
        Angle       	     170.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6093"
}

Globular "M 4:NGC 6121:GCl 41:C 1620-264"
{
        RA          	   16.3931  # [hours]
        Dec         	  -26.5253  # [degrees]
        Distance    	      7176  # [ly]
        Radius      	     37.57  # [ly], mu25 Isophote
        CoreRadius  	      0.83  # [arcmin]
        KingConcentration     1.59  # c = log10(r_t/r_c)
        AbsMag      	      -7.2  # [V mags]
        Axis       	[  0.1967  -0.6744  -0.7117]
        Angle       	     171.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6121"
}

Globular "NGC 6101:GCl 40:C 1620-720"
{
        RA          	   16.4300  # [hours]
        Dec         	  -72.2017  # [degrees]
        Distance    	  4.99e+04  # [ly]
        Radius      	     36.29  # [ly], mu25 Isophote
        CoreRadius  	      1.15  # [arcmin]
        KingConcentration     0.80  # c = log10(r_t/r_c)
        AbsMag      	     -6.91  # [V mags]
        Axis       	[ -0.2038   0.3448   0.9163]
        Angle       	     178.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6101"
}

Globular "NGC 6144:GCl 42:C 1624-259"
{
        RA          	   16.4539  # [hours]
        Dec         	  -26.0247  # [degrees]
        Distance    	 2.772e+04  # [ly]
        Radius      	     68.55  # [ly], mu25 Isophote
        CoreRadius  	      0.94  # [arcmin]
        KingConcentration     1.55  # c = log10(r_t/r_c)
        AbsMag      	     -6.75  # [V mags]
        Axis       	[   0.189  -0.6785  -0.7098]
        Angle       	       172  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6144"
}

Globular "NGC 6139:GCl 43:C 1624-387"
{
        RA          	   16.4611  # [hours]
        Dec         	  -38.8489  # [degrees]
        Distance    	 3.294e+04  # [ly]
        Radius      	     39.29  # [ly], mu25 Isophote
        CoreRadius  	      0.14  # [arcmin]
        KingConcentration     1.78  # c = log10(r_t/r_c)
        AbsMag      	     -8.36  # [V mags]
        Axis       	[  0.1945  -0.5944  -0.7803]
        Angle       	     174.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6139"
}

Globular "Terzan 3:GCl 43.1:ESO 390-6:C 1625-352"
{
        RA          	   16.4778  # [hours]
        Dec         	  -35.3536  # [degrees]
        Distance    	 2.446e+04  # [ly]
        Radius      	     10.67  # [ly], mu25 Isophote
        CoreRadius  	      1.18  # [arcmin]
        KingConcentration     0.70  # c = log10(r_t/r_c)
        AbsMag      	     -4.61  # [V mags]
        Axis       	[  0.1909  -0.6183  -0.7624]
        Angle       	     173.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 3"
}

Globular "M 107:NGC 6171:GCl 44:C 1629-129"
{
        RA          	   16.5419  # [hours]
        Dec         	  -13.0536  # [degrees]
        Distance    	 2.087e+04  # [ly]
        Radius      	     39.47  # [ly], mu25 Isophote
        CoreRadius  	      0.54  # [arcmin]
        KingConcentration     1.51  # c = log10(r_t/r_c)
        AbsMag      	     -7.13  # [V mags]
        Axis       	[    0.17   -0.757  -0.6309]
        Angle       	     170.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6171"
}

Globular "ESO 452-SC11:ESO 452-11:C 1636-283"
{
        RA          	   16.6569  # [hours]
        Dec         	  -28.3978  # [degrees]
        Distance    	 2.544e+04  # [ly]
        Radius      	      4.44  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -3.97  # [V mags]
        Axis       	[  0.1656  -0.6665  -0.7269]
        Angle       	     173.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=ESO 452-SC11"
}

Globular "M 13:NGC 6205:GCl 45:C 1639+365"
{
        RA          	   16.6947  # [hours]
        Dec         	   36.4603  # [degrees]
        Distance    	 2.511e+04  # [ly]
        Radius      	     73.06  # [ly], mu25 Isophote
        CoreRadius  	      0.78  # [arcmin]
        KingConcentration     1.51  # c = log10(r_t/r_c)
        AbsMag      	      -8.7  # [V mags]
        Axis       	[  0.1068  -0.9602  -0.2582]
        Angle       	     164.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6205"
}

Globular "NGC 6229:GCl 47:C 1645+476"
{
        RA          	   16.7828  # [hours]
        Dec         	   47.5278  # [degrees]
        Distance    	 9.915e+04  # [ly]
        Radius      	      64.9  # [ly], mu25 Isophote
        CoreRadius  	      0.13  # [arcmin]
        KingConcentration     1.62  # c = log10(r_t/r_c)
        AbsMag      	     -8.05  # [V mags]
        Axis       	[ 0.08709  -0.9825  -0.1647]
        Angle       	     164.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6229"
}

Globular "M 12:NGC 6218:GCl 46:C 1644-018"
{
        RA          	   16.7872  # [hours]
        Dec         	   -1.9478  # [degrees]
        Distance    	 1.598e+04  # [ly]
        Radius      	     37.19  # [ly], mu25 Isophote
        CoreRadius  	      0.72  # [arcmin]
        KingConcentration     1.39  # c = log10(r_t/r_c)
        AbsMag      	     -7.32  # [V mags]
        Axis       	[  0.1341  -0.8191  -0.5578]
        Angle       	     170.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6218"
}

Globular "NGC 6235:GCl 48:C 1650-220"
{
        RA          	   16.8903  # [hours]
        Dec         	  -22.1772  # [degrees]
        Distance    	 3.718e+04  # [ly]
        Radius      	     27.04  # [ly], mu25 Isophote
        CoreRadius  	      0.36  # [arcmin]
        KingConcentration     1.33  # c = log10(r_t/r_c)
        AbsMag      	     -6.44  # [V mags]
        Axis       	[  0.1342  -0.7084  -0.6929]
        Angle       	     173.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6235"
}

Globular "M 10:NGC 6254:GCl 49:C 1654-040"
{
        RA          	   16.9522  # [hours]
        Dec         	   -4.0994  # [degrees]
        Distance    	 1.435e+04  # [ly]
        Radius      	     41.75  # [ly], mu25 Isophote
        CoreRadius  	      0.86  # [arcmin]
        KingConcentration     1.40  # c = log10(r_t/r_c)
        AbsMag      	     -7.48  # [V mags]
        Axis       	[  0.1172  -0.8102  -0.5743]
        Angle       	     171.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6254"
}

Globular "NGC 6256:VDBH 208:GCl 49.1:ESO 391-6:C 1656-370"
{
        RA          	   16.9922  # [hours]
        Dec         	  -37.1214  # [degrees]
        Distance    	  2.74e+04  # [ly]
        Radius      	     16.34  # [ly], mu25 Isophote
        CoreRadius  	      0.02  # [arcmin]
        KingConcentration     2.58  # c = log10(r_t/r_c)
        AbsMag      	     -6.52  # [V mags]
        Axis       	[  0.1273  -0.6128  -0.7799]
        Angle       	     176.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6256"
}

Globular "Pal 15:Zwicky 1:UGC 10642:LEDA 59400:K73 781:GCl 50:C 1657-004"
{
        RA          	   17.0006  # [hours]
        Dec         	   -0.5419  # [degrees]
        Distance    	 1.455e+05  # [ly]
        Radius      	     63.47  # [ly], mu25 Isophote
        CoreRadius  	      1.25  # [arcmin]
        KingConcentration     0.60  # c = log10(r_t/r_c)
        AbsMag      	     -5.49  # [V mags]
        Axis       	[  0.1097  -0.8284  -0.5493]
        Angle       	     171.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 15"
}

Globular "M 62:NGC 6266:VDBH 210:GCl 51:C 1658-300"
{
        RA          	   17.0200  # [hours]
        Dec         	  -30.1136  # [degrees]
        Distance    	 2.251e+04  # [ly]
        Radius      	      49.1  # [ly], mu25 Isophote
        CoreRadius  	      0.18  # [arcmin]
        KingConcentration     1.70  # c = log10(r_t/r_c)
        AbsMag      	     -9.19  # [V mags]
        Axis       	[  0.1216  -0.6598  -0.7415]
        Angle       	     175.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6266"
}

Globular "M 19:NGC 6273:HD 153799:GCl 52:C 1659-262"
{
        RA          	   17.0436  # [hours]
        Dec         	  -26.2681  # [degrees]
        Distance    	 2.805e+04  # [ly]
        Radius      	     69.36  # [ly], mu25 Isophote
        CoreRadius  	      0.43  # [arcmin]
        KingConcentration     1.53  # c = log10(r_t/r_c)
        AbsMag      	     -9.18  # [V mags]
        Axis       	[  0.1173  -0.6847  -0.7193]
        Angle       	     175.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6273"
}

Globular "NGC 6284:GCl 53:C 1701-246"
{
        RA          	   17.0744  # [hours]
        Dec         	  -24.7647  # [degrees]
        Distance    	  4.99e+04  # [ly]
        Radius      	        45  # [ly], mu25 Isophote
        CoreRadius  	      0.07  # [arcmin]
        KingConcentration     2.52  # c = log10(r_t/r_c)
        AbsMag      	     -7.97  # [V mags]
        Axis       	[   0.113  -0.6944  -0.7107]
        Angle       	     175.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6284"
}

Globular "NGC 6287:GCl 54:C 1702-226"
{
        RA          	   17.0858  # [hours]
        Dec         	  -22.7081  # [degrees]
        Distance    	 3.033e+04  # [ly]
        Radius      	     21.18  # [ly], mu25 Isophote
        CoreRadius  	      0.26  # [arcmin]
        KingConcentration     1.61  # c = log10(r_t/r_c)
        AbsMag      	     -7.36  # [V mags]
        Axis       	[  0.1109  -0.7072  -0.6983]
        Angle       	     174.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6287"
}

Globular "NGC 6293:VDBH 215:GCl 55:C 1707-265"
{
        RA          	   17.1694  # [hours]
        Dec         	  -26.5819  # [degrees]
        Distance    	  2.87e+04  # [ly]
        Radius      	     34.23  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     2.45  # c = log10(r_t/r_c)
        AbsMag      	     -7.77  # [V mags]
        Axis       	[   0.102  -0.6839  -0.7224]
        Angle       	     175.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6293"
}

Globular "NGC 6304:VDBH 216:GCl 56:ESO 454-2:C 1711-294"
{
        RA          	   17.2422  # [hours]
        Dec         	  -29.4622  # [degrees]
        Distance    	 1.957e+04  # [ly]
        Radius      	     22.77  # [ly], mu25 Isophote
        CoreRadius  	      0.21  # [arcmin]
        KingConcentration     1.80  # c = log10(r_t/r_c)
        AbsMag      	     -7.32  # [V mags]
        Axis       	[ 0.09393   -0.666    -0.74]
        Angle       	     176.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6304"
}

Globular "NGC 6316:VDBH 219:GCl 57:C 1713-280"
{
        RA          	   17.2769  # [hours]
        Dec         	  -28.1400  # [degrees]
        Distance    	 3.588e+04  # [ly]
        Radius      	     28.18  # [ly], mu25 Isophote
        CoreRadius  	      0.17  # [arcmin]
        KingConcentration     1.54  # c = log10(r_t/r_c)
        AbsMag      	     -8.35  # [V mags]
        Axis       	[ 0.08929  -0.6748  -0.7326]
        Angle       	     176.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6316"
}

Globular "M 92:NGC 6341:GCl 59:C 1715+432"
{
        RA          	   17.2853  # [hours]
        Dec         	   43.1364  # [degrees]
        Distance    	 2.675e+04  # [ly]
        Radius      	     54.46  # [ly], mu25 Isophote
        CoreRadius  	      0.23  # [arcmin]
        KingConcentration     1.82  # c = log10(r_t/r_c)
        AbsMag      	      -8.2  # [V mags]
        Axis       	[ 0.05394  -0.9778  -0.2027]
        Angle       	     171.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6341"
}

Globular "NGC 6325:GCl 58:ESO 519-11:C 1714-237"
{
        RA          	   17.2997  # [hours]
        Dec         	  -23.7658  # [degrees]
        Distance    	 2.609e+04  # [ly]
        Radius      	     15.56  # [ly], mu25 Isophote
        CoreRadius  	      0.03  # [arcmin]
        KingConcentration     2.50  # c = log10(r_t/r_c)
        AbsMag      	     -6.95  # [V mags]
        Axis       	[ 0.08528  -0.7025  -0.7065]
        Angle       	     176.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6325"
}

Globular "M 9:NGC 6333:HD 156587:GCl 60:C 1716-184"
{
        RA          	   17.3197  # [hours]
        Dec         	  -18.5164  # [degrees]
        Distance    	 2.577e+04  # [ly]
        Radius      	     44.97  # [ly], mu25 Isophote
        CoreRadius  	      0.58  # [arcmin]
        KingConcentration     1.15  # c = log10(r_t/r_c)
        AbsMag      	     -7.94  # [V mags]
        Axis       	[ 0.08128  -0.7344  -0.6738]
        Angle       	     175.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6333"
}

Globular "NGC 6342:GCl 61:C 1718-195"
{
        RA          	   17.3528  # [hours]
        Dec         	  -19.5872  # [degrees]
        Distance    	 2.805e+04  # [ly]
        Radius      	     17.95  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     2.47  # c = log10(r_t/r_c)
        AbsMag      	     -6.44  # [V mags]
        Axis       	[ 0.07765  -0.7283  -0.6809]
        Angle       	     176.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6342"
}

Globular "NGC 6356:HD 157361:GCl 62:C 1720-177"
{
        RA          	   17.3931  # [hours]
        Dec         	  -17.8131  # [degrees]
        Distance    	 4.958e+04  # [ly]
        Radius      	     72.11  # [ly], mu25 Isophote
        CoreRadius  	      0.23  # [arcmin]
        KingConcentration     1.54  # c = log10(r_t/r_c)
        AbsMag      	     -8.52  # [V mags]
        Axis       	[ 0.07233   -0.739  -0.6698]
        Angle       	     176.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6356"
}

Globular "NGC 6355:GCl 63:ESO 519-15:C 1720-263"
{
        RA          	   17.3994  # [hours]
        Dec         	  -26.3536  # [degrees]
        Distance    	 3.099e+04  # [ly]
        Radius      	     18.93  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     2.48  # c = log10(r_t/r_c)
        AbsMag      	     -8.08  # [V mags]
        Axis       	[ 0.07377   -0.687  -0.7229]
        Angle       	     176.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6355"
}

Globular "NGC 6352:VDBH 226:GCl 64:C 1721-484"
{
        RA          	   17.4247  # [hours]
        Dec         	  -48.4228  # [degrees]
        Distance    	 1.859e+04  # [ly]
        Radius      	     24.34  # [ly], mu25 Isophote
        CoreRadius  	      0.83  # [arcmin]
        KingConcentration     1.10  # c = log10(r_t/r_c)
        AbsMag      	     -6.48  # [V mags]
        Axis       	[  0.0743  -0.5359   -0.841]
        Angle       	     178.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6352"
}

Globular "IC 1257:C 1724-070"
{
        RA          	   17.4522  # [hours]
        Dec         	   -7.0931  # [degrees]
        Distance    	 8.154e+04  # [ly]
        Radius      	      59.3  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -6.15  # [V mags]
        Axis       	[ 0.06225  -0.7989  -0.5982]
        Angle       	     175.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=IC 1257"
}

Globular "Haute-Provence 3:Terzan 2:VDBH 228:GCl 64.1:ESO 454-29:C 1724-307"
{
        RA          	   17.4592  # [hours]
        Dec         	  -30.8022  # [degrees]
        Distance    	 2.838e+04  # [ly]
        Radius      	     2.476  # [ly], mu25 Isophote
        CoreRadius  	      0.03  # [arcmin]
        KingConcentration     2.53  # c = log10(r_t/r_c)
        AbsMag      	     -5.27  # [V mags]
        Axis       	[ 0.06734  -0.6587  -0.7493]
        Angle       	     177.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 2"
}

Globular "NGC 6366:GCl 65:C 1725-050"
{
        RA          	   17.4622  # [hours]
        Dec         	   -5.0767  # [degrees]
        Distance    	 1.174e+04  # [ly]
        Radius      	      22.2  # [ly], mu25 Isophote
        CoreRadius  	      1.83  # [arcmin]
        KingConcentration     0.92  # c = log10(r_t/r_c)
        AbsMag      	     -5.77  # [V mags]
        Axis       	[ 0.06049  -0.8094  -0.5842]
        Angle       	     175.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6366"
}

Globular "Haute-Provence 4:Terzan 4:GCl 66.1:C 1727-315"
{
        RA          	   17.5108  # [hours]
        Dec         	  -31.5956  # [degrees]
        Distance    	 2.968e+04  # [ly]
        Radius      	     9.066  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -6.09  # [V mags]
        Axis       	[ 0.06104  -0.6538  -0.7542]
        Angle       	     177.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 4"
}

Globular "VDBH 229:Haute-Provence 1:Dufay 1:GCl 67:ESO 455-11:C 1727-299"
{
        RA          	   17.5181  # [hours]
        Dec         	  -29.9817  # [degrees]
        Distance    	 4.599e+04  # [ly]
        Radius      	     8.027  # [ly], mu25 Isophote
        CoreRadius  	      0.03  # [arcmin]
        KingConcentration     2.44  # c = log10(r_t/r_c)
        AbsMag      	     -6.44  # [V mags]
        Axis       	[ 0.05987  -0.6644   -0.745]
        Angle       	     177.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Haute-Provence 1"
}

Globular "NGC 6362:GCl 66:C 1726-670"
{
        RA          	   17.5317  # [hours]
        Dec         	  -67.0481  # [degrees]
        Distance    	 2.479e+04  # [ly]
        Radius      	     54.08  # [ly], mu25 Isophote
        CoreRadius  	      1.32  # [arcmin]
        KingConcentration     1.10  # c = log10(r_t/r_c)
        AbsMag      	     -6.94  # [V mags]
        Axis       	[-0.06127   0.3931   0.9174]
        Angle       	       180  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6362"
}

Globular "Liller 1:Liller I:C 1730-333"
{
        RA          	   17.5567  # [hours]
        Dec         	  -33.3889  # [degrees]
        Distance    	 3.131e+04  # [ly]
        Radius      	     19.16  # [ly], mu25 Isophote
        CoreRadius  	      0.06  # [arcmin]
        KingConcentration     2.32  # c = log10(r_t/r_c)
        AbsMag      	     -7.63  # [V mags]
        Axis       	[ 0.05559  -0.6421  -0.7646]
        Angle       	     178.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Liller 1"
}

Globular "Ton 1:NGC 6380:Pismis 25:VDBH 233:Name Tonantzintla 1:GCl 68:ESO 333-14:C 1731-390"
{
        RA          	   17.5744  # [hours]
        Dec         	  -39.0692  # [degrees]
        Distance    	  3.49e+04  # [ly]
        Radius      	     18.27  # [ly], mu25 Isophote
        CoreRadius  	      0.34  # [arcmin]
        KingConcentration     1.55  # c = log10(r_t/r_c)
        AbsMag      	     -7.46  # [V mags]
        Axis       	[ 0.05409  -0.6035  -0.7955]
        Angle       	     178.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6380"
}

Globular "Haute-Provence 2:Terzan 1:VDBH 235:GCl 69:ESO 455-23:C 1732-304"
{
        RA          	   17.5964  # [hours]
        Dec         	  -30.4817  # [degrees]
        Distance    	 1.827e+04  # [ly]
        Radius      	     6.376  # [ly], mu25 Isophote
        CoreRadius  	      0.04  # [arcmin]
        KingConcentration     2.44  # c = log10(r_t/r_c)
        AbsMag      	      -4.9  # [V mags]
        Axis       	[ 0.05022  -0.6615  -0.7483]
        Angle       	     178.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 1"
}

Globular "Ton 2:Pismis 26:VDBH 236:Tonantzintla 2:GCl 71:C 1732-385"
{
        RA          	   17.6028  # [hours]
        Dec         	  -38.5533  # [degrees]
        Distance    	 2.642e+04  # [ly]
        Radius      	     8.454  # [ly], mu25 Isophote
        CoreRadius  	      0.54  # [arcmin]
        KingConcentration     1.30  # c = log10(r_t/r_c)
        AbsMag      	     -6.14  # [V mags]
        Axis       	[ 0.05043  -0.6072  -0.7929]
        Angle       	     178.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pismis 26"
}

Globular "NGC 6388:VDBH 234:C 1732-447:GCl 70"
{
        RA          	   17.6047  # [hours]
        Dec         	  -44.7350  # [degrees]
        Distance    	 3.262e+04  # [ly]
        Radius      	     49.34  # [ly], mu25 Isophote
        CoreRadius  	      0.12  # [arcmin]
        KingConcentration     1.71  # c = log10(r_t/r_c)
        AbsMag      	     -9.42  # [V mags]
        Axis       	[ 0.05079  -0.5635  -0.8245]
        Angle       	     178.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6388"
}

Globular "M 14:NGC 6402:GCl 72:C 1735-032"
{
        RA          	   17.6267  # [hours]
        Dec         	   -3.2458  # [degrees]
        Distance    	 3.033e+04  # [ly]
        Radius      	     48.53  # [ly], mu25 Isophote
        CoreRadius  	      0.83  # [arcmin]
        KingConcentration     1.60  # c = log10(r_t/r_c)
        AbsMag      	     -9.12  # [V mags]
        Axis       	[ 0.04159  -0.8194  -0.5717]
        Angle       	     177.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6402"
}

Globular "NGC 6401:GCl 73:ESO 520-11:C 1735-238"
{
        RA          	   17.6433  # [hours]
        Dec         	  -23.9094  # [degrees]
        Distance    	 3.425e+04  # [ly]
        Radius      	     23.91  # [ly], mu25 Isophote
        CoreRadius  	      0.25  # [arcmin]
        KingConcentration     1.68  # c = log10(r_t/r_c)
        AbsMag      	      -7.9  # [V mags]
        Axis       	[ 0.04348  -0.7035  -0.7093]
        Angle       	     178.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6401"
}

Globular "NGC 6397:GCl 74:C 1736-536"
{
        RA          	   17.6781  # [hours]
        Dec         	  -53.6736  # [degrees]
        Distance    	      7502  # [ly]
        Radius      	     33.82  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     2.50  # c = log10(r_t/r_c)
        AbsMag      	     -6.63  # [V mags]
        Axis       	[ 0.04186  -0.4978  -0.8663]
        Angle       	     179.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6397"
}

Globular "Pal 6:GCl 75:ESO 520-21:C 1740-262"
{
        RA          	   17.7283  # [hours]
        Dec         	  -26.2225  # [degrees]
        Distance    	 1.924e+04  # [ly]
        Radius      	     3.359  # [ly], mu25 Isophote
        CoreRadius  	      0.66  # [arcmin]
        KingConcentration     1.10  # c = log10(r_t/r_c)
        AbsMag      	     -6.81  # [V mags]
        Axis       	[ 0.03338  -0.6893  -0.7237]
        Angle       	     178.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 6"
}

Globular "NGC 6426:GCl 76:C 1742+031"
{
        RA          	   17.7483  # [hours]
        Dec         	    3.1703  # [degrees]
        Distance    	 6.752e+04  # [ly]
        Radius      	     41.24  # [ly], mu25 Isophote
        CoreRadius  	      0.26  # [arcmin]
        KingConcentration     1.71  # c = log10(r_t/r_c)
        AbsMag      	     -6.69  # [V mags]
        Axis       	[ 0.02703  -0.8505  -0.5252]
        Angle       	     177.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6426"
}

Globular "Djorg 1"
{
        RA          	   17.7911  # [hours]
        Dec         	  -33.0656  # [degrees]
        Distance    	 3.914e+04  # [ly]
        Radius      	     23.53  # [ly], mu25 Isophote
        CoreRadius  	      0.32  # [arcmin]
        KingConcentration     1.50  # c = log10(r_t/r_c)
        AbsMag      	     -6.26  # [V mags]
        Axis       	[ 0.02618  -0.6451  -0.7637]
        Angle       	     179.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Djorg 1"
}

Globular "Terzan 5:GCl 76.1:ESO 520-27:C 1745-247"
{
        RA          	   17.8011  # [hours]
        Dec         	  -24.7792  # [degrees]
        Distance    	  3.36e+04  # [ly]
        Radius      	     23.45  # [ly], mu25 Isophote
        CoreRadius  	      0.18  # [arcmin]
        KingConcentration     1.87  # c = log10(r_t/r_c)
        AbsMag      	     -7.87  # [V mags]
        Axis       	[ 0.02432  -0.6986  -0.7151]
        Angle       	     178.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 5"
}

Globular "NGC 6440:MXB 1746-20:GCl 77:C 1746-203"
{
        RA          	   17.8144  # [hours]
        Dec         	  -20.3603  # [degrees]
        Distance    	  2.74e+04  # [ly]
        Radius      	     17.53  # [ly], mu25 Isophote
        CoreRadius  	      0.13  # [arcmin]
        KingConcentration     1.69  # c = log10(r_t/r_c)
        AbsMag      	     -8.75  # [V mags]
        Axis       	[ 0.02234  -0.7257  -0.6877]
        Angle       	     178.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6440"
}

Globular "NGC 6441:VDBH 248:GCl 78:C 1746-370"
{
        RA          	   17.8367  # [hours]
        Dec         	  -37.0514  # [degrees]
        Distance    	 3.816e+04  # [ly]
        Radius      	     53.28  # [ly], mu25 Isophote
        CoreRadius  	      0.11  # [arcmin]
        KingConcentration     1.86  # c = log10(r_t/r_c)
        AbsMag      	     -9.64  # [V mags]
        Axis       	[ 0.02067  -0.6182  -0.7858]
        Angle       	     179.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6441"
}

Globular "Haute-Provence 5:Terzan 6:VDBH 249:GCl 78.1:ESO 455-49:C 1747-313:C 1747-312"
{
        RA          	   17.8461  # [hours]
        Dec         	  -31.2753  # [degrees]
        Distance    	 3.099e+04  # [ly]
        Radius      	     6.309  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     2.54  # c = log10(r_t/r_c)
        AbsMag      	     -7.67  # [V mags]
        Axis       	[  0.0192   -0.657  -0.7536]
        Angle       	     179.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 6"
}

Globular "NGC 6453:VDBH 251:GCl 79:C 1748-346"
{
        RA          	   17.8475  # [hours]
        Dec         	  -34.5992  # [degrees]
        Distance    	 3.131e+04  # [ly]
        Radius      	     34.61  # [ly], mu25 Isophote
        CoreRadius  	      0.07  # [arcmin]
        KingConcentration     2.49  # c = log10(r_t/r_c)
        AbsMag      	     -6.88  # [V mags]
        Axis       	[ 0.01919  -0.6349  -0.7724]
        Angle       	     179.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6453"
}

Globular "Name UKS 1:UKS 1751-24.1:C 1751-241"
{
        RA          	   17.9075  # [hours]
        Dec         	  -24.1453  # [degrees]
        Distance    	 2.707e+04  # [ly]
        Radius      	     7.875  # [ly], mu25 Isophote
        CoreRadius  	      0.15  # [arcmin]
        KingConcentration     2.10  # c = log10(r_t/r_c)
        AbsMag      	     -6.88  # [V mags]
        Axis       	[ 0.01129  -0.7027  -0.7114]
        Angle       	     179.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Name UKS 1"
}

Globular "NGC 6496:GCl 80:C 1755-442"
{
        RA          	   17.9839  # [hours]
        Dec         	  -44.2650  # [degrees]
        Distance    	 3.751e+04  # [ly]
        Radius      	     30.55  # [ly], mu25 Isophote
        CoreRadius  	      1.05  # [arcmin]
        KingConcentration     0.70  # c = log10(r_t/r_c)
        AbsMag      	     -7.23  # [V mags]
        Axis       	[0.002069  -0.5677  -0.8233]
        Angle       	       180  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6496"
}

Globular "Terzan 9:GCl 80.1:C 1758-268"
{
        RA          	   18.0272  # [hours]
        Dec         	  -26.8397  # [degrees]
        Distance    	  2.12e+04  # [ly]
        Radius      	      1.85  # [ly], mu25 Isophote
        CoreRadius  	      0.03  # [arcmin]
        KingConcentration     2.44  # c = log10(r_t/r_c)
        AbsMag      	     -3.85  # [V mags]
        Axis       	[0.003351   0.6858   0.7278]
        Angle       	     179.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 9"
}

Globular "ESO456-SC38:Djorg 2:ESO 456-38:C 1758-278"
{
        RA          	   18.0303  # [hours]
        Dec         	  -27.8258  # [degrees]
        Distance    	 2.185e+04  # [ly]
        Radius      	     31.47  # [ly], mu25 Isophote
        CoreRadius  	      0.33  # [arcmin]
        KingConcentration     1.50  # c = log10(r_t/r_c)
        AbsMag      	     -6.98  # [V mags]
        Axis       	[0.003739   0.6795   0.7336]
        Angle       	     179.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Djorg 2"
}

Globular "NGC 6517:GCl 81:C 1759-089"
{
        RA          	   18.0306  # [hours]
        Dec         	   -8.9589  # [degrees]
        Distance    	 3.523e+04  # [ly]
        Radius      	     20.49  # [ly], mu25 Isophote
        CoreRadius  	      0.06  # [arcmin]
        KingConcentration     1.83  # c = log10(r_t/r_c)
        AbsMag      	     -8.28  # [V mags]
        Axis       	[0.003505   0.7906   0.6123]
        Angle       	     179.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6517"
}

Globular "Terzan 10:GCl 82.1:ESO 521-16:C 1800-260"
{
        RA          	   18.0492  # [hours]
        Dec         	  -26.0667  # [degrees]
        Distance    	 1.859e+04  # [ly]
        Radius      	     12.17  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -6.31  # [V mags]
        Axis       	[0.006038   0.6907   0.7231]
        Angle       	     179.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 10"
}

Globular "NGC 6522:VDBH 256:GCl 82:C 1800-300"
{
        RA          	   18.0594  # [hours]
        Dec         	  -30.0339  # [degrees]
        Distance    	 2.544e+04  # [ly]
        Radius      	     34.78  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     2.52  # c = log10(r_t/r_c)
        AbsMag      	     -7.67  # [V mags]
        Axis       	[0.007389   0.6652   0.7466]
        Angle       	     179.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6522"
}

Globular "NGC 6535:GCl 83:C 1801-003"
{
        RA          	   18.0639  # [hours]
        Dec         	   -0.2969  # [degrees]
        Distance    	 2.218e+04  # [ly]
        Radius      	     10.97  # [ly], mu25 Isophote
        CoreRadius  	      0.42  # [arcmin]
        KingConcentration     1.30  # c = log10(r_t/r_c)
        AbsMag      	     -4.75  # [V mags]
        Axis       	[0.007003   0.8346   0.5509]
        Angle       	     179.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6535"
}

Globular "NGC 6528:VDBH 257:GCl 84:ESO 456-48:C 1801-300"
{
        RA          	   18.0803  # [hours]
        Dec         	  -30.0558  # [degrees]
        Distance    	 2.577e+04  # [ly]
        Radius      	     18.74  # [ly], mu25 Isophote
        CoreRadius  	      0.09  # [arcmin]
        KingConcentration     2.27  # c = log10(r_t/r_c)
        AbsMag      	     -6.56  # [V mags]
        Axis       	[0.009979   0.6651   0.7467]
        Angle       	     179.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6528"
}

Globular "NGC 6539:GCl 85:C 1802-075"
{
        RA          	   18.0803  # [hours]
        Dec         	   -7.5858  # [degrees]
        Distance    	  2.74e+04  # [ly]
        Radius      	     31.48  # [ly], mu25 Isophote
        CoreRadius  	      0.54  # [arcmin]
        KingConcentration     1.60  # c = log10(r_t/r_c)
        AbsMag      	      -8.3  # [V mags]
        Axis       	[0.009147   0.7978   0.6028]
        Angle       	     179.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6539"
}

Globular "Djorg 3:NGC 6540:VDBH 258:C 1803-278"
{
        RA          	   18.1022  # [hours]
        Dec         	  -27.7653  # [degrees]
        Distance    	 1.207e+04  # [ly]
        Radius      	     2.633  # [ly], mu25 Isophote
        CoreRadius  	      0.03  # [arcmin]
        KingConcentration     2.50  # c = log10(r_t/r_c)
        AbsMag      	     -5.38  # [V mags]
        Axis       	[ 0.01262   0.6799   0.7332]
        Angle       	     179.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6540"
}

Globular "NGC 6544:GCl 87:C 1804-250"
{
        RA          	   18.1222  # [hours]
        Dec         	  -24.9975  # [degrees]
        Distance    	      8807  # [ly]
        Radius      	     11.78  # [ly], mu25 Isophote
        CoreRadius  	      0.05  # [arcmin]
        KingConcentration     1.61  # c = log10(r_t/r_c)
        AbsMag      	     -6.66  # [V mags]
        Axis       	[ 0.01496   0.6973   0.7166]
        Angle       	     179.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6544"
}

Globular "NGC 6541:GCl 86:C 1804-437"
{
        RA          	   18.1339  # [hours]
        Dec         	  -43.5000  # [degrees]
        Distance    	 2.283e+04  # [ly]
        Radius      	     49.81  # [ly], mu25 Isophote
        CoreRadius  	       0.3  # [arcmin]
        KingConcentration     1.99  # c = log10(r_t/r_c)
        AbsMag      	     -8.37  # [V mags]
        Axis       	[ 0.01717   0.5731   0.8193]
        Angle       	     179.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6541"
}

Globular "2MASS-GC01:[HJK2000] GC01"
{
        RA          	   18.1392  # [hours]
        Dec         	  -19.8297  # [degrees]
        Distance    	 1.174e+04  # [ly]
        Radius      	     5.636  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -6.86  # unknown!! Data base average used
        Axis       	[ 0.01672   0.7289   0.6844]
        Angle       	     179.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=2MASS-GC01"
}

Globular "ESO 280-SC06:ESO 280-6"
{
        RA          	   18.1517  # [hours]
        Dec         	  -46.4231  # [degrees]
        Distance    	 7.078e+04  # [ly]
        Radius      	     15.44  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -6.86  # unknown!! Data base average used
        Axis       	[ 0.01955   0.5519   0.8336]
        Angle       	     179.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=ESO 280-SC06"
}

Globular "NGC 6553:GCl 88:C 1806-259"
{
        RA          	   18.1547  # [hours]
        Dec         	  -25.9086  # [degrees]
        Distance    	 1.957e+04  # [ly]
        Radius      	     26.19  # [ly], mu25 Isophote
        CoreRadius  	      0.55  # [arcmin]
        KingConcentration     1.17  # c = log10(r_t/r_c)
        AbsMag      	     -7.77  # [V mags]
        Axis       	[ 0.01899   0.6916    0.722]
        Angle       	     179.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6553"
}

Globular "2MASS-GC02:[HJK2000] GC02"
{
        RA          	   18.1600  # [hours]
        Dec         	  -20.7789  # [degrees]
        Distance    	 1.305e+04  # [ly]
        Radius      	     3.605  # [ly], mu25 Isophote
        CoreRadius            0.83  # unknown!! Data base average used
        KingConcentration     1.47  # unknown!! Data base average used
        AbsMag      	     -6.86  # unknown!! Data base average used
        Axis       	[ 0.01929   0.7232   0.6904]
        Angle       	     179.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=2MASS-GC02"
}

Globular "NGC 6558:VDBH 259:GCl 89:ESO 456-62:C 1807-317"
{
        RA          	   18.1714  # [hours]
        Dec         	  -31.7639  # [degrees]
        Distance    	 2.414e+04  # [ly]
        Radius      	     14.74  # [ly], mu25 Isophote
        CoreRadius  	      0.03  # [arcmin]
        KingConcentration     2.54  # c = log10(r_t/r_c)
        AbsMag      	     -6.46  # [V mags]
        Axis       	[ 0.02141   0.6538   0.7564]
        Angle       	     179.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6558"
}

Globular "Pal 7:IC 1276:GCl 90:C 1808-072"
{
        RA          	   18.1789  # [hours]
        Dec         	   -7.2075  # [degrees]
        Distance    	 1.761e+04  # [ly]
        Radius      	     20.49  # [ly], mu25 Isophote
        CoreRadius  	      1.08  # [arcmin]
        KingConcentration     1.29  # c = log10(r_t/r_c)
        AbsMag      	     -6.67  # [V mags]
        Axis       	[ 0.02034   0.7997   0.6001]
        Angle       	     178.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=IC 1276"
}

Globular "Terzan 11:Terzan 12:GCl 90.1:ESO 522-1:C 1809-227"
{
        RA          	   18.2042  # [hours]
        Dec         	  -22.7419  # [degrees]
        Distance    	 1.566e+04  # [ly]
        Radius      	     5.465  # [ly], mu25 Isophote
        CoreRadius  	      0.83  # [arcmin]
        KingConcentration     0.57  # c = log10(r_t/r_c)
        AbsMag      	     -4.14  # [V mags]
        Axis       	[ 0.02479   0.7112   0.7026]
        Angle       	     178.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 11"
}

Globular "NGC 6569:VDBH 260:GCl 91:ESO 456-77:C 1810-318"
{
        RA          	   18.2272  # [hours]
        Dec         	  -31.8269  # [degrees]
        Distance    	  3.49e+04  # [ly]
        Radius      	     32.49  # [ly], mu25 Isophote
        CoreRadius  	      0.37  # [arcmin]
        KingConcentration     1.27  # c = log10(r_t/r_c)
        AbsMag      	      -8.3  # [V mags]
        Axis       	[ 0.02838   0.6532   0.7566]
        Angle       	       179  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6569"
}

Globular "NGC 6584:GCl 92:C 1814-522"
{
        RA          	   18.3103  # [hours]
        Dec         	  -52.2150  # [degrees]
        Distance    	 4.371e+04  # [ly]
        Radius      	     41.96  # [ly], mu25 Isophote
        CoreRadius  	      0.59  # [arcmin]
        KingConcentration     1.20  # c = log10(r_t/r_c)
        AbsMag      	     -7.68  # [V mags]
        Axis       	[ 0.04029   0.5088   0.8599]
        Angle       	     179.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6584"
}

Globular "NGC 6624:VDBH 262:KOHX 13:GCl 93:ESO 457-11:C 1820-303"
{
        RA          	   18.3944  # [hours]
        Dec         	  -30.3611  # [degrees]
        Distance    	 2.577e+04  # [ly]
        Radius      	     32.98  # [ly], mu25 Isophote
        CoreRadius  	      0.06  # [arcmin]
        KingConcentration     2.53  # c = log10(r_t/r_c)
        AbsMag      	     -7.49  # [V mags]
        Axis       	[ 0.04906   0.6623   0.7476]
        Angle       	     178.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6624"
}

Globular "M 28:NGC 6626:GCl 94:C 1821-249"
{
        RA          	   18.4089  # [hours]
        Dec         	  -24.8700  # [degrees]
        Distance    	 1.827e+04  # [ly]
        Radius      	     29.75  # [ly], mu25 Isophote
        CoreRadius  	      0.24  # [arcmin]
        KingConcentration     1.67  # c = log10(r_t/r_c)
        AbsMag      	     -8.18  # [V mags]
        Axis       	[ 0.05001   0.6973    0.715]
        Angle       	     177.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6626"
}

Globular "NGC 6638:GCl 95:C 1827-255"
{
        RA          	   18.5156  # [hours]
        Dec         	  -25.4975  # [degrees]
        Distance    	 3.131e+04  # [ly]
        Radius      	     33.25  # [ly], mu25 Isophote
        CoreRadius  	      0.26  # [arcmin]
        KingConcentration     1.41  # c = log10(r_t/r_c)
        AbsMag      	     -7.13  # [V mags]
        Axis       	[ 0.06317   0.6929   0.7183]
        Angle       	     177.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6638"
}

Globular "M 69:NGC 6637:HD 170534:GCl 96:C 1828-323"
{
        RA          	   18.5231  # [hours]
        Dec         	  -32.3481  # [degrees]
        Distance    	 2.968e+04  # [ly]
        Radius      	     42.31  # [ly], mu25 Isophote
        CoreRadius  	      0.34  # [arcmin]
        KingConcentration     1.39  # c = log10(r_t/r_c)
        AbsMag      	     -7.64  # [V mags]
        Axis       	[  0.0654   0.6487   0.7583]
        Angle       	     177.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6637"
}

Globular "NGC 6642:GCl 97:ESO 522-32:C 1828-235"
{
        RA          	   18.5317  # [hours]
        Dec         	  -23.4753  # [degrees]
        Distance    	  2.74e+04  # [ly]
        Radius      	     23.11  # [ly], mu25 Isophote
        CoreRadius  	       0.1  # [arcmin]
        KingConcentration     2.00  # c = log10(r_t/r_c)
        AbsMag      	     -6.77  # [V mags]
        Axis       	[  0.0647   0.7054   0.7058]
        Angle       	     177.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6642"
}

Globular "NGC 6652:GCl 98:C 1832-330"
{
        RA          	   18.5958  # [hours]
        Dec         	  -32.9903  # [degrees]
        Distance    	 3.294e+04  # [ly]
        Radius      	     28.75  # [ly], mu25 Isophote
        CoreRadius  	      0.07  # [arcmin]
        KingConcentration     1.81  # c = log10(r_t/r_c)
        AbsMag      	     -6.68  # [V mags]
        Axis       	[ 0.07461    0.644   0.7614]
        Angle       	     177.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6652"
}

Globular "M 22:NGC 6656:HD 171560:GCl 99:C 1833-239"
{
        RA          	   18.6067  # [hours]
        Dec         	  -23.9033  # [degrees]
        Distance    	 1.044e+04  # [ly]
        Radius      	     48.58  # [ly], mu25 Isophote
        CoreRadius  	      1.42  # [arcmin]
        KingConcentration     1.31  # c = log10(r_t/r_c)
        AbsMag      	      -8.5  # [V mags]
        Axis       	[ 0.07393   0.7023    0.708]
        Angle       	     176.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6656"
}

Globular "Pal 8:GCl 100:ESO 591-12:C 1838-198"
{
        RA          	   18.6914  # [hours]
        Dec         	  -19.8258  # [degrees]
        Distance    	 4.208e+04  # [ly]
        Radius      	     31.82  # [ly], mu25 Isophote
        CoreRadius  	       0.4  # [arcmin]
        KingConcentration     1.53  # c = log10(r_t/r_c)
        AbsMag      	     -5.52  # [V mags]
        Axis       	[ 0.08302   0.7265   0.6821]
        Angle       	     175.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 8"
}

Globular "M 70:NGC 6681:GCl 101:C 1840-323"
{
        RA          	   18.7200  # [hours]
        Dec         	  -32.2919  # [degrees]
        Distance    	 2.936e+04  # [ly]
        Radius      	     34.16  # [ly], mu25 Isophote
        CoreRadius  	      0.03  # [arcmin]
        KingConcentration     2.42  # c = log10(r_t/r_c)
        AbsMag      	     -7.11  # [V mags]
        Axis       	[ 0.08997   0.6478   0.7565]
        Angle       	     176.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6681"
}

Globular "NGC 6712:OCl 72.0:GCl 103:C 1850-087:AO 1850-08"
{
        RA          	   18.8844  # [hours]
        Dec         	   -8.7061  # [degrees]
        Distance    	 2.251e+04  # [ly]
        Radius      	     32.08  # [ly], mu25 Isophote
        CoreRadius  	      0.94  # [arcmin]
        KingConcentration     0.90  # c = log10(r_t/r_c)
        AbsMag      	      -7.5  # [V mags]
        Axis       	[  0.1013   0.7879   0.6075]
        Angle       	     173.6  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6712"
}

Globular "M 54:NGC 6715:GCl 104:C 1851-305"
{
        RA          	   18.9175  # [hours]
        Dec         	  -30.4783  # [degrees]
        Distance    	 8.741e+04  # [ly]
        Radius      	     152.6  # [ly], mu25 Isophote
        CoreRadius  	      0.11  # [arcmin]
        KingConcentration     1.83  # c = log10(r_t/r_c)
        AbsMag      	    -10.01  # [V mags]
        Axis       	[   0.114    0.658   0.7443]
        Angle       	     175.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6715"
}

Globular "Pal 9:NGC 6717:GCl 105:ESO 523-14:C 1852-227"
{
        RA          	   18.9183  # [hours]
        Dec         	  -22.7008  # [degrees]
        Distance    	 2.316e+04  # [ly]
        Radius      	     18.19  # [ly], mu25 Isophote
        CoreRadius  	      0.08  # [arcmin]
        KingConcentration     2.09  # c = log10(r_t/r_c)
        AbsMag      	     -5.66  # [V mags]
        Axis       	[  0.1114   0.7072   0.6982]
        Angle       	     174.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6717"
}

Globular "NGC 6723:GCl 106:C 1856-367"
{
        RA          	   18.9925  # [hours]
        Dec         	  -36.6317  # [degrees]
        Distance    	 2.838e+04  # [ly]
        Radius      	     53.65  # [ly], mu25 Isophote
        CoreRadius  	      0.94  # [arcmin]
        KingConcentration     1.05  # c = log10(r_t/r_c)
        AbsMag      	     -7.84  # [V mags]
        Axis       	[  0.1252   0.6163   0.7775]
        Angle       	     176.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6723"
}

Globular "NGC 6749:Berkeley 42:GCl 107:C 1902+018"
{
        RA          	   19.0875  # [hours]
        Dec         	    1.9008  # [degrees]
        Distance    	 2.577e+04  # [ly]
        Radius      	     14.99  # [ly], mu25 Isophote
        CoreRadius  	      0.77  # [arcmin]
        KingConcentration     0.83  # c = log10(r_t/r_c)
        AbsMag      	      -6.7  # [V mags]
        Axis       	[  0.1177   0.8391   0.5311]
        Angle       	     170.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6749"
}

Globular "NGC 6752:GCl 108:C 1906-600"
{
        RA          	   19.1811  # [hours]
        Dec         	  -59.9847  # [degrees]
        Distance    	 1.305e+04  # [ly]
        Radius      	     55.03  # [ly], mu25 Isophote
        CoreRadius  	      0.17  # [arcmin]
        KingConcentration     2.51  # c = log10(r_t/r_c)
        AbsMag      	     -7.73  # [V mags]
        Axis       	[  0.1537   0.4444   0.8825]
        Angle       	       179  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6752"
}

Globular "NGC 6760:GCl 109:C 1908+009"
{
        RA          	   19.1867  # [hours]
        Dec         	    1.0306  # [degrees]
        Distance    	 2.414e+04  # [ly]
        Radius      	      33.7  # [ly], mu25 Isophote
        CoreRadius  	      0.33  # [arcmin]
        KingConcentration     1.59  # c = log10(r_t/r_c)
        AbsMag      	     -7.86  # [V mags]
        Axis       	[   0.129   0.8339   0.5367]
        Angle       	     170.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6760"
}

Globular "M 56:NGC 6779:GCl 110:C 1914+300"
{
        RA          	   19.2764  # [hours]
        Dec         	   30.1847  # [degrees]
        Distance    	 3.294e+04  # [ly]
        Radius      	     42.16  # [ly], mu25 Isophote
        CoreRadius  	      0.37  # [arcmin]
        KingConcentration     1.36  # c = log10(r_t/r_c)
        AbsMag      	     -7.38  # [V mags]
        Axis       	[  0.1113   0.9441   0.3102]
        Angle       	     165.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6779"
}

Globular "Terzan 7:GCl 109.1:C 1914-347"
{
        RA          	   19.2953  # [hours]
        Dec         	  -34.6575  # [degrees]
        Distance    	 7.567e+04  # [ly]
        Radius      	     13.21  # [ly], mu25 Isophote
        CoreRadius  	      0.61  # [arcmin]
        KingConcentration     1.08  # c = log10(r_t/r_c)
        AbsMag      	     -5.05  # [V mags]
        Axis       	[  0.1624   0.6262   0.7626]
        Angle       	     174.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 7"
}

Globular "Pal 10:GCl 111:C 1916+184"
{
        RA          	   19.3006  # [hours]
        Dec         	   18.5717  # [degrees]
        Distance    	 1.924e+04  # [ly]
        Radius      	      11.2  # [ly], mu25 Isophote
        CoreRadius  	      0.81  # [arcmin]
        KingConcentration     0.58  # c = log10(r_t/r_c)
        AbsMag      	     -5.79  # [V mags]
        Axis       	[  0.1256   0.9063   0.4034]
        Angle       	     166.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 10"
}

Globular "Cl Arp 2:GCl 112:C 1925-304"
{
        RA          	   19.4789  # [hours]
        Dec         	  -30.3539  # [degrees]
        Distance    	 9.328e+04  # [ly]
        Radius      	     31.21  # [ly], mu25 Isophote
        CoreRadius  	      1.59  # [arcmin]
        KingConcentration     0.90  # c = log10(r_t/r_c)
        AbsMag      	     -5.29  # [V mags]
        Axis       	[  0.1832    0.652   0.7358]
        Angle       	     173.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Cl Arp 2"
}

Globular "M 55:NGC 6809:GCl 113:C 1936-310"
{
        RA          	   19.6664  # [hours]
        Dec         	  -30.9622  # [degrees]
        Distance    	 1.729e+04  # [ly]
        Radius      	     47.77  # [ly], mu25 Isophote
        CoreRadius  	      2.83  # [arcmin]
        KingConcentration     0.76  # c = log10(r_t/r_c)
        AbsMag      	     -7.55  # [V mags]
        Axis       	[  0.2065    0.645   0.7358]
        Angle       	     172.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6809"
}

Globular "Terzan 8:GCl 113.1:C 1938-341"
{
        RA          	   19.6958  # [hours]
        Dec         	  -34.0003  # [degrees]
        Distance    	  8.48e+04  # [ly]
        Radius      	     43.17  # [ly], mu25 Isophote
        CoreRadius  	         1  # [arcmin]
        KingConcentration     0.60  # c = log10(r_t/r_c)
        AbsMag      	     -5.05  # [V mags]
        Axis       	[  0.2117   0.6245   0.7517]
        Angle       	     172.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Terzan 8"
}

Globular "Pal 11:GCl 114:C 1942-081"
{
        RA          	   19.7539  # [hours]
        Dec         	   -8.0072  # [degrees]
        Distance    	  4.24e+04  # [ly]
        Radius      	     61.67  # [ly], mu25 Isophote
        CoreRadius  	         2  # [arcmin]
        KingConcentration     0.69  # c = log10(r_t/r_c)
        AbsMag      	     -6.86  # [V mags]
        Axis       	[  0.1997   0.7796   0.5936]
        Angle       	     167.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 11"
}

Globular "M 71:NGC 6838:GCl 115:C 1951+186"
{
        RA          	   19.8961  # [hours]
        Dec         	   18.7783  # [degrees]
        Distance    	 1.305e+04  # [ly]
        Radius      	     13.66  # [ly], mu25 Isophote
        CoreRadius  	      0.63  # [arcmin]
        KingConcentration     1.15  # c = log10(r_t/r_c)
        AbsMag      	      -5.6  # [V mags]
        Axis       	[  0.1832   0.8988   0.3981]
        Angle       	     160.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6838"
}

Globular "M 75:NGC 6864:GCl 116:C 2003-220"
{
        RA          	   20.1011  # [hours]
        Dec         	  -21.9214  # [degrees]
        Distance    	 6.752e+04  # [ly]
        Radius      	     66.78  # [ly], mu25 Isophote
        CoreRadius  	       0.1  # [arcmin]
        KingConcentration     1.86  # c = log10(r_t/r_c)
        AbsMag      	     -8.55  # [V mags]
        Axis       	[  0.2526   0.6932   0.6751]
        Angle       	     168.2  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6864"
}

Globular "NGC 6934:GCl 117:C 2031+072"
{
        RA          	   20.5697  # [hours]
        Dec         	    7.4042  # [degrees]
        Distance    	 5.121e+04  # [ly]
        Radius      	     52.88  # [ly], mu25 Isophote
        CoreRadius  	      0.25  # [arcmin]
        KingConcentration     1.52  # c = log10(r_t/r_c)
        AbsMag      	     -7.46  # [V mags]
        Axis       	[   0.269   0.8376   0.4754]
        Angle       	     157.1  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6934"
}

Globular "M 72:NGC 6981:GCl 118:C 2050-127"
{
        RA          	   20.8908  # [hours]
        Dec         	  -12.5369  # [degrees]
        Distance    	 5.545e+04  # [ly]
        Radius      	     53.23  # [ly], mu25 Isophote
        CoreRadius  	      0.54  # [arcmin]
        KingConcentration     1.23  # c = log10(r_t/r_c)
        AbsMag      	     -7.04  # [V mags]
        Axis       	[  0.3339   0.7268   0.6002]
        Angle       	     160.7  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 6981"
}

Globular "NGC 7006:GCl 119:C 2059+160"
{
        RA          	   21.0247  # [hours]
        Dec         	   16.1875  # [degrees]
        Distance    	 1.354e+05  # [ly]
        Radius      	     70.87  # [ly], mu25 Isophote
        CoreRadius  	      0.24  # [arcmin]
        KingConcentration     1.42  # c = log10(r_t/r_c)
        AbsMag      	     -7.68  # [V mags]
        Axis       	[  0.2993   0.8634   0.4061]
        Angle       	     150.5  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7006"
}

Globular "M 15:NGC 7078:GCl 120:C 2127+119"
{
        RA          	   21.4994  # [hours]
        Dec         	   12.1669  # [degrees]
        Distance    	  3.36e+04  # [ly]
        Radius      	     87.95  # [ly], mu25 Isophote
        CoreRadius  	      0.07  # [arcmin]
        KingConcentration     2.49  # c = log10(r_t/r_c)
        AbsMag      	     -9.17  # [V mags]
        Axis       	[  0.3562   0.8311   0.4271]
        Angle       	     147.4  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7078"
}

Globular "M 2:NGC 7089:HD 205146:GCl 121:C 2130-010"
{
        RA          	   21.5581  # [hours]
        Dec         	   -0.8231  # [degrees]
        Distance    	 3.751e+04  # [ly]
        Radius      	     87.29  # [ly], mu25 Isophote
        CoreRadius  	      0.34  # [arcmin]
        KingConcentration     1.80  # c = log10(r_t/r_c)
        AbsMag      	     -9.02  # [V mags]
        Axis       	[  0.3889   0.7665   0.5111]
        Angle       	     151.8  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7089"
}

Globular "M 30:NGC 7099:GCl 122:C 2137-234"
{
        RA          	   21.6728  # [hours]
        Dec         	  -23.1792  # [degrees]
        Distance    	 2.609e+04  # [ly]
        Radius      	     45.54  # [ly], mu25 Isophote
        CoreRadius  	      0.06  # [arcmin]
        KingConcentration     2.49  # c = log10(r_t/r_c)
        AbsMag      	     -7.43  # [V mags]
        Axis       	[  0.4361   0.6378   0.6349]
        Angle       	     160.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7099"
}

Globular "Pal 12:GCl 123:C 2143-214"
{
        RA          	   21.7772  # [hours]
        Dec         	  -21.2508  # [degrees]
        Distance    	  6.23e+04  # [ly]
        Radius      	     26.28  # [ly], mu25 Isophote
        CoreRadius  	       0.2  # [arcmin]
        KingConcentration     1.94  # c = log10(r_t/r_c)
        AbsMag      	     -4.48  # [V mags]
        Axis       	[  0.4454   0.6451   0.6209]
        Angle       	     158.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 12"
}

Globular "Pal 13:UGCA 435:TC 408:GCl 124:C 2304+124"
{
        RA          	   23.1122  # [hours]
        Dec         	   12.7719  # [degrees]
        Distance    	 8.415e+04  # [ly]
        Radius      	     8.567  # [ly], mu25 Isophote
        CoreRadius  	      0.65  # [arcmin]
        KingConcentration     0.68  # c = log10(r_t/r_c)
        AbsMag      	     -3.74  # [V mags]
        Axis       	[    0.52   0.7618   0.3864]
        Angle       	     133.3  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=Pal 13"
}

Globular "NGC 7492:GCl 125:C 2305-159"
{
        RA          	   23.1406  # [hours]
        Dec         	  -15.6114  # [degrees]
        Distance    	 8.415e+04  # [ly]
        Radius      	      51.4  # [ly], mu25 Isophote
        CoreRadius  	      0.83  # [arcmin]
        KingConcentration     1.00  # c = log10(r_t/r_c)
        AbsMag      	     -5.77  # [V mags]
        Axis       	[   0.584   0.6118   0.5335]
        Angle       	     148.9  # [degrees]
        InfoURL  "http://simbad.u-strasbg.fr/sim-id.pl?Ident=NGC 7492"
}

