(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/request#request::t
    (make-struct-type
     'std/net#request::t
     '#f
     '8
     'request
     '()
     ':init!
     '(port url history status status-text headers body encoding)))
  (define std/net/request#request?
    (make-struct-predicate std/net/request#request::t))
  (define std/net/request#make-request
    (lambda _$args116357_
      (apply make-struct-instance std/net/request#request::t _$args116357_)))
  (define std/net/request#request-port
    (make-struct-field-accessor std/net/request#request::t '0))
  (define std/net/request#request-url
    (make-struct-field-accessor std/net/request#request::t '1))
  (define std/net/request#request-history
    (make-struct-field-accessor std/net/request#request::t '2))
  (define std/net/request#request-status
    (make-struct-field-accessor std/net/request#request::t '3))
  (define std/net/request#request-status-text
    (make-struct-field-accessor std/net/request#request::t '4))
  (define std/net/request#request-headers
    (make-struct-field-accessor std/net/request#request::t '5))
  (define std/net/request#request-body
    (make-struct-field-accessor std/net/request#request::t '6))
  (define std/net/request#request-encoding
    (make-struct-field-accessor std/net/request#request::t '7))
  (define std/net/request#request-port-set!
    (make-struct-field-mutator std/net/request#request::t '0))
  (define std/net/request#request-url-set!
    (make-struct-field-mutator std/net/request#request::t '1))
  (define std/net/request#request-history-set!
    (make-struct-field-mutator std/net/request#request::t '2))
  (define std/net/request#request-status-set!
    (make-struct-field-mutator std/net/request#request::t '3))
  (define std/net/request#request-status-text-set!
    (make-struct-field-mutator std/net/request#request::t '4))
  (define std/net/request#request-headers-set!
    (make-struct-field-mutator std/net/request#request::t '5))
  (define std/net/request#request-body-set!
    (make-struct-field-mutator std/net/request#request::t '6))
  (define std/net/request#request-encoding-set!
    (make-struct-field-mutator std/net/request#request::t '7))
  (define std/net/request#request:::init!
    (lambda (_self116352_ _port116353_ _url116354_ _history116355_)
      (if (##fx< '3 (##vector-length _self116352_))
          (begin
            (##vector-set! _self116352_ '1 _port116353_)
            (##vector-set! _self116352_ '2 _url116354_)
            (##vector-set! _self116352_ '3 _history116355_))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self116352_))))
  (bind-method!
   std/net/request#request::t
   ':init!
   std/net/request#request:::init!
   '#f)
  (define std/net/request#url-target-e
    (lambda (_url116227_ _params116228_)
      (if _params116228_
          (string-append
           _url116227_
           '"?"
           (std/net/uri#form-url-encode__% _params116228_ '#f))
          _url116227_)))
  (define std/net/request#header-string-e
    (lambda (_str116225_)
      (if (string? _str116225_)
          _str116225_
          (if (symbol? _str116225_)
              (symbol->string _str116225_)
              (if (keyword? _str116225_)
                  (keyword->string _str116225_)
                  (error '"bad header key" _str116225_))))))
  (define std/net/request#make-http/1.1-headers
    (lambda (_headers116219_ _cookies116220_)
      (std/net/request#http-headers-cons!
       _headers116219_
       (std/net/request#http-headers-cons
        std/net/request#http/1.1-base-headers
        (std/net/request#http-headers-cookies
         (let ((_$e116222_ _cookies116220_))
           (if _$e116222_ _$e116222_ '())))))))
  (define std/net/request#http/1.1-base-headers
    '(("User-Agent" . "Mozilla/5.0 (compatible; gerbil/1.0)")
      ("Connection" . "close")
      ("Accept" . "*/*")
      ("Accept-Encoding" . "gzip, deflate, identity")))
  (define std/net/request#http-headers-cookies
    (lambda (_cookies116184_)
      (letrec ((_fold-e116186_
                (lambda (_cookie116188_ _str116189_)
                  (let* ((_cookie116190116197_ _cookie116188_)
                         (_E116192116201_
                          (lambda ()
                            (error '"No clause matching"
                                   _cookie116190116197_)))
                         (_K116193116207_
                          (lambda (_value116204_ _key116205_)
                            (if (string-empty? _str116189_)
                                (std/format#format
                                 '"~a=~a"
                                 _key116205_
                                 _value116204_)
                                (std/format#format
                                 '"~a; ~a=~a"
                                 _str116189_
                                 _key116205_
                                 _value116204_)))))
                    (if (##pair? _cookie116190116197_)
                        (let ((_hd116194116210_ (##car _cookie116190116197_))
                              (_tl116195116212_ (##cdr _cookie116190116197_)))
                          (let* ((_key116215_ _hd116194116210_)
                                 (_value116217_ _tl116195116212_))
                            (_K116193116207_ _value116217_ _key116215_)))
                        (_E116192116201_))))))
        (if (null? _cookies116184_)
            '()
            (cons (cons '"Cookie" (foldr1 _fold-e116186_ _cookies116184_ '""))
                  '())))))
  (define std/net/request#http-headers-cons
    (lambda (_new-headers116144_ _headers116145_)
      (letrec ((_fold-e116147_
                (lambda (_header116149_ _headers116150_)
                  (let* ((_header116151116158_ _header116149_)
                         (_E116153116162_
                          (lambda ()
                            (error '"No clause matching"
                                   _header116151116158_)))
                         (_K116154116172_
                          (lambda (_value116165_ _key116166_)
                            (let ((_key116168_
                                   (std/srfi/13#string-titlecase__0
                                    (std/net/request#header-string-e
                                     _key116166_))))
                              (if (assoc _key116168_ _headers116150_)
                                  _headers116150_
                                  (let ((_value116170_
                                         (std/format#format
                                          '"~a"
                                          _value116165_)))
                                    (cons (cons _key116168_ _value116170_)
                                          _headers116150_)))))))
                    (if (##pair? _header116151116158_)
                        (let ((_hd116155116175_ (##car _header116151116158_))
                              (_tl116156116177_ (##cdr _header116151116158_)))
                          (let* ((_key116180_ _hd116155116175_)
                                 (_value116182_ _tl116156116177_))
                            (_K116154116172_ _value116182_ _key116180_)))
                        (_E116153116162_))))))
        (foldr1 _fold-e116147_ _headers116145_ _new-headers116144_))))
  (define std/net/request#http-headers-cons!
    (lambda (_new-headers116100_ _headers116101_)
      (letrec ((_fold-e116103_
                (lambda (_header116105_ _headers116106_)
                  (let* ((_header116107116114_ _header116105_)
                         (_E116109116118_
                          (lambda ()
                            (error '"No clause matching"
                                   _header116107116114_)))
                         (_K116110116132_
                          (lambda (_value116121_ _key116122_)
                            (let ((_key116124_
                                   (std/srfi/13#string-titlecase__0
                                    (std/net/request#header-string-e
                                     _key116122_)))
                                  (_value116125_
                                   (std/format#format '"~a" _value116121_)))
                              (let ((_$e116127_
                                     (assoc _key116124_ _headers116106_)))
                                (if _$e116127_
                                    ((lambda (_pair116130_)
                                       (set-cdr! _pair116130_ _value116125_)
                                       _headers116106_)
                                     _$e116127_)
                                    (cons (cons _key116124_ _value116125_)
                                          _headers116106_)))))))
                    (if (##pair? _header116107116114_)
                        (let ((_hd116111116135_ (##car _header116107116114_))
                              (_tl116112116137_ (##cdr _header116107116114_)))
                          (let* ((_key116140_ _hd116111116135_)
                                 (_value116142_ _tl116112116137_))
                            (_K116110116132_ _value116142_ _key116140_)))
                        (_E116109116118_))))))
        (foldr1 _fold-e116103_ _headers116101_ _new-headers116100_))))
  (define std/net/request#http-get__%
    (lambda (_g116360_
             _redirect116059116065_
             _headers116060116067_
             _cookies116061116069_
             _params116062116071_
             _url116073_)
      (let* ((_redirect116075_
              (if (eq? _redirect116059116065_ absent-value)
                  '#t
                  _redirect116059116065_))
             (_headers116077_
              (if (eq? _headers116060116067_ absent-value)
                  '#f
                  _headers116060116067_))
             (_cookies116079_
              (if (eq? _cookies116061116069_ absent-value)
                  '#f
                  _cookies116061116069_))
             (_params116081_
              (if (eq? _params116062116071_ absent-value)
                  '#f
                  _params116062116071_)))
        (let ((_url116083_
               (std/net/request#url-target-e _url116073_ _params116081_))
              (_headers116084_
               (std/net/request#make-http/1.1-headers
                _headers116077_
                _cookies116079_)))
          (std/net/request#http-request
           'GET
           _url116083_
           _headers116084_
           '#f
           '()
           _redirect116075_)))))
  (define std/net/request#http-get__@
    (lambda (_keys116058116089_ . _args116091_)
      (apply std/net/request#http-get__%
             _keys116058116089_
             (table-ref _keys116058116089_ 'redirect: absent-value)
             (table-ref _keys116058116089_ 'headers: absent-value)
             (table-ref _keys116058116089_ 'cookies: absent-value)
             (table-ref _keys116058116089_ 'params: absent-value)
             _args116091_)))
  (define std/net/request#http-get
    (lambda _args116063116097_
      (apply keyword-dispatch
             '#(params:
                cookies:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                redirect:
                headers:
                #f
                #f
                #f
                #f)
             std/net/request#http-get__@
             _args116063116097_)))
  (define std/net/request#http-head__%
    (lambda (_g116361_
             _redirect116016116022_
             _headers116017116024_
             _cookies116018116026_
             _params116019116028_
             _url116030_)
      (let* ((_redirect116032_
              (if (eq? _redirect116016116022_ absent-value)
                  '#t
                  _redirect116016116022_))
             (_headers116034_
              (if (eq? _headers116017116024_ absent-value)
                  '#f
                  _headers116017116024_))
             (_cookies116036_
              (if (eq? _cookies116018116026_ absent-value)
                  '#f
                  _cookies116018116026_))
             (_params116038_
              (if (eq? _params116019116028_ absent-value)
                  '#f
                  _params116019116028_)))
        (let ((_url116040_
               (std/net/request#url-target-e _url116030_ _params116038_))
              (_headers116041_
               (std/net/request#make-http/1.1-headers
                _headers116034_
                _cookies116036_)))
          (std/net/request#http-request
           'HEAD
           _url116040_
           _headers116041_
           '#f
           '()
           _redirect116032_)))))
  (define std/net/request#http-head__@
    (lambda (_keys116015116046_ . _args116048_)
      (apply std/net/request#http-head__%
             _keys116015116046_
             (table-ref _keys116015116046_ 'redirect: absent-value)
             (table-ref _keys116015116046_ 'headers: absent-value)
             (table-ref _keys116015116046_ 'cookies: absent-value)
             (table-ref _keys116015116046_ 'params: absent-value)
             _args116048_)))
  (define std/net/request#http-head
    (lambda _args116020116054_
      (apply keyword-dispatch
             '#(params:
                cookies:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                redirect:
                headers:
                #f
                #f
                #f
                #f)
             std/net/request#http-head__@
             _args116020116054_)))
  (define std/net/request#http-post__%
    (lambda (_g116362_
             _headers115971115977_
             _cookies115972115979_
             _params115973115981_
             _data115974115983_
             _url115985_)
      (let* ((_headers115987_
              (if (eq? _headers115971115977_ absent-value)
                  '#f
                  _headers115971115977_))
             (_cookies115989_
              (if (eq? _cookies115972115979_ absent-value)
                  '#f
                  _cookies115972115979_))
             (_params115991_
              (if (eq? _params115973115981_ absent-value)
                  '#f
                  _params115973115981_))
             (_data115993_
              (if (eq? _data115974115983_ absent-value)
                  '#f
                  _data115974115983_))
             (_g116363_
              (if _params115991_
                  (let ((_form-data115995_
                         (std/net/uri#form-url-encode__% _params115991_ '#t)))
                    (values (std/net/request#http-headers-cons
                             '(("Content-Type"
                                .
                                "application/x-www-form-urlencoded"))
                             (std/net/request#make-http/1.1-headers
                              _headers115987_
                              _cookies115989_))
                            _form-data115995_))
                  (values (std/net/request#make-http/1.1-headers
                           _headers115987_
                           _cookies115989_)
                          _data115993_))))
        (begin
          #!void
          (let ((_headers115997_ (##vector-ref _g116363_ 0))
                (_data115998_ (##vector-ref _g116363_ 1)))
            (std/net/request#http-request
             'POST
             _url115985_
             _headers115997_
             _data115998_
             '()
             '#f))))))
  (define std/net/request#http-post__@
    (lambda (_keys115970116003_ . _args116005_)
      (apply std/net/request#http-post__%
             _keys115970116003_
             (table-ref _keys115970116003_ 'headers: absent-value)
             (table-ref _keys115970116003_ 'cookies: absent-value)
             (table-ref _keys115970116003_ 'params: absent-value)
             (table-ref _keys115970116003_ 'data: absent-value)
             _args116005_)))
  (define std/net/request#http-post
    (lambda _args115975116011_
      (apply keyword-dispatch
             '#(#f data: #f headers: params: #f cookies: #f #f)
             std/net/request#http-post__@
             _args115975116011_)))
  (define std/net/request#http-put__%
    (lambda (_g116364_
             _headers115928115934_
             _cookies115929115936_
             _params115930115938_
             _data115931115940_
             _url115942_)
      (let* ((_headers115944_
              (if (eq? _headers115928115934_ absent-value)
                  '#f
                  _headers115928115934_))
             (_cookies115946_
              (if (eq? _cookies115929115936_ absent-value)
                  '#f
                  _cookies115929115936_))
             (_params115948_
              (if (eq? _params115930115938_ absent-value)
                  '#f
                  _params115930115938_))
             (_data115950_
              (if (eq? _data115931115940_ absent-value)
                  '#f
                  _data115931115940_)))
        (let ((_url115952_
               (std/net/request#url-target-e _url115942_ _params115948_))
              (_headers115953_
               (std/net/request#make-http/1.1-headers
                _headers115944_
                _cookies115946_)))
          (std/net/request#http-request
           'PUT
           _url115952_
           _headers115953_
           _data115950_
           '()
           '#f)))))
  (define std/net/request#http-put__@
    (lambda (_keys115927115958_ . _args115960_)
      (apply std/net/request#http-put__%
             _keys115927115958_
             (table-ref _keys115927115958_ 'headers: absent-value)
             (table-ref _keys115927115958_ 'cookies: absent-value)
             (table-ref _keys115927115958_ 'params: absent-value)
             (table-ref _keys115927115958_ 'data: absent-value)
             _args115960_)))
  (define std/net/request#http-put
    (lambda _args115932115966_
      (apply keyword-dispatch
             '#(#f data: #f headers: params: #f cookies: #f #f)
             std/net/request#http-put__@
             _args115932115966_)))
  (define std/net/request#http-delete__%
    (lambda (_g116365_
             _headers115890115895_
             _cookies115891115897_
             _params115892115899_
             _url115901_)
      (let* ((_headers115903_
              (if (eq? _headers115890115895_ absent-value)
                  '#f
                  _headers115890115895_))
             (_cookies115905_
              (if (eq? _cookies115891115897_ absent-value)
                  '#f
                  _cookies115891115897_))
             (_params115907_
              (if (eq? _params115892115899_ absent-value)
                  '#f
                  _params115892115899_)))
        (let ((_url115909_
               (std/net/request#url-target-e _url115901_ _params115907_))
              (_headers115910_
               (std/net/request#make-http/1.1-headers
                _headers115903_
                _cookies115905_)))
          (std/net/request#http-request
           'DELETE
           _url115909_
           _headers115910_
           '#f
           '()
           '#f)))))
  (define std/net/request#http-delete__@
    (lambda (_keys115889115915_ . _args115917_)
      (apply std/net/request#http-delete__%
             _keys115889115915_
             (table-ref _keys115889115915_ 'headers: absent-value)
             (table-ref _keys115889115915_ 'cookies: absent-value)
             (table-ref _keys115889115915_ 'params: absent-value)
             _args115917_)))
  (define std/net/request#http-delete
    (lambda _args115893115923_
      (apply keyword-dispatch
             '#(cookies: headers: #f params:)
             std/net/request#http-delete__@
             _args115893115923_)))
  (define std/net/request#http-options__%
    (lambda (_g116366_
             _headers115852115857_
             _cookies115853115859_
             _params115854115861_
             _url115863_)
      (let* ((_headers115865_
              (if (eq? _headers115852115857_ absent-value)
                  '#f
                  _headers115852115857_))
             (_cookies115867_
              (if (eq? _cookies115853115859_ absent-value)
                  '#f
                  _cookies115853115859_))
             (_params115869_
              (if (eq? _params115854115861_ absent-value)
                  '#f
                  _params115854115861_)))
        (let ((_url115871_
               (std/net/request#url-target-e _url115863_ _params115869_))
              (_headers115872_
               (std/net/request#make-http/1.1-headers
                _headers115865_
                _cookies115867_)))
          (std/net/request#http-request
           'HEAD
           _url115871_
           _headers115872_
           '#f
           '()
           '#f)))))
  (define std/net/request#http-options__@
    (lambda (_keys115851115877_ . _args115879_)
      (apply std/net/request#http-options__%
             _keys115851115877_
             (table-ref _keys115851115877_ 'headers: absent-value)
             (table-ref _keys115851115877_ 'cookies: absent-value)
             (table-ref _keys115851115877_ 'params: absent-value)
             _args115879_)))
  (define std/net/request#http-options
    (lambda _args115855115885_
      (apply keyword-dispatch
             '#(cookies: headers: #f params:)
             std/net/request#http-options__@
             _args115855115885_)))
  (define std/net/request#url-rx
    (std/pregexp#pregexp '"(?:(https?)://)?([^/:]+)(:[0-9]+)?(/.*)?"))
  (define std/net/request#+tls-context+
    (make-promise (lambda () (make-tls-context))))
  (define std/net/request#http-request
    (lambda (_method115717_
             _url115718_
             _user-headers115719_
             _body115720_
             _history115721_
             _redirect115722_)
      (let* ((_g115723115738_
              (std/pregexp#pregexp-match std/net/request#url-rx _url115718_))
             (_E115725115742_
              (lambda () (error '"No clause matching" _g115723115738_)))
             (_K115726115815_
              (lambda (_target115745_ _port115746_ _host115747_ _scheme115748_)
                (let* ((_scheme115753_
                        (let ((_$e115750_ _scheme115748_))
                          (if _$e115750_ _$e115750_ '"http")))
                       (_port115755_
                        (if _port115746_
                            (string->number
                             (substring
                              _port115746_
                              '1
                              (string-length _port115746_)))
                            (if (equal? _scheme115753_ '"https") '443 '80)))
                       (_target115760_
                        (let ((_$e115757_ _target115745_))
                          (if _$e115757_ _$e115757_ '"/")))
                       (_host-header115768_
                        (let ((_$e115762_ _port115755_))
                          (if (or (eq? '80 _$e115762_) (eq? '443 _$e115762_))
                              _host115747_
                              (std/format#format
                               '"~a:~a"
                               _host115747_
                               _port115755_))))
                       (_headers115770_
                        (std/net/request#http-headers-cons
                         (cons (cons '"Host" _host-header115768_) '())
                         _user-headers115719_))
                       (_body115772_
                        (if (not _body115720_)
                            '#f
                            (if (u8vector? _body115720_)
                                _body115720_
                                (if (string? _body115720_)
                                    (std/text/utf8#string->utf8__0
                                     _body115720_)
                                    (error '"bad request body"
                                           _body115720_)))))
                       (_headers115774_
                        (if _body115772_
                            (std/net/request#http-headers-cons!
                             (cons (cons '"Content-Length"
                                         (u8vector-length _body115772_))
                                   '())
                             _headers115770_)
                            _headers115770_))
                       (_tcp-client-options115776_
                        (cons 'server-address:
                              (cons _host115747_
                                    (cons 'port-number:
                                          (cons _port115755_
                                                (cons 'eol-encoding:
                                                      (cons 'cr-lf '())))))))
                       (_tcp-client-options115778_
                        (if (equal? _scheme115753_ '"https")
                            (cons 'tls-context:
                                  (cons (force std/net/request#+tls-context+)
                                        _tcp-client-options115776_))
                            _tcp-client-options115776_))
                       (_sock115780_
                        (open-tcp-client _tcp-client-options115778_))
                       (_req115782_
                        (let ((__obj116359
                               (make-object std/net/request#request::t '8)))
                          (if (##fx< '3 (##vector-length __obj116359))
                              (begin
                                (##vector-set! __obj116359 '1 _sock115780_)
                                (##vector-set! __obj116359 '2 _url115718_)
                                (##vector-set! __obj116359 '3 _history115721_))
                              (error '"struct-instance-init!: too many arguments for struct"
                                     __obj116359))
                          __obj116359)))
                  (std/net/request#http-request-write
                   _sock115780_
                   _method115717_
                   _target115760_
                   _headers115774_
                   _body115772_)
                  (std/net/request#http-request-read-response! _req115782_)
                  (let ((_$e115785_
                         (if _redirect115722_
                             (if (memv (##structure-ref
                                        _req115782_
                                        '4
                                        std/net/request#request::t
                                        '#f)
                                       '(301 302 303 307))
                                 (if (memq _method115717_ '(GET HEAD))
                                     (assoc '"Location"
                                            (##structure-ref
                                             _req115782_
                                             '6
                                             std/net/request#request::t
                                             '#f))
                                     '#f)
                                 '#f)
                             '#f)))
                    (if _$e115785_
                        ((lambda (_e115787115789_)
                           (let* ((_g115791115798_ _e115787115789_)
                                  (_E115793115802_
                                   (lambda ()
                                     (error '"No clause matching"
                                            _g115791115798_)))
                                  (_K115794115807_
                                   (lambda (_new-url115805_)
                                     (if (member _new-url115805_
                                                 _history115721_)
                                         (error '"URL redirection loop"
                                                _url115718_)
                                         (begin
                                           (std/net/request#request-close
                                            _req115782_)
                                           (std/net/request#http-request
                                            _method115717_
                                            _new-url115805_
                                            _user-headers115719_
                                            _body115772_
                                            (cons _url115718_ _history115721_)
                                            '#t))))))
                             (if (##pair? _g115791115798_)
                                 (let* ((_tl115796115810_
                                         (##cdr _g115791115798_))
                                        (_new-url115813_ _tl115796115810_))
                                   (_K115794115807_ _new-url115813_))
                                 (_E115793115802_))))
                         _$e115785_)
                        _req115782_))))))
        (if (##pair? _g115723115738_)
            (let ((_tl115728115818_ (##cdr _g115723115738_)))
              (if (##pair? _tl115728115818_)
                  (let ((_hd115729115821_ (##car _tl115728115818_))
                        (_tl115730115823_ (##cdr _tl115728115818_)))
                    (let ((_scheme115826_ _hd115729115821_))
                      (if (##pair? _tl115730115823_)
                          (let ((_hd115731115828_ (##car _tl115730115823_))
                                (_tl115732115830_ (##cdr _tl115730115823_)))
                            (let ((_host115833_ _hd115731115828_))
                              (if (##pair? _tl115732115830_)
                                  (let ((_hd115733115835_
                                         (##car _tl115732115830_))
                                        (_tl115734115837_
                                         (##cdr _tl115732115830_)))
                                    (let ((_port115840_ _hd115733115835_))
                                      (if (##pair? _tl115734115837_)
                                          (let ((_hd115735115842_
                                                 (##car _tl115734115837_))
                                                (_tl115736115844_
                                                 (##cdr _tl115734115837_)))
                                            (let ((_target115847_
                                                   _hd115735115842_))
                                              (if (##null? _tl115736115844_)
                                                  (_K115726115815_
                                                   _target115847_
                                                   _port115840_
                                                   _host115833_
                                                   _scheme115826_)
                                                  (_E115725115742_))))
                                          (_E115725115742_))))
                                  (_E115725115742_))))
                          (_E115725115742_))))
                  (_E115725115742_)))
            (_E115725115742_)))))
  (define std/net/request#http-request-write
    (lambda (_port115679_
             _method115680_
             _target115681_
             _headers115682_
             _body115683_)
      (std/format#fprintf
       _port115679_
       '"~a ~a HTTP/1.1~n"
       _method115680_
       _target115681_)
      (for-each
       (lambda (_e115684115686_)
         (let* ((_g115688115695_ _e115684115686_)
                (_E115690115699_
                 (lambda () (error '"No clause matching" _g115688115695_)))
                (_K115691115705_
                 (lambda (_val115702_ _key115703_)
                   (std/format#fprintf
                    _port115679_
                    '"~a: ~a~n"
                    _key115703_
                    _val115702_))))
           (if (##pair? _g115688115695_)
               (let ((_hd115692115708_ (##car _g115688115695_))
                     (_tl115693115710_ (##cdr _g115688115695_)))
                 (let* ((_key115713_ _hd115692115708_)
                        (_val115715_ _tl115693115710_))
                   (_K115691115705_ _val115715_ _key115713_)))
               (_E115690115699_))))
       _headers115682_)
      (newline _port115679_)
      (if _body115683_
          (begin
            (write-subu8vector
             _body115683_
             '0
             (u8vector-length _body115683_)
             _port115679_)
            (newline _port115679_))
          '#!void)
      (force-output _port115679_)))
  (define std/net/request#status-line-rx
    (std/pregexp#pregexp '"([0-9]{3})\\s+(.*)"))
  (define std/net/request#header-line-rx
    (std/pregexp#pregexp '"([^:]+):\\s*(.*)?"))
  (define std/net/request#http-request-read-response!
    (lambda (_req115576_)
      (let* ((_port115578_
              (##structure-ref _req115576_ '1 std/net/request#request::t '#f))
             (_status-line115580_
              (std/net/request#read-response-line _port115578_)))
        (let* ((_g115582115594_
                (std/pregexp#pregexp-match
                 std/net/request#status-line-rx
                 _status-line115580_))
               (_else115584115602_
                (lambda ()
                  (std/error#raise-io-error
                   'http-request-read-response!
                   '"malformed status line"
                   _port115578_
                   _status-line115580_)))
               (_K115586115659_
                (lambda (_status-text115605_ _status115606_)
                  (##structure-set!
                   _req115576_
                   (string->number _status115606_)
                   '4
                   std/net/request#request::t
                   '#f)
                  (##structure-set!
                   _req115576_
                   (std/srfi/13#string-trim-both__0 _status-text115605_)
                   '5
                   std/net/request#request::t
                   '#f)
                  (let _lp115608_ ((_headers115610_ '()))
                    (let ((_next115612_
                           (std/net/request#read-response-line _port115578_)))
                      (if (string-empty? _next115612_)
                          (##structure-set!
                           _req115576_
                           (reverse _headers115610_)
                           '6
                           std/net/request#request::t
                           '#f)
                          (let* ((_g115613115625_
                                  (std/pregexp#pregexp-match
                                   std/net/request#header-line-rx
                                   _next115612_))
                                 (_else115615115633_
                                  (lambda ()
                                    (std/error#raise-io-error
                                     'http-request-read-response!
                                     '"Malformed header"
                                     _port115578_
                                     _next115612_)))
                                 (_K115617115639_
                                  (lambda (_value115636_ _key115637_)
                                    (_lp115608_
                                     (cons (cons (std/srfi/13#string-titlecase__0
                                                  _key115637_)
                                                 (std/srfi/13#string-trim-both__0
                                                  _value115636_))
                                           _headers115610_)))))
                            (if (##pair? _g115613115625_)
                                (let ((_tl115619115642_
                                       (##cdr _g115613115625_)))
                                  (if (##pair? _tl115619115642_)
                                      (let ((_hd115620115645_
                                             (##car _tl115619115642_))
                                            (_tl115621115647_
                                             (##cdr _tl115619115642_)))
                                        (let ((_key115650_ _hd115620115645_))
                                          (if (##pair? _tl115621115647_)
                                              (let ((_hd115622115652_
                                                     (##car _tl115621115647_))
                                                    (_tl115623115654_
                                                     (##cdr _tl115621115647_)))
                                                (let ((_value115657_
                                                       _hd115622115652_))
                                                  (if (##null? _tl115623115654_)
                                                      (_K115617115639_
                                                       _value115657_
                                                       _key115650_)
                                                      (_else115615115633_))))
                                              (_else115615115633_))))
                                      (_else115615115633_)))
                                (_else115615115633_)))))))))
          (if (##pair? _g115582115594_)
              (let ((_tl115588115662_ (##cdr _g115582115594_)))
                (if (##pair? _tl115588115662_)
                    (let ((_hd115589115665_ (##car _tl115588115662_))
                          (_tl115590115667_ (##cdr _tl115588115662_)))
                      (let ((_status115670_ _hd115589115665_))
                        (if (##pair? _tl115590115667_)
                            (let ((_hd115591115672_ (##car _tl115590115667_))
                                  (_tl115592115674_ (##cdr _tl115590115667_)))
                              (let ((_status-text115677_ _hd115591115672_))
                                (if (##null? _tl115592115674_)
                                    (_K115586115659_
                                     _status-text115677_
                                     _status115670_)
                                    (_else115584115602_))))
                            (_else115584115602_))))
                    (_else115584115602_)))
              (_else115584115602_))))))
  (define std/net/request#http-request-read-body
    (lambda (_port115561_ _headers115562_)
      (letrec ((_length-e115564_
                (lambda (_headers115571_)
                  (let ((_$e115573_
                         (assget '"Content-Length" _headers115571_)))
                    (if _$e115573_ (string->number _$e115573_) '#f)))))
        (let ((_$e115566_ (assget '"Transfer-Encoding" _headers115562_)))
          (if _$e115566_
              ((lambda (_tenc115569_)
                 (if (not (equal? '"identity" _tenc115569_))
                     (std/net/request#http-request-read-chunked-body
                      _port115561_)
                     (std/net/request#http-request-read-simple-body
                      _port115561_
                      (_length-e115564_ _headers115562_))))
               _$e115566_)
              (std/net/request#http-request-read-simple-body
               _port115561_
               (_length-e115564_ _headers115562_)))))))
  (define std/net/request#http-request-read-chunked-body
    (lambda (_port115545_)
      (let _lp115547_ ((_chunks115549_ '()))
        (let* ((_line115551_ (std/net/request#read-response-line _port115545_))
               (_clen115553_
                (string->number
                 (car (string-split _line115551_ '#\space))
                 '16)))
          (if (fxzero? _clen115553_)
              (append-u8vectors (reverse _chunks115549_))
              (let* ((_chunk115556_ (make-u8vector _clen115553_))
                     (_rd115558_
                      (read-subu8vector
                       _chunk115556_
                       '0
                       _clen115553_
                       _port115545_)))
                (if (##fx< _rd115558_ _clen115553_)
                    (std/error#raise-io-error
                     'http-request-read-body
                     '"error reading chunk; premature end of port")
                    '#!void)
                (std/net/request#read-response-line _port115545_)
                (_lp115547_ (cons _chunk115556_ _chunks115549_))))))))
  (define std/net/request#http-request-read-simple-body
    (lambda (_port115518_ _length115519_)
      (letrec ((_read/length115521_
                (lambda (_port115537_ _length115538_)
                  (let* ((_data115540_ (make-u8vector _length115538_))
                         (_rd115542_
                          (read-subu8vector
                           _data115540_
                           '0
                           _length115538_
                           _port115537_)))
                    (if (##fx< _rd115542_ _length115538_)
                        (begin
                          (u8vector-shrink! _data115540_ _rd115542_)
                          _data115540_)
                        _data115540_))))
               (_read/end115522_
                (lambda (_port115524_)
                  (let _lp115526_ ((_chunks115528_ '()))
                    (let* ((_buflen115530_ '4096)
                           (_buf115532_ (make-u8vector _buflen115530_))
                           (_rd115534_
                            (read-subu8vector
                             _buf115532_
                             '0
                             _buflen115530_
                             _port115524_)))
                      (if (##fxzero? _rd115534_)
                          (append-u8vectors (reverse _chunks115528_))
                          (if (##fx< _rd115534_ _buflen115530_)
                              (begin
                                (u8vector-shrink! _buf115532_ _rd115534_)
                                (append-u8vectors
                                 (reverse (cons _buf115532_ _chunks115528_))))
                              (_lp115526_
                               (cons _buf115532_ _chunks115528_)))))))))
        (if _length115519_
            (_read/length115521_ _port115518_ _length115519_)
            (_read/end115522_ _port115518_)))))
  (define std/net/request#cr (char->integer '#\return))
  (define std/net/request#lf (char->integer '#\newline))
  (define std/net/request#crlf
    (u8vector std/net/request#cr std/net/request#lf))
  (define std/net/request#read-response-line
    (lambda (_port115508_)
      (let _lp115510_ ((_r115512_ '()))
        (let ((_next115514_ (read-u8 _port115508_)))
          (if (eof-object? _next115514_)
              (std/error#raise-io-error
               'request-read-response-line
               '"Incomplete response; connection closed"
               _port115508_)
              (if (eq? _next115514_ std/net/request#cr)
                  (let ((_next115516_ (read-u8 _port115508_)))
                    (if (eof-object? _next115516_)
                        (std/error#raise-io-error
                         'request-read-response-line
                         '"Incomplete response; connection closed"
                         _port115508_)
                        (if (eq? _next115516_ std/net/request#lf)
                            (std/text/utf8#utf8->string__0
                             (list->u8vector (reverse _r115512_)))
                            (_lp115510_
                             (cons _next115516_
                                   (cons std/net/request#cr _r115512_))))))
                  (_lp115510_ (cons _next115514_ _r115512_))))))))
  (define std/net/request#request-close
    (lambda (_req115499_)
      (let ((_port115500115502_
             (##structure-ref _req115499_ '1 std/net/request#request::t '#f)))
        (if _port115500115502_
            (let ((_port115505_ _port115500115502_))
              (with-exception-catcher
               void
               (lambda () (close-port _port115505_)))
              (##structure-set!
               _req115499_
               '#f
               '1
               std/net/request#request::t
               '#f))
            '#f))))
  (define std/net/request#request::destroy std/net/request#request-close)
  (bind-method!
   std/net/request#request::t
   'destroy
   std/net/request#request::destroy
   '#f)
  (define std/net/request#request-content
    (lambda (_req115346_)
      (let ((_$e115348_
             (##structure-ref _req115346_ '7 std/net/request#request::t '#f)))
        (if _$e115348_
            (values _$e115348_)
            (let ((_$e115351_
                   (##structure-ref
                    _req115346_
                    '1
                    std/net/request#request::t
                    '#f)))
              (if _$e115351_
                  ((lambda (_port115354_)
                     (let ((_headers115356_
                            (##structure-ref
                             _req115346_
                             '6
                             std/net/request#request::t
                             '#f)))
                       (with-unwind-protect
                        (lambda ()
                          (let* ((_body115359_
                                  (std/net/request#http-request-read-body
                                   _port115354_
                                   _headers115356_))
                                 (_body115372_
                                  (let ((_$e115361_
                                         (assoc '"Content-Encoding"
                                                _headers115356_)))
                                    (if _$e115361_
                                        ((lambda (_enc115364_)
                                           (let ((_$e115366_
                                                  (cdr _enc115364_)))
                                             (if (or (equal? '"gzip"
                                                             _$e115366_)
                                                     (equal? '"deflate"
                                                             _$e115366_))
                                                 (std/text/zlib#uncompress
                                                  _body115359_)
                                                 (if (equal? '"identity"
                                                             _$e115366_)
                                                     _body115359_
                                                     (error '"Unsupported content encoding"
                                                            _enc115364_)))))
                                         _$e115361_)
                                        _body115359_))))
                            (##structure-set!
                             _req115346_
                             _body115372_
                             '7
                             std/net/request#request::t
                             '#f)
                            _body115372_))
                        (lambda ()
                          (close-port _port115354_)
                          (##structure-set!
                           _req115346_
                           '#f
                           '1
                           std/net/request#request::t
                           '#f)))))
                   _$e115351_)
                  '#f))))))
  (define std/net/request#request-text
    (lambda (_req115337_)
      (letrec ((_get-text115339_
                (lambda (_enc115344_)
                  (if (eq? _enc115344_ 'UTF-8)
                      (std/text/utf8#utf8->string__0
                       (std/net/request#request-content _req115337_))
                      (bytes->string
                       (std/net/request#request-content _req115337_)
                       _enc115344_)))))
        (let ((_$e115341_
               (##structure-ref
                _req115337_
                '8
                std/net/request#request::t
                '#f)))
          (if _$e115341_
              (_get-text115339_ _$e115341_)
              (_get-text115339_ 'UTF-8))))))
  (define std/net/request#request-json
    (lambda (_req115335_)
      (std/text/json#string->json-object
       (std/net/request#request-text _req115335_))))
  (define std/net/request#request-cookies
    (lambda (_req115265_)
      (let _lp115267_ ((_rest115269_
                        (##structure-ref
                         _req115265_
                         '6
                         std/net/request#request::t
                         '#f))
                       (_cookies115270_ '()))
        (let* ((_rest115271115279_ _rest115269_)
               (_else115273115287_ (lambda () (reverse _cookies115270_)))
               (_K115275115323_
                (lambda (_rest115290_ _hd115291_)
                  (let* ((_hd115292115300_ _hd115291_)
                         (_else115294115308_
                          (lambda ()
                            (_lp115267_ _rest115290_ _cookies115270_)))
                         (_K115296115313_
                          (lambda (_cookie115311_)
                            (_lp115267_
                             _rest115290_
                             (cons _cookie115311_ _cookies115270_)))))
                    (if (##pair? _hd115292115300_)
                        (let ((_hd115297115316_ (##car _hd115292115300_))
                              (_tl115298115318_ (##cdr _hd115292115300_)))
                          (if (equal? _hd115297115316_ '"Set-Cookie")
                              (let ((_cookie115321_ _tl115298115318_))
                                (_K115296115313_ _cookie115321_))
                              (_else115294115308_)))
                        (_else115294115308_))))))
          (if (##pair? _rest115271115279_)
              (let ((_hd115276115326_ (##car _rest115271115279_))
                    (_tl115277115328_ (##cdr _rest115271115279_)))
                (let* ((_hd115331_ _hd115276115326_)
                       (_rest115333_ _tl115277115328_))
                  (_K115275115323_ _rest115333_ _hd115331_)))
              (_else115273115287_)))))))
