function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { createSearchSource, SearchSource } from './search_source';
import { getEsClient } from './legacy';
import { getForceNow } from '../query/timefilter/lib/get_force_now';
import { calculateBounds } from '../../common/query';
import { SearchInterceptor } from './search_interceptor';
import { getAggTypes, getAggTypesFunctions, AggTypesRegistry, AggConfigs, getCalculateAutoTimeExpression } from './aggs';
import { createUsageCollector } from './collectors';
export var SearchService = /*#__PURE__*/function () {
  function SearchService() {
    _classCallCheck(this, SearchService);

    _defineProperty(this, "esClient", void 0);

    _defineProperty(this, "aggTypesRegistry", new AggTypesRegistry());

    _defineProperty(this, "searchInterceptor", void 0);

    _defineProperty(this, "usageCollector", void 0);

    _defineProperty(this, "calculateBounds", function (timeRange) {
      return calculateBounds(timeRange, {
        forceNow: getForceNow()
      });
    });
  }

  _createClass(SearchService, [{
    key: "setup",
    value: function setup(core, _ref) {
      var expressions = _ref.expressions,
          usageCollection = _ref.usageCollection,
          packageInfo = _ref.packageInfo,
          getInternalStartServices = _ref.getInternalStartServices;
      this.usageCollector = createUsageCollector(core, usageCollection);
      this.esClient = getEsClient(core.injectedMetadata, core.http, packageInfo);
      var aggTypesSetup = this.aggTypesRegistry.setup(); // register each agg type

      var aggTypes = getAggTypes({
        calculateBounds: this.calculateBounds,
        getInternalStartServices: getInternalStartServices,
        uiSettings: core.uiSettings
      });
      aggTypes.buckets.forEach(function (b) {
        return aggTypesSetup.registerBucket(b);
      });
      aggTypes.metrics.forEach(function (m) {
        return aggTypesSetup.registerMetric(m);
      }); // register expression functions for each agg type

      var aggFunctions = getAggTypesFunctions();
      aggFunctions.forEach(function (fn) {
        return expressions.registerFunction(fn);
      });
      return {
        aggs: {
          calculateAutoTimeExpression: getCalculateAutoTimeExpression(core.uiSettings),
          types: aggTypesSetup
        }
      };
    }
  }, {
    key: "start",
    value: function start(core, dependencies) {
      var _this = this;

      /**
       * A global object that intercepts all searches and provides convenience methods for cancelling
       * all pending search requests, as well as getting the number of pending search requests.
       * TODO: Make this modular so that apps can opt in/out of search collection, or even provide
       * their own search collector instances
       */
      this.searchInterceptor = new SearchInterceptor({
        toasts: core.notifications.toasts,
        application: core.application,
        http: core.http,
        uiSettings: core.uiSettings,
        usageCollector: this.usageCollector
      }, core.injectedMetadata.getInjectedVar('esRequestTimeout'));
      var aggTypesStart = this.aggTypesRegistry.start();

      var search = function search(request, options) {
        return _this.searchInterceptor.search(request, options);
      };

      var legacySearch = {
        esClient: this.esClient
      };
      var searchSourceDependencies = {
        uiSettings: core.uiSettings,
        injectedMetadata: core.injectedMetadata,
        search: search,
        legacySearch: legacySearch
      };
      return {
        aggs: {
          calculateAutoTimeExpression: getCalculateAutoTimeExpression(core.uiSettings),
          createAggConfigs: function createAggConfigs(indexPattern) {
            var configStates = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
            var schemas = arguments.length > 2 ? arguments[2] : undefined;
            return new AggConfigs(indexPattern, configStates, {
              typesRegistry: aggTypesStart
            });
          },
          types: aggTypesStart
        },
        search: search,
        usageCollector: this.usageCollector,
        searchSource: {
          create: createSearchSource(dependencies.indexPatterns, searchSourceDependencies),
          createEmpty: function createEmpty() {
            return new SearchSource({}, searchSourceDependencies);
          }
        },
        setInterceptor: function setInterceptor(searchInterceptor) {
          // TODO: should an intercepror have a destroy method?
          _this.searchInterceptor = searchInterceptor;
        },
        __LEGACY: legacySearch
      };
    }
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return SearchService;
}();