function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * @name SearchSource
 *
 * @description A promise-based stream of search results that can inherit from other search sources.
 *
 * Because filters/queries in Kibana have different levels of persistence and come from different
 * places, it is important to keep track of where filters come from for when they are saved back to
 * the savedObject store in the Kibana index. To do this, we create trees of searchSource objects
 * that can have associated query parameters (index, query, filter, etc) which can also inherit from
 * other searchSource objects.
 *
 * At query time, all of the searchSource objects that have subscribers are "flattened", at which
 * point the query params from the searchSource are collected while traversing up the inheritance
 * chain. At each link in the chain a decision about how to merge the query params is made until a
 * single set of query parameters is created for each active searchSource (a searchSource with
 * subscribers).
 *
 * That set of query parameters is then sent to elasticsearch. This is how the filter hierarchy
 * works in Kibana.
 *
 * Visualize, starting from a new search:
 *
 *  - the `savedVis.searchSource` is set as the `appSearchSource`.
 *  - The `savedVis.searchSource` would normally inherit from the `appSearchSource`, but now it is
 *    upgraded to inherit from the `rootSearchSource`.
 *  - Any interaction with the visualization will still apply filters to the `appSearchSource`, so
 *    they will be stored directly on the `savedVis.searchSource`.
 *  - Any interaction with the time filter will be written to the `rootSearchSource`, so those
 *    filters will not be saved by the `savedVis`.
 *  - When the `savedVis` is saved to elasticsearch, it takes with it all the filters that are
 *    defined on it directly, but none of the ones that it inherits from other places.
 *
 * Visualize, starting from an existing search:
 *
 *  - The `savedVis` loads the `savedSearch` on which it is built.
 *  - The `savedVis.searchSource` is set to inherit from the `saveSearch.searchSource` and set as
 *    the `appSearchSource`.
 *  - The `savedSearch.searchSource`, is set to inherit from the `rootSearchSource`.
 *  - Then the `savedVis` is written to elasticsearch it will be flattened and only include the
 *    filters created in the visualize application and will reconnect the filters from the
 *    `savedSearch` at runtime to prevent losing the relationship
 *
 * Dashboard search sources:
 *
 *  - Each panel in a dashboard has a search source.
 *  - The `savedDashboard` also has a searchsource, and it is set as the `appSearchSource`.
 *  - Each panel's search source inherits from the `appSearchSource`, meaning that they inherit from
 *    the dashboard search source.
 *  - When a filter is added to the search box, or via a visualization, it is written to the
 *    `appSearchSource`.
 */
import { setWith } from '@elastic/safer-lodash-set';
import { uniqueId, uniq, extend, pick, difference, omit, isObject, keys, isFunction } from 'lodash';
import { map } from 'rxjs/operators';
import { normalizeSortRequest } from './normalize_sort_request';
import { filterDocvalueFields } from './filter_docvalue_fields';
import { fieldWildcardFilter } from '../../../../kibana_utils/public';
import { RequestFailure, handleResponse, getSearchParamsFromRequest } from '../fetch';
import { getEsQueryConfig, buildEsQuery, UI_SETTINGS } from '../../../common';
import { getHighlightRequest } from '../../../common/field_formats';
import { fetchSoon } from '../legacy';
import { extractReferences } from './extract_references';

/** @public **/
export var SearchSource = /*#__PURE__*/function () {
  function SearchSource() {
    var fields = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var dependencies = arguments.length > 1 ? arguments[1] : undefined;

    _classCallCheck(this, SearchSource);

    _defineProperty(this, "id", uniqueId('data_source'));

    _defineProperty(this, "searchStrategyId", void 0);

    _defineProperty(this, "parent", void 0);

    _defineProperty(this, "requestStartHandlers", []);

    _defineProperty(this, "inheritOptions", {});

    _defineProperty(this, "history", []);

    _defineProperty(this, "fields", void 0);

    _defineProperty(this, "dependencies", void 0);

    this.fields = fields;
    this.dependencies = dependencies;
  }
  /** ***
   * PUBLIC API
   *****/


  _createClass(SearchSource, [{
    key: "setPreferredSearchStrategyId",
    value: function setPreferredSearchStrategyId(searchStrategyId) {
      this.searchStrategyId = searchStrategyId;
    }
  }, {
    key: "setFields",
    value: function setFields(newFields) {
      this.fields = newFields;
      return this;
    }
  }, {
    key: "setField",
    value: function setField(field, value) {
      if (value == null) {
        delete this.fields[field];
      } else {
        this.fields[field] = value;
      }

      return this;
    }
  }, {
    key: "getId",
    value: function getId() {
      return this.id;
    }
  }, {
    key: "getFields",
    value: function getFields() {
      return _objectSpread({}, this.fields);
    }
    /**
     * Get fields from the fields
     */

  }, {
    key: "getField",
    value: function getField(field) {
      var recurse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

      if (!recurse || this.fields[field] !== void 0) {
        return this.fields[field];
      }

      var parent = this.getParent();
      return parent && parent.getField(field);
    }
    /**
     * Get the field from our own fields, don't traverse up the chain
     */

  }, {
    key: "getOwnField",
    value: function getOwnField(field) {
      return this.getField(field, false);
    }
  }, {
    key: "create",
    value: function create() {
      return new SearchSource({}, this.dependencies);
    }
  }, {
    key: "createCopy",
    value: function createCopy() {
      var newSearchSource = new SearchSource({}, this.dependencies);
      newSearchSource.setFields(_objectSpread({}, this.fields)); // when serializing the internal fields we lose the internal classes used in the index
      // pattern, so we have to set it again to workaround this behavior

      newSearchSource.setField('index', this.getField('index'));
      newSearchSource.setParent(this.getParent());
      return newSearchSource;
    }
  }, {
    key: "createChild",
    value: function createChild() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var childSearchSource = new SearchSource({}, this.dependencies);
      childSearchSource.setParent(this, options);
      return childSearchSource;
    }
    /**
     * Set a searchSource that this source should inherit from
     * @param  {SearchSource} parent - the parent searchSource
     * @param  {SearchSourceOptions} options - the inherit options
     * @return {this} - chainable
     */

  }, {
    key: "setParent",
    value: function setParent(parent) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      this.parent = parent;
      this.inheritOptions = options;
      return this;
    }
    /**
     * Get the parent of this SearchSource
     * @return {undefined|searchSource}
     */

  }, {
    key: "getParent",
    value: function getParent() {
      return this.parent;
    }
    /**
     * Run a search using the search service
     * @return {Observable<SearchResponse<unknown>>}
     */

  }, {
    key: "fetch$",
    value: function fetch$(searchRequest, signal) {
      var _this$dependencies = this.dependencies,
          search = _this$dependencies.search,
          injectedMetadata = _this$dependencies.injectedMetadata,
          uiSettings = _this$dependencies.uiSettings;
      var params = getSearchParamsFromRequest(searchRequest, {
        injectedMetadata: injectedMetadata,
        uiSettings: uiSettings
      });
      return search({
        params: params,
        indexType: searchRequest.indexType
      }, {
        signal: signal
      }).pipe(map(function (_ref) {
        var rawResponse = _ref.rawResponse;
        return handleResponse(searchRequest, rawResponse);
      }));
    }
    /**
     * Run a search using the search service
     * @return {Promise<SearchResponse<unknown>>}
     */

  }, {
    key: "legacyFetch",
    value: function () {
      var _legacyFetch = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(searchRequest, options) {
        var _this$dependencies2, injectedMetadata, legacySearch, uiSettings, esShardTimeout;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$dependencies2 = this.dependencies, injectedMetadata = _this$dependencies2.injectedMetadata, legacySearch = _this$dependencies2.legacySearch, uiSettings = _this$dependencies2.uiSettings;
                esShardTimeout = injectedMetadata.getInjectedVar('esShardTimeout');
                _context.next = 4;
                return fetchSoon(searchRequest, _objectSpread(_objectSpread({}, this.searchStrategyId && {
                  searchStrategyId: this.searchStrategyId
                }), options), {
                  legacySearchService: legacySearch,
                  config: uiSettings,
                  esShardTimeout: esShardTimeout
                });

              case 4:
                return _context.abrupt("return", _context.sent);

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function legacyFetch(_x, _x2) {
        return _legacyFetch.apply(this, arguments);
      }

      return legacyFetch;
    }()
    /**
     * Fetch this source and reject the returned Promise on error
     *
     * @async
     */

  }, {
    key: "fetch",
    value: function () {
      var _fetch = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var options,
            uiSettings,
            searchRequest,
            response,
            _args2 = arguments;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                options = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : {};
                uiSettings = this.dependencies.uiSettings;
                _context2.next = 4;
                return this.requestIsStarting(options);

              case 4:
                _context2.next = 6;
                return this.flatten();

              case 6:
                searchRequest = _context2.sent;
                this.history = [searchRequest];

                if (!uiSettings.get(UI_SETTINGS.COURIER_BATCH_SEARCHES)) {
                  _context2.next = 14;
                  break;
                }

                _context2.next = 11;
                return this.legacyFetch(searchRequest, options);

              case 11:
                response = _context2.sent;
                _context2.next = 15;
                break;

              case 14:
                response = this.fetch$(searchRequest, options.abortSignal).toPromise();

              case 15:
                if (!response.error) {
                  _context2.next = 17;
                  break;
                }

                throw new RequestFailure(null, response);

              case 17:
                return _context2.abrupt("return", response);

              case 18:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function fetch() {
        return _fetch.apply(this, arguments);
      }

      return fetch;
    }()
    /**
     *  Add a handler that will be notified whenever requests start
     *  @param  {Function} handler
     *  @return {undefined}
     */

  }, {
    key: "onRequestStart",
    value: function onRequestStart(handler) {
      this.requestStartHandlers.push(handler);
    }
  }, {
    key: "getSearchRequestBody",
    value: function () {
      var _getSearchRequestBody = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        var searchRequest;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return this.flatten();

              case 2:
                searchRequest = _context3.sent;
                return _context3.abrupt("return", searchRequest.body);

              case 4:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function getSearchRequestBody() {
        return _getSearchRequestBody.apply(this, arguments);
      }

      return getSearchRequestBody;
    }()
    /**
     * Completely destroy the SearchSource.
     * @return {undefined}
     */

  }, {
    key: "destroy",
    value: function destroy() {
      this.requestStartHandlers.length = 0;
    }
    /** ****
     * PRIVATE APIS
     ******/

    /**
     *  Called by requests of this search source when they are started
     *  @param options
     *  @return {Promise<undefined>}
     */

  }, {
    key: "requestIsStarting",
    value: function requestIsStarting() {
      var _this = this;

      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var handlers = _toConsumableArray(this.requestStartHandlers); // If callParentStartHandlers has been set to true, we also call all
      // handlers of parent search sources.


      if (this.inheritOptions.callParentStartHandlers) {
        var _searchSource = this.getParent();

        while (_searchSource) {
          handlers.push.apply(handlers, _toConsumableArray(_searchSource.requestStartHandlers));
          _searchSource = _searchSource.getParent();
        }
      }

      return Promise.all(handlers.map(function (fn) {
        return fn(_this, options);
      }));
    }
    /**
     * Used to merge properties into the data within ._flatten().
     * The data is passed in and modified by the function
     *
     * @param  {object} data - the current merged data
     * @param  {*} val - the value at `key`
     * @param  {*} key - The key of `val`
     * @return {undefined}
     */

  }, {
    key: "mergeProp",
    value: function mergeProp(data, val, key) {
      val = typeof val === 'function' ? val(this) : val;
      if (val == null || !key) return;

      var addToRoot = function addToRoot(rootKey, value) {
        data[rootKey] = value;
      };
      /**
       * Add the key and val to the body of the request
       */


      var addToBody = function addToBody(bodyKey, value) {
        // ignore if we already have a value
        if (data.body[bodyKey] == null) {
          data.body[bodyKey] = value;
        }
      };

      var uiSettings = this.dependencies.uiSettings;

      switch (key) {
        case 'filter':
          return addToRoot('filters', (data.filters || []).concat(val));

        case 'query':
          return addToRoot(key, (data[key] || []).concat(val));

        case 'fields':
          var fields = uniq((data[key] || []).concat(val));
          return addToRoot(key, fields);

        case 'index':
        case 'type':
        case 'highlightAll':
          return key && data[key] == null && addToRoot(key, val);

        case 'searchAfter':
          return addToBody('search_after', val);

        case 'source':
          return addToBody('_source', val);

        case 'sort':
          var sort = normalizeSortRequest(val, this.getField('index'), uiSettings.get(UI_SETTINGS.SORT_OPTIONS));
          return addToBody(key, sort);

        default:
          return addToBody(key, val);
      }
    }
    /**
     * Walk the inheritance chain of a source and return its
     * flat representation (taking into account merging rules)
     * @returns {Promise}
     * @resolved {Object|null} - the flat data of the SearchSource
     */

  }, {
    key: "mergeProps",
    value: function mergeProps() {
      var _this2 = this;

      var root = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this;
      var searchRequest = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
        body: {}
      };
      Object.entries(this.fields).forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            key = _ref3[0],
            value = _ref3[1];

        _this2.mergeProp(searchRequest, value, key);
      });

      if (this.parent) {
        this.parent.mergeProps(root, searchRequest);
      }

      return searchRequest;
    }
  }, {
    key: "getIndexType",
    value: function getIndexType(index) {
      if (this.searchStrategyId) {
        return this.searchStrategyId === 'default' ? undefined : this.searchStrategyId;
      } else {
        return index === null || index === void 0 ? void 0 : index.type;
      }
    }
  }, {
    key: "flatten",
    value: function flatten() {
      var searchRequest = this.mergeProps();
      searchRequest.body = searchRequest.body || {};
      var body = searchRequest.body,
          index = searchRequest.index,
          fields = searchRequest.fields,
          query = searchRequest.query,
          filters = searchRequest.filters,
          highlightAll = searchRequest.highlightAll;
      searchRequest.indexType = this.getIndexType(index);
      var computedFields = index ? index.getComputedFields() : {};
      body.stored_fields = computedFields.storedFields;
      body.script_fields = body.script_fields || {};
      extend(body.script_fields, computedFields.scriptFields);
      var defaultDocValueFields = computedFields.docvalueFields ? computedFields.docvalueFields : [];
      body.docvalue_fields = body.docvalue_fields || defaultDocValueFields;

      if (!body.hasOwnProperty('_source') && index) {
        body._source = index.getSourceFiltering();
      }

      var uiSettings = this.dependencies.uiSettings;

      if (body._source) {
        // exclude source fields for this index pattern specified by the user
        var filter = fieldWildcardFilter(body._source.excludes, uiSettings.get(UI_SETTINGS.META_FIELDS));
        body.docvalue_fields = body.docvalue_fields.filter(function (docvalueField) {
          return filter(docvalueField.field);
        });
      } // if we only want to search for certain fields


      if (fields) {
        // filter out the docvalue_fields, and script_fields to only include those that we are concerned with
        body.docvalue_fields = filterDocvalueFields(body.docvalue_fields, fields);
        body.script_fields = pick(body.script_fields, fields); // request the remaining fields from both stored_fields and _source

        var remainingFields = difference(fields, keys(body.script_fields));
        body.stored_fields = remainingFields;
        setWith(body, '_source.includes', remainingFields, function (nsValue) {
          return isObject(nsValue) ? {} : nsValue;
        });
      }

      var esQueryConfigs = getEsQueryConfig(uiSettings);
      body.query = buildEsQuery(index, query, filters, esQueryConfigs);

      if (highlightAll && body.query) {
        body.highlight = getHighlightRequest(body.query, uiSettings.get(UI_SETTINGS.DOC_HIGHLIGHT));
        delete searchRequest.highlightAll;
      }

      return searchRequest;
    }
  }, {
    key: "getSerializedFields",
    value: function getSerializedFields() {
      var _omit = omit(this.getFields(), ['sort', 'size']),
          originalFilters = _omit.filter,
          searchSourceFields = _objectWithoutProperties(_omit, ["filter"]);

      var serializedSearchSourceFields = _objectSpread(_objectSpread({}, searchSourceFields), {}, {
        index: searchSourceFields.index ? searchSourceFields.index.id : undefined
      });

      if (originalFilters) {
        var filters = this.getFilters(originalFilters);
        serializedSearchSourceFields = _objectSpread(_objectSpread({}, serializedSearchSourceFields), {}, {
          filter: filters
        });
      }

      return serializedSearchSourceFields;
    }
    /**
     * Serializes the instance to a JSON string and a set of referenced objects.
     * Use this method to get a representation of the search source which can be stored in a saved object.
     *
     * The references returned by this function can be mixed with other references in the same object,
     * however make sure there are no name-collisions. The references will be named `kibanaSavedObjectMeta.searchSourceJSON.index`
     * and `kibanaSavedObjectMeta.searchSourceJSON.filter[<number>].meta.index`.
     *
     * Using `createSearchSource`, the instance can be re-created.
     * @public */

  }, {
    key: "serialize",
    value: function serialize() {
      var _extractReferences = extractReferences(this.getSerializedFields()),
          _extractReferences2 = _slicedToArray(_extractReferences, 2),
          searchSourceFields = _extractReferences2[0],
          references = _extractReferences2[1];

      return {
        searchSourceJSON: JSON.stringify(searchSourceFields),
        references: references
      };
    }
  }, {
    key: "getFilters",
    value: function getFilters(filterField) {
      if (!filterField) {
        return [];
      }

      if (Array.isArray(filterField)) {
        return filterField;
      }

      if (isFunction(filterField)) {
        return this.getFilters(filterField());
      }

      return [filterField];
    }
  }]);

  return SearchSource;
}();
/** @public **/