import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import PropTypes from 'prop-types';
import { constants } from 'focus-lock';
import { inlineProp } from './util';

var FreeFocusInside = function FreeFocusInside(_ref) {
  var children = _ref.children,
      className = _ref.className;
  return React.createElement("div", _extends({}, inlineProp(constants.FOCUS_ALLOW, true), {
    className: className
  }), children);
};

FreeFocusInside.propTypes = process.env.NODE_ENV !== "production" ? {
  children: PropTypes.node.isRequired,
  className: PropTypes.string
} : {};
FreeFocusInside.defaultProps = {
  disabled: false,
  className: undefined
};
export default FreeFocusInside;