function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent, Fragment } from 'react';
import { intersection, union, get } from 'lodash';
import { EuiBasicTable, EuiButton, EuiButtonEmpty, EuiCallOut, EuiCode, EuiCodeEditor, EuiConfirmModal, EuiFieldNumber, EuiFieldText, EuiFlexGroup, EuiFlexItem, EuiForm, EuiFormRow, EuiIcon, EuiLink, EuiOverlayMask, EuiSelect, EuiSpacer, EuiText, EUI_MODAL_CONFIRM_BUTTON } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { getEnabledScriptingLanguages, getDeprecatedScriptingLanguages, getSupportedScriptingLanguages } from '../../scripting_languages';
import { context as contextType } from '../../../../kibana_react/public';
import { ScriptingDisabledCallOut, ScriptingWarningCallOut } from './components/scripting_call_outs';
import { ScriptingHelpFlyout } from './components/scripting_help';
import { FieldFormatEditor } from './components/field_format_editor';
import { FIELD_TYPES_BY_LANG, DEFAULT_FIELD_TYPES } from './constants';
import { executeScript, isScriptValid } from './lib'; // This loads Ace editor's "groovy" mode, used below to highlight the script.

import 'brace/mode/groovy';

var getFieldTypeFormatsList = function getFieldTypeFormatsList(field, defaultFieldFormat, fieldFormats) {
  var formatsByType = fieldFormats.getByFieldType(field.type).map(function (_ref) {
    var id = _ref.id,
        title = _ref.title;
    return {
      id: id,
      title: title
    };
  });
  return [{
    id: '',
    defaultFieldFormat: defaultFieldFormat,
    title: i18n.translate('indexPatternManagement.defaultFormatDropDown', {
      defaultMessage: '- Default -'
    })
  }].concat(_toConsumableArray(formatsByType));
};

export var FieldEditor = /*#__PURE__*/function (_PureComponent) {
  _inherits(FieldEditor, _PureComponent);

  var _super = _createSuper(FieldEditor);

  function FieldEditor(props, context) {
    var _this;

    _classCallCheck(this, FieldEditor);

    _this = _super.call(this, props, context);

    _defineProperty(_assertThisInitialized(_this), "context", void 0);

    _defineProperty(_assertThisInitialized(_this), "supportedLangs", []);

    _defineProperty(_assertThisInitialized(_this), "deprecatedLangs", []);

    _defineProperty(_assertThisInitialized(_this), "onFieldChange", function (fieldName, value) {
      var field = _this.state.field;
      field[fieldName] = value;

      _this.forceUpdate();
    });

    _defineProperty(_assertThisInitialized(_this), "onTypeChange", function (type) {
      var _this$context$service = _this.context.services,
          uiSettings = _this$context$service.uiSettings,
          data = _this$context$service.data;
      var field = _this.state.field;
      var DefaultFieldFormat = data.fieldFormats.getDefaultType(type);
      field.type = type;
      field.format = new DefaultFieldFormat(null, function (key) {
        return uiSettings.get(key);
      });

      _this.setState({
        fieldTypeFormats: getFieldTypeFormatsList(field, DefaultFieldFormat, data.fieldFormats),
        fieldFormatId: DefaultFieldFormat.id,
        fieldFormatParams: field.format.params()
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onLangChange", function (lang) {
      var field = _this.state.field;
      var fieldTypes = get(FIELD_TYPES_BY_LANG, lang, DEFAULT_FIELD_TYPES);
      field.lang = lang;
      field.type = fieldTypes.includes(field.type) ? field.type : fieldTypes[0];

      _this.setState({
        fieldTypes: fieldTypes
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onFormatChange", function (formatId, params) {
      var _this$state = _this.state,
          field = _this$state.field,
          fieldTypeFormats = _this$state.fieldTypeFormats;
      var _this$context$service2 = _this.context.services,
          uiSettings = _this$context$service2.uiSettings,
          data = _this$context$service2.data;
      var FieldFormat = data.fieldFormats.getType(formatId || fieldTypeFormats[0].defaultFieldFormat.id);
      field.format = new FieldFormat(params, function (key) {
        return uiSettings.get(key);
      });

      _this.setState({
        fieldFormatId: FieldFormat.id,
        fieldFormatParams: field.format.params()
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onFormatParamsChange", function (newParams) {
      var fieldFormatId = _this.state.fieldFormatId;

      _this.onFormatChange(fieldFormatId, newParams);
    });

    _defineProperty(_assertThisInitialized(_this), "onFormatParamsError", function (error) {
      _this.setState({
        hasFormatError: !!error
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onScriptChange", function (value) {
      _this.setState({
        hasScriptError: false
      });

      _this.onFieldChange('script', value);
    });

    _defineProperty(_assertThisInitialized(_this), "showScriptingHelp", function () {
      _this.setState({
        showScriptingHelp: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hideScriptingHelp", function () {
      _this.setState({
        showScriptingHelp: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderDeleteModal", function () {
      var field = _this.state.field;
      return _this.state.showDeleteModal ? /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiConfirmModal, {
        title: i18n.translate('indexPatternManagement.deleteFieldHeader', {
          defaultMessage: "Delete field '{fieldName}'",
          values: {
            fieldName: field.name
          }
        }),
        onCancel: _this.hideDeleteModal,
        onConfirm: function onConfirm() {
          _this.hideDeleteModal();

          _this.deleteField();
        },
        cancelButtonText: i18n.translate('indexPatternManagement.deleteField.cancelButton', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: i18n.translate('indexPatternManagement.deleteField.deleteButton', {
          defaultMessage: 'Delete'
        }),
        buttonColor: "danger",
        defaultFocusedButton: EUI_MODAL_CONFIRM_BUTTON
      }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.deleteFieldLabel",
        defaultMessage: "You can't recover a deleted field.{separator}Are you sure you want to do this?",
        values: {
          separator: /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null))
        }
      })))) : null;
    });

    _defineProperty(_assertThisInitialized(_this), "showDeleteModal", function () {
      _this.setState({
        showDeleteModal: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hideDeleteModal", function () {
      _this.setState({
        showDeleteModal: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderScriptingPanels", function () {
      var _this$state2 = _this.state,
          scriptingLangs = _this$state2.scriptingLangs,
          field = _this$state2.field,
          showScriptingHelp = _this$state2.showScriptingHelp;

      if (!field.scripted) {
        return;
      }

      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(ScriptingDisabledCallOut, {
        isVisible: !scriptingLangs.length
      }), /*#__PURE__*/React.createElement(ScriptingWarningCallOut, {
        isVisible: true
      }), /*#__PURE__*/React.createElement(ScriptingHelpFlyout, {
        isVisible: showScriptingHelp,
        onClose: _this.hideScriptingHelp,
        indexPattern: _this.props.indexPattern,
        lang: field.lang,
        name: field.name,
        script: field.script,
        executeScript: executeScript
      }));
    });

    _defineProperty(_assertThisInitialized(_this), "deleteField", function () {
      var redirectAway = _this.props.services.redirectAway;
      var indexPattern = _this.props.indexPattern;
      var field = _this.state.field;
      var remove = indexPattern.removeScriptedField(field);

      if (remove) {
        remove.then(function () {
          var message = i18n.translate('indexPatternManagement.deleteField.deletedHeader', {
            defaultMessage: "Deleted '{fieldName}'",
            values: {
              fieldName: field.name
            }
          });

          _this.context.services.notifications.toasts.addSuccess(message);

          redirectAway();
        });
      } else {
        redirectAway();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "saveField", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var field, indexPattern, fieldFormatId, isValid, redirectAway, index, oldField;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              field = _this.state.field;
              indexPattern = _this.props.indexPattern;
              fieldFormatId = _this.state.fieldFormatId;

              if (!field.scripted) {
                _context.next = 11;
                break;
              }

              _this.setState({
                isSaving: true
              });

              _context.next = 7;
              return isScriptValid({
                name: field.name,
                lang: field.lang,
                script: field.script,
                indexPatternTitle: indexPattern.title,
                http: _this.context.services.http
              });

            case 7:
              isValid = _context.sent;

              if (isValid) {
                _context.next = 11;
                break;
              }

              _this.setState({
                hasScriptError: true,
                isSaving: false
              });

              return _context.abrupt("return");

            case 11:
              redirectAway = _this.props.services.redirectAway;
              index = indexPattern.fields.findIndex(function (f) {
                return f.name === field.name;
              });

              if (index > -1) {
                oldField = indexPattern.fields.getByName(field.name);
                indexPattern.fields.update(field);
              } else {
                indexPattern.fields.add(field);
              }

              if (!fieldFormatId) {
                indexPattern.fieldFormatMap[field.name] = undefined;
              } else {
                indexPattern.fieldFormatMap[field.name] = field.format;
              }

              return _context.abrupt("return", indexPattern.save().then(function () {
                var message = i18n.translate('indexPatternManagement.deleteField.savedHeader', {
                  defaultMessage: "Saved '{fieldName}'",
                  values: {
                    fieldName: field.name
                  }
                });

                _this.context.services.notifications.toasts.addSuccess(message);

                redirectAway();
              }).catch(function (error) {
                if (oldField) {
                  indexPattern.fields.update(oldField);
                } else {
                  indexPattern.fields.remove(field);
                }
              }));

            case 16:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    var _field = props.field,
        _indexPattern = props.indexPattern;
    _this.state = {
      isReady: false,
      isCreating: false,
      isDeprecatedLang: false,
      scriptingLangs: [],
      fieldTypes: [],
      fieldTypeFormats: [],
      existingFieldNames: _indexPattern.fields.map(function (f) {
        return f.name;
      }),
      field: _objectSpread(_objectSpread({}, _field), {}, {
        format: _field.format
      }),
      fieldFormatId: undefined,
      fieldFormatParams: {},
      showScriptingHelp: false,
      showDeleteModal: false,
      hasFormatError: false,
      hasScriptError: false,
      isSaving: false
    };
    _this.supportedLangs = getSupportedScriptingLanguages();
    _this.deprecatedLangs = getDeprecatedScriptingLanguages();

    _this.init(context);

    return _this;
  }

  _createClass(FieldEditor, [{
    key: "init",
    value: function () {
      var _init = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(context) {
        var _context$services, http, notifications, data, field, indexPattern, enabledLangs, scriptingLangs, fieldTypes, DefaultFieldFormat;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context$services = context.services, http = _context$services.http, notifications = _context$services.notifications, data = _context$services.data;
                field = this.state.field;
                indexPattern = this.props.indexPattern;
                _context2.next = 5;
                return getEnabledScriptingLanguages(http, notifications.toasts);

              case 5:
                enabledLangs = _context2.sent;
                scriptingLangs = intersection(enabledLangs, union(this.supportedLangs, this.deprecatedLangs));
                field.lang = field.lang && scriptingLangs.includes(field.lang) ? field.lang : undefined;
                fieldTypes = get(FIELD_TYPES_BY_LANG, field.lang || '', DEFAULT_FIELD_TYPES);
                field.type = fieldTypes.includes(field.type) ? field.type : fieldTypes[0];
                DefaultFieldFormat = data.fieldFormats.getDefaultType(field.type, field.esTypes);
                this.setState({
                  isReady: true,
                  isCreating: !indexPattern.fields.find(function (f) {
                    return f.name === field.name;
                  }),
                  isDeprecatedLang: this.deprecatedLangs.includes(field.lang || ''),
                  errors: [],
                  scriptingLangs: scriptingLangs,
                  fieldTypes: fieldTypes,
                  fieldTypeFormats: getFieldTypeFormatsList(field, DefaultFieldFormat, data.fieldFormats),
                  fieldFormatId: get(indexPattern, ['fieldFormatMap', field.name, 'type', 'id']),
                  fieldFormatParams: field.format.params()
                });

              case 12:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function init(_x) {
        return _init.apply(this, arguments);
      }

      return init;
    }()
  }, {
    key: "isDuplicateName",
    value: function isDuplicateName() {
      var _this$state3 = this.state,
          isCreating = _this$state3.isCreating,
          field = _this$state3.field,
          existingFieldNames = _this$state3.existingFieldNames;
      return isCreating && existingFieldNames.includes(field.name);
    }
  }, {
    key: "renderName",
    value: function renderName() {
      var _this2 = this;

      var _this$state4 = this.state,
          isCreating = _this$state4.isCreating,
          field = _this$state4.field;
      var isInvalid = !field.name || !field.name.trim();
      return isCreating ? /*#__PURE__*/React.createElement(EuiFormRow, {
        label: i18n.translate('indexPatternManagement.nameLabel', {
          defaultMessage: 'Name'
        }),
        helpText: this.isDuplicateName() ? /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement(EuiIcon, {
          type: "alert",
          color: "warning",
          size: "s"
        }), "\xA0", /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.mappingConflictLabel.mappingConflictDetail",
          defaultMessage: "{mappingConflict} You already have a field with the name {fieldName}. Naming your scripted field with the same name means you won't be able to query both fields at the same time.",
          values: {
            mappingConflict: /*#__PURE__*/React.createElement("strong", null, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "indexPatternManagement.mappingConflictLabel.mappingConflictLabel",
              defaultMessage: "Mapping Conflict:"
            })),
            fieldName: /*#__PURE__*/React.createElement(EuiCode, null, field.name)
          }
        })) : null,
        isInvalid: isInvalid,
        error: isInvalid ? i18n.translate('indexPatternManagement.nameErrorMessage', {
          defaultMessage: 'Name is required'
        }) : null
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        value: field.name || '',
        placeholder: i18n.translate('indexPatternManagement.namePlaceholder', {
          defaultMessage: 'New scripted field'
        }),
        "data-test-subj": "editorFieldName",
        onChange: function onChange(e) {
          _this2.onFieldChange('name', e.target.value);
        },
        isInvalid: isInvalid
      })) : null;
    }
  }, {
    key: "renderLanguage",
    value: function renderLanguage() {
      var _this3 = this;

      var _this$state5 = this.state,
          field = _this$state5.field,
          scriptingLangs = _this$state5.scriptingLangs,
          isDeprecatedLang = _this$state5.isDeprecatedLang;
      return field.scripted ? /*#__PURE__*/React.createElement(EuiFormRow, {
        label: i18n.translate('indexPatternManagement.languageLabel', {
          defaultMessage: 'Language'
        }),
        helpText: isDeprecatedLang ? /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement(EuiIcon, {
          type: "alert",
          color: "warning",
          size: "s"
        }), "\xA0", /*#__PURE__*/React.createElement("strong", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.warningHeader",
          defaultMessage: "Deprecation Warning:"
        })), "\xA0", /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.warningLabel.warningDetail",
          defaultMessage: "{language} is deprecated and support will be removed in the next major version of Kibana and Elasticsearch. We recommend using {painlessLink} for new scripted fields.",
          values: {
            language: /*#__PURE__*/React.createElement(EuiCode, null, field.lang),
            painlessLink: /*#__PURE__*/React.createElement(EuiLink, {
              target: "_blank",
              href: this.context.services.docLinks.links.scriptedFields.painless
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "indexPatternManagement.warningLabel.painlessLinkLabel",
              defaultMessage: "Painless"
            }))
          }
        })) : null
      }, /*#__PURE__*/React.createElement(EuiSelect, {
        value: field.lang,
        options: scriptingLangs.map(function (lang) {
          return {
            value: lang,
            text: lang
          };
        }),
        "data-test-subj": "editorFieldLang",
        onChange: function onChange(e) {
          _this3.onLangChange(e.target.value);
        }
      })) : null;
    }
  }, {
    key: "renderType",
    value: function renderType() {
      var _this4 = this;

      var _this$state6 = this.state,
          field = _this$state6.field,
          fieldTypes = _this$state6.fieldTypes;
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        label: i18n.translate('indexPatternManagement.typeLabel', {
          defaultMessage: 'Type'
        })
      }, /*#__PURE__*/React.createElement(EuiSelect, {
        value: field.type,
        disabled: !field.scripted,
        options: fieldTypes.map(function (type) {
          return {
            value: type,
            text: type
          };
        }),
        "data-test-subj": "editorFieldType",
        onChange: function onChange(e) {
          _this4.onTypeChange(e.target.value);
        }
      }));
    }
    /**
     * renders a warning and a table of conflicting indices
     * in case there are indices with different types
     */

  }, {
    key: "renderTypeConflict",
    value: function renderTypeConflict() {
      var field = this.state.field;

      if (!field.conflictDescriptions || _typeof(field.conflictDescriptions) !== 'object') {
        return null;
      }

      var columns = [{
        field: 'type',
        name: i18n.translate('indexPatternManagement.typeLabel', {
          defaultMessage: 'Type'
        }),
        width: '100px'
      }, {
        field: 'indices',
        name: i18n.translate('indexPatternManagement.indexNameLabel', {
          defaultMessage: 'Index names'
        })
      }];
      var items = Object.entries(field.conflictDescriptions).map(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
            type = _ref4[0],
            indices = _ref4[1];

        return {
          type: type,
          indices: Array.isArray(indices) ? indices.join(', ') : 'Index names unavailable'
        };
      });
      return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiCallOut, {
        color: "warning",
        iconType: "alert",
        title: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.fieldTypeConflict",
          defaultMessage: "Field type conflict"
        }),
        size: "s"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.multiTypeLabelDesc",
        defaultMessage: "The type of this field changes across indices. It is unavailable for many analysis functions. The indices per type are as follows:"
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiBasicTable, {
        items: items,
        columns: columns
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }));
    }
  }, {
    key: "renderFormat",
    value: function renderFormat() {
      var _this5 = this;

      var _this$state7 = this.state,
          field = _this$state7.field,
          fieldTypeFormats = _this$state7.fieldTypeFormats,
          fieldFormatId = _this$state7.fieldFormatId,
          fieldFormatParams = _this$state7.fieldFormatParams;
      var indexPatternManagementStart = this.context.services.indexPatternManagementStart;
      var defaultFormat = fieldTypeFormats[0].defaultFieldFormat.title;
      var label = defaultFormat ? /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.defaultFormatHeader",
        defaultMessage: "Format (Default: {defaultFormat})",
        values: {
          defaultFormat: /*#__PURE__*/React.createElement(EuiCode, null, defaultFormat)
        }
      }) : /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.formatHeader",
        defaultMessage: "Format"
      });
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        label: label,
        helpText: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.formatLabel",
          defaultMessage: "Formatting allows you to control the way that specific values are displayed. It can also cause values to be completely changed and prevent highlighting in Discover from working."
        })
      }, /*#__PURE__*/React.createElement(EuiSelect, {
        value: fieldFormatId,
        options: fieldTypeFormats.map(function (format) {
          return {
            value: format.id || '',
            text: format.title
          };
        }),
        "data-test-subj": "editorSelectedFormatId",
        onChange: function onChange(e) {
          _this5.onFormatChange(e.target.value);
        }
      })), fieldFormatId ? /*#__PURE__*/React.createElement(FieldFormatEditor, {
        fieldType: field.type,
        fieldFormat: field.format,
        fieldFormatId: fieldFormatId,
        fieldFormatParams: fieldFormatParams,
        fieldFormatEditors: indexPatternManagementStart.fieldFormatEditors,
        onChange: this.onFormatParamsChange,
        onError: this.onFormatParamsError
      }) : null);
    }
  }, {
    key: "renderPopularity",
    value: function renderPopularity() {
      var _this6 = this;

      var field = this.state.field;
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        label: i18n.translate('indexPatternManagement.popularityLabel', {
          defaultMessage: 'Popularity',
          description: '"Popularity" refers to Kibana\'s measurement how popular a field is (i.e. how commonly it is used).'
        })
      }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
        value: field.count,
        "data-test-subj": "editorFieldCount",
        onChange: function onChange(e) {
          _this6.onFieldChange('count', e.target.value ? Number(e.target.value) : '');
        }
      }));
    }
  }, {
    key: "renderScript",
    value: function renderScript() {
      var _this$state8 = this.state,
          field = _this$state8.field,
          hasScriptError = _this$state8.hasScriptError;
      var isInvalid = !field.script || !field.script.trim() || hasScriptError;
      var errorMsg = hasScriptError ? /*#__PURE__*/React.createElement("span", {
        "data-test-subj": "invalidScriptError"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.scriptInvalidErrorMessage",
        defaultMessage: "Script is invalid. View script preview for details"
      })) : /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.scriptRequiredErrorMessage",
        defaultMessage: "Script is required"
      });
      return field.scripted ? /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        fullWidth: true,
        label: i18n.translate('indexPatternManagement.scriptLabel', {
          defaultMessage: 'Script'
        }),
        isInvalid: isInvalid,
        error: isInvalid ? errorMsg : null
      }, /*#__PURE__*/React.createElement(EuiCodeEditor, {
        value: field.script,
        "data-test-subj": "editorFieldScript",
        onChange: this.onScriptChange,
        mode: "groovy",
        width: "100%",
        height: "300px"
      })), /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.script.accessWithLabel",
        defaultMessage: "Access fields with {code}.",
        values: {
          code: /*#__PURE__*/React.createElement("code", null, "doc['some_field'].value")
        }
      })), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(EuiLink, {
        onClick: this.showScriptingHelp,
        "data-test-subj": "scriptedFieldsHelpLink"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.script.getHelpLabel",
        defaultMessage: "Get help with the syntax and preview the results of your script."
      }))))) : null;
    }
  }, {
    key: "renderActions",
    value: function renderActions() {
      var _this$state9 = this.state,
          isCreating = _this$state9.isCreating,
          field = _this$state9.field,
          isSaving = _this$state9.isSaving;
      var redirectAway = this.props.services.redirectAway;
      return /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiFlexGroup, null, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButton, {
        fill: true,
        onClick: this.saveField,
        isDisabled: this.isSavingDisabled(),
        isLoading: isSaving,
        "data-test-subj": "fieldSaveButton"
      }, isCreating ? /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.actions.createButton",
        defaultMessage: "Create field"
      }) : /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.actions.saveButton",
        defaultMessage: "Save field"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        onClick: redirectAway,
        "data-test-subj": "fieldCancelButton"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.actions.cancelButton",
        defaultMessage: "Cancel"
      }))), !isCreating && field.scripted ? /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "flexEnd"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        color: "danger",
        onClick: this.showDeleteModal
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.actions.deleteButton",
        defaultMessage: "Delete"
      }))))) : null));
    }
  }, {
    key: "isSavingDisabled",
    value: function isSavingDisabled() {
      var _this$state10 = this.state,
          field = _this$state10.field,
          hasFormatError = _this$state10.hasFormatError,
          hasScriptError = _this$state10.hasScriptError;

      if (hasFormatError || hasScriptError || !field.name || !field.name.trim() || field.scripted && (!field.script || !field.script.trim())) {
        return true;
      }

      return false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state11 = this.state,
          isReady = _this$state11.isReady,
          isCreating = _this$state11.isCreating,
          field = _this$state11.field;
      return isReady ? /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h3", null, isCreating ? /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.createHeader",
        defaultMessage: "Create scripted field"
      }) : /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.editHeader",
        defaultMessage: "Edit {fieldName}",
        values: {
          fieldName: field.name
        }
      }))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiForm, null, this.renderScriptingPanels(), this.renderName(), this.renderLanguage(), this.renderType(), this.renderTypeConflict(), this.renderFormat(), this.renderPopularity(), this.renderScript(), this.renderActions(), this.renderDeleteModal()), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "l"
      })) : null;
    }
  }]);

  return FieldEditor;
}(PureComponent);

_defineProperty(FieldEditor, "contextType", contextType);