function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiLink, EuiSpacer, EuiText, EuiScreenReaderOnly } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { TextInputOption } from '../../../charts/public';

function WmsInternalOptions(_ref) {
  var wms = _ref.wms,
      setValue = _ref.setValue;
  var wmsLink = /*#__PURE__*/React.createElement(EuiLink, {
    href: "http://www.opengeospatial.org/standards/wms",
    target: "_blank"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "maps_legacy.wmsOptions.wmsLinkText",
    defaultMessage: "OGC standard"
  }));
  var footnoteText = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("span", {
    "aria-hidden": "true"
  }, "*"), /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "maps_legacy.wmsOptions.mapLoadFailDescription",
    defaultMessage: "If this parameter is incorrect, maps will fail to load."
  }));
  var footnote = /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", null, footnoteText));

  var setOptions = function setOptions(paramName, value) {
    return setValue('options', _objectSpread(_objectSpread({}, wms.options), {}, _defineProperty({}, paramName, value)));
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/React.createElement(EuiText, {
    size: "xs"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "maps_legacy.wmsOptions.wmsDescription",
    defaultMessage: "WMS is an {wmsLink} for map image services.",
    values: {
      wmsLink: wmsLink
    }
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    label: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.wmsUrlLabel",
      defaultMessage: "WMS url"
    }), /*#__PURE__*/React.createElement("span", {
      "aria-hidden": "true"
    }, "*")),
    helpText: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.urlOfWMSWebServiceTip",
      defaultMessage: "The URL of the WMS web service."
    }), footnote),
    paramName: "url",
    value: wms.url,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    label: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.wmsLayersLabel",
      defaultMessage: "WMS layers"
    }), /*#__PURE__*/React.createElement("span", {
      "aria-hidden": "true"
    }, "*")),
    helpText: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.listOfLayersToUseTip",
      defaultMessage: "A comma separated list of layers to use."
    }), footnote),
    paramName: "layers",
    value: wms.options.layers,
    setValue: setOptions
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    label: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.wmsVersionLabel",
      defaultMessage: "WMS version"
    }), /*#__PURE__*/React.createElement("span", {
      "aria-hidden": "true"
    }, "*")),
    helpText: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.versionOfWMSserverSupportsTip",
      defaultMessage: "The version of WMS the server supports."
    }), footnote),
    paramName: "version",
    value: wms.options.version,
    setValue: setOptions
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    label: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.wmsFormatLabel",
      defaultMessage: "WMS format"
    }), /*#__PURE__*/React.createElement("span", {
      "aria-hidden": "true"
    }, "*")),
    helpText: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.imageFormatToUseTip",
      defaultMessage: "Usually image/png or image/jpeg. Use png if the server will return transparent layers."
    }), footnote),
    paramName: "format",
    value: wms.options.format,
    setValue: setOptions
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.wmsAttributionLabel",
      defaultMessage: "WMS attribution"
    }),
    helpText: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.attributionStringTip",
      defaultMessage: "Attribution string for the lower right corner."
    }),
    paramName: "attribution",
    value: wms.options.attribution,
    setValue: setOptions
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    label: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.wmsStylesLabel",
      defaultMessage: "WMS styles"
    }), /*#__PURE__*/React.createElement("span", {
      "aria-hidden": "true"
    }, "*")),
    helpText: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "maps_legacy.wmsOptions.wmsServerSupportedStylesListTip",
      defaultMessage: "A comma separated list of WMS server supported styles to use. Blank in most cases."
    }), footnote),
    paramName: "styles",
    value: wms.options.styles,
    setValue: setOptions
  }), /*#__PURE__*/React.createElement(EuiText, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("p", {
    "aria-hidden": "true"
  }, footnoteText)));
}

export { WmsInternalOptions };