function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore
import colorJS from 'color';
import { LIGHT_THEME, DARK_THEME } from '@elastic/charts';

function computeRelativeLuminosity(rgb) {
  return colorJS(rgb).luminosity();
}

function computeContrast(rgb1, rgb2) {
  return colorJS(rgb1).contrast(colorJS(rgb2));
}

function getAAARelativeLum(bgColor, fgColor) {
  var ratio = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 7;
  var relLum1 = computeRelativeLuminosity(bgColor);
  var relLum2 = computeRelativeLuminosity(fgColor);

  if (relLum1 > relLum2) {
    // relLum1 is brighter, relLum2 is darker
    return (relLum1 + 0.05 - ratio * 0.05) / ratio;
  } else {
    // relLum1 is darker, relLum2 is brighter
    return Math.min(ratio * (relLum1 + 0.05) - 0.05, 1);
  }
}

function getGrayFromRelLum(relLum) {
  if (relLum <= 0.0031308) {
    return relLum * 12.92;
  } else {
    return (1.0 + 0.055) * Math.pow(relLum, 1.0 / 2.4) - 0.055;
  }
}

function getGrayRGBfromGray(gray) {
  var g = Math.round(gray * 255);
  return "rgb(".concat(g, ",").concat(g, ",").concat(g, ")");
}

function getAAAGray(bgColor, fgColor) {
  var ratio = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 7;
  var relLum = getAAARelativeLum(bgColor, fgColor, ratio);
  var gray = getGrayFromRelLum(relLum);
  return getGrayRGBfromGray(gray);
}

function findBestContrastColor(bgColor, lightFgColor, darkFgColor) {
  var ratio = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 4.5;
  var lc = computeContrast(bgColor, lightFgColor);
  var dc = computeContrast(bgColor, darkFgColor);

  if (lc >= dc) {
    if (lc >= ratio) {
      return lightFgColor;
    }

    return getAAAGray(bgColor, lightFgColor, ratio);
  }

  if (dc >= ratio) {
    return darkFgColor;
  }

  return getAAAGray(bgColor, darkFgColor, ratio);
}

function isValidColor(color) {
  if (typeof color !== 'string') {
    return false;
  }

  if (color.length === 0) {
    return false;
  }

  try {
    colorJS(color);
    return true;
  } catch (_unused) {
    return false;
  }
}
/**
 * compute base chart theme based on the background color
 *
 * @param baseTheme
 * @param bgColor
 */


export function getBaseTheme(baseTheme, bgColor) {
  if (!isValidColor(bgColor)) {
    return baseTheme;
  }

  var bgLuminosity = computeRelativeLuminosity(bgColor);
  var mainTheme = bgLuminosity <= 0.179 ? DARK_THEME : LIGHT_THEME;
  var color = findBestContrastColor(bgColor, LIGHT_THEME.axes.axisTitleStyle.fill, DARK_THEME.axes.axisTitleStyle.fill);
  return _objectSpread(_objectSpread({}, mainTheme), {}, {
    axes: _objectSpread(_objectSpread({}, mainTheme.axes), {}, {
      axisTitleStyle: _objectSpread(_objectSpread({}, mainTheme.axes.axisTitleStyle), {}, {
        fill: color
      }),
      tickLabelStyle: _objectSpread(_objectSpread({}, mainTheme.axes.tickLabelStyle), {}, {
        fill: color
      }),
      axisLineStyle: _objectSpread(_objectSpread({}, mainTheme.axes.axisLineStyle), {}, {
        stroke: color
      }),
      tickLineStyle: _objectSpread(_objectSpread({}, mainTheme.axes.tickLineStyle), {}, {
        stroke: color
      })
    })
  });
}
export function getChartClasses(bgColor) {
  // keep the original theme color if no bg color is specified
  if (typeof bgColor !== 'string') {
    return;
  }

  var bgLuminosity = computeRelativeLuminosity(bgColor);
  return bgLuminosity <= 0.179 ? 'tvbVisTimeSeriesDark' : 'tvbVisTimeSeriesLight';
}