/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository;

import java.io.Serializable;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.LibRepositoryBoot;
import org.pentaho.reporting.libraries.repository.MimeRegistry;

public class DefaultMimeRegistry
implements MimeRegistry,
Serializable {
    private static final long serialVersionUID = 2815922456302361614L;
    private static final String SUFFIX_KEY_PREFIX = "org.pentaho.report.libraries.repository.mime-registry.suffix";
    private static final String SUFFIX_KEY_PREFIX_WDOT = "org.pentaho.report.libraries.repository.mime-registry.suffix.";
    private static final Configuration configuration = LibRepositoryBoot.getInstance().getGlobalConfig();
    private static final String defaultMimeType = configuration.getConfigProperty("org.pentaho.report.libraries.repository.mime-registry.default-mimetype", "application/octet-stream");

    @Override
    public String getMimeType(ContentItem item) {
        String name = item.getName();
        if (name == null) {
            return defaultMimeType;
        }
        String extension = IOUtils.getInstance().getFileExtension(name).toLowerCase();
        return configuration.getConfigProperty(SUFFIX_KEY_PREFIX + extension, "application/octet-stream");
    }

    public String getMimeType(String filename) {
        if (filename == null) {
            return defaultMimeType;
        }
        String extension = IOUtils.getInstance().getFileExtension(filename).toLowerCase();
        return configuration.getConfigProperty(SUFFIX_KEY_PREFIX + extension, "application/octet-stream");
    }

    @Override
    public String getSuffix(String mimeType) {
        Iterator propertyKeys = configuration.findPropertyKeys(SUFFIX_KEY_PREFIX_WDOT);
        while (propertyKeys.hasNext()) {
            String key = (String)propertyKeys.next();
            String keyMimeType = configuration.getConfigProperty(key);
            if (!ObjectUtilities.equal((Object)keyMimeType, (Object)mimeType)) continue;
            return key.substring(SUFFIX_KEY_PREFIX_WDOT.length());
        }
        return configuration.getConfigProperty("org.pentaho.report.libraries.repository.mime-registry.default-suffix", "bin");
    }
}

