/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.util.ArrayList;
import java.util.HashMap;
import org.jvyamlb.Position;
import org.jvyamlb.PositioningComposerImpl;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.YAMLTestCase;
import org.jvyamlb.exceptions.ComposerException;
import org.jvyamlb.exceptions.PositionedComposerException;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.PositionedMappingNode;
import org.jvyamlb.nodes.PositionedScalarNode;
import org.jvyamlb.nodes.PositionedSequenceNode;

public class PositioningComposerImplTest
extends YAMLTestCase {
    public PositioningComposerImplTest(String name) {
        super(name);
    }

    protected Node getDocument(String input) {
        PositioningComposerImpl composer = new PositioningComposerImpl(new PositioningParserImpl(new PositioningScannerImpl(input)), (Resolver)new ResolverImpl());
        return composer.getNode();
    }

    public void testThatEmptyComposerGeneratesPositionedEnvelope() {
        Object expected = null;
        Node node = this.getDocument("");
        PositioningComposerImplTest.assertEquals(expected, (Object)node);
    }

    public void testThatSimpleScalarGeneratesCorrectPositioning() throws Exception {
        PositionedScalarNode expected = new PositionedScalarNode("tag:yaml.org,2002:str", this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1)));
        Node node = this.getDocument("a");
        PositioningComposerImplTest.assertEquals((Object)expected, (Object)node);
    }

    public void testThatAKeyValuePairGetsCorrectPositioning() throws Exception {
        HashMap<PositionedScalarNode, PositionedScalarNode> value = new HashMap<PositionedScalarNode, PositionedScalarNode>();
        value.put(new PositionedScalarNode("tag:yaml.org,2002:str", this.s("a"), '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))), new PositionedScalarNode("tag:yaml.org,2002:str", this.s("b"), '\u0000', new Position.Range(new Position(0, 3, 3), new Position(0, 4, 4))));
        PositionedMappingNode expected = new PositionedMappingNode("tag:yaml.org,2002:map", value, false, new Position.Range(new Position(0, 0, 0), new Position(0, 4, 4)));
        Node node = this.getDocument("a: b");
        PositioningComposerImplTest.assertEquals((Object)expected, (Object)node);
    }

    public void testThatASimpleSequenceGetsCorrectPositioning() throws Exception {
        ArrayList<PositionedScalarNode> value = new ArrayList<PositionedScalarNode>();
        value.add(new PositionedScalarNode("tag:yaml.org,2002:str", this.s("a"), '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 3, 3))));
        PositionedSequenceNode expected = new PositionedSequenceNode("tag:yaml.org,2002:seq", value, false, new Position.Range(new Position(0, 0, 0), new Position(0, 3, 3)));
        Node node = this.getDocument("- a");
        PositioningComposerImplTest.assertEquals((Object)expected, (Object)node);
    }

    public void testComposerExceptionIncludesPositioningInformation() throws Exception {
        try {
            this.getDocument(" *foobar");
            PositioningComposerImplTest.assertTrue((String)"composing should throw an exception", (boolean)false);
        }
        catch (ComposerException e) {
            PositioningComposerImplTest.assertTrue((String)"Exception should be instance of PositionedComposerException", (boolean)(e instanceof PositionedComposerException));
            PositioningComposerImplTest.assertEquals((String)"Position should be correct for exception", (Object)new Position.Range(new Position(0, 1, 1), new Position(0, 8, 8)), (Object)((PositionedComposerException)e).getRange());
        }
    }
}

