/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.joda.time.DateTime;
import org.jruby.util.ByteList;
import org.jvyamlb.YAMLTestCase;
import org.jvyamlb.exceptions.ScannerException;

public class SimpleLoadTest
extends YAMLTestCase {
    public SimpleLoadTest(String name) {
        super(name);
    }

    public void testStrings() throws Exception {
        this.assertLoad((Object)this.s("str"), "!!str str");
        this.assertLoad((Object)this.s("str"), "--- str");
        this.assertLoad((Object)this.s("str"), "---\nstr");
        this.assertLoad((Object)this.s("str"), "--- \nstr");
        this.assertLoad((Object)this.s("str"), "--- \n str");
        this.assertLoad((Object)this.s("str"), "str");
        this.assertLoad((Object)this.s("str"), " str");
        this.assertLoad((Object)this.s("str"), "\nstr");
        this.assertLoad((Object)this.s("str"), "\n str");
        this.assertLoad((Object)this.s("str"), "\"str\"");
        this.assertLoad((Object)this.s("str"), "'str'");
        this.assertLoad((Object)this.s("str"), " --- 'str'");
        this.assertLoad((Object)this.s("1.0"), "!!str 1.0");
        this.assertLoad10(this.s("str"), "!str str");
        this.assertLoad10(this.s("1.0"), "!str 1.0");
    }

    public void testArrays() throws Exception {
        ArrayList<ByteList> expected = new ArrayList<ByteList>();
        expected.add(this.s("a"));
        expected.add(this.s("b"));
        expected.add(this.s("c"));
        this.assertLoad(expected, "--- \n- a\n- b\n- c\n");
        this.assertLoad(expected, "--- [a, b, c]");
        this.assertLoad(expected, "[a, b, c]");
    }

    public void testEmpty() throws Exception {
        this.assertLoad(null, "---\n!!str");
        this.assertLoad10(null, "---\n!str");
    }

    public void testStrange() throws Exception {
        this.assertLoad((Object)this.s("---"), "--- ---\n");
        this.assertLoad((Object)this.s("---"), "---");
    }

    public void testShared() throws Exception {
        ByteList inp = this.s("abcde");
        inp.begin = 2;
        inp.realSize = 3;
        this.assertLoad((Object)this.s("cde"), inp);
    }

    public void testDate() throws Exception {
        SimpleLoadTest.assertEquals(ByteList.class, ((Map)this.load("{a: 2007-01-01 01:12:34}")).get(this.s("a")).getClass());
        SimpleLoadTest.assertEquals(ByteList.class, this.load("2007-01-01 01:12:34").getClass());
        SimpleLoadTest.assertEquals(ByteList.class, this.load("2007-01-01 01:12:34.0").getClass());
        SimpleLoadTest.assertEquals(DateTime.class, this.load("2007-01-01 01:12:34 +00:00").getClass());
        SimpleLoadTest.assertEquals(DateTime.class, this.load("2007-01-01 01:12:34.0 +00:00").getClass());
        SimpleLoadTest.assertEquals(ByteList.class, ((Map)this.load("{a: 2007-01-01 01:12:34}")).get(this.s("a")).getClass());
    }

    public void testObjectIdentity() throws Exception {
        List val = (List)this.load("---\n- foo\n- foo\n- [foo]\n- [foo]\n- {foo: foo}\n- {foo: foo}\n");
        SimpleLoadTest.assertNotSame(val.get(0), val.get(1));
        SimpleLoadTest.assertNotSame(val.get(2), val.get(3));
        SimpleLoadTest.assertNotSame(val.get(4), val.get(5));
    }

    public void testStrangeNesting() throws Exception {
        HashMap<ByteList, Cloneable> expected = new HashMap<ByteList, Cloneable>();
        HashMap<ByteList, Object> internal = new HashMap<ByteList, Object>();
        internal.put(this.s("bar"), null);
        expected.put(this.s("foo"), internal);
        this.assertLoad(expected, "---\nfoo: { bar }\n");
        expected = new HashMap();
        ArrayList<ByteList> internal2 = new ArrayList<ByteList>();
        internal2.add(this.s("a"));
        expected.put(this.s("default"), internal2);
        expected = new HashMap();
        internal = new HashMap();
        internal.put(this.s("bar"), null);
        internal.put(this.s("qux"), null);
        expected.put(this.s("foo"), internal);
        this.assertLoad(expected, "---\nfoo: {bar, qux}");
    }

    public void testStrangeCharacters() throws Exception {
        this.assertLoad((Object)this.s(",a"), "--- \n,a");
        HashMap<ByteList, ByteList> expected = new HashMap<ByteList, ByteList>();
        expected.put(this.s("foobar"), this.s(">= 123"));
        this.assertLoad(expected, "foobar: >= 123");
        expected = new HashMap();
        expected.put(this.s("foo"), this.s("bar"));
        this.assertLoad(expected, "---\nfoo: \tbar");
        expected = new HashMap();
        expected.put(this.s("foobar"), this.s("|= 567"));
        this.assertLoad(expected, "foobar: |= 567");
    }

    public void testAtSign() throws Exception {
        HashMap<ByteList, ByteList> expected = new HashMap<ByteList, ByteList>();
        expected.put(this.s("foo"), this.s("@bar"));
        this.assertLoad(expected, "foo: @bar");
    }

    public void testSymbols() throws Exception {
        this.assertLoad((Object)this.s(":a"), "--- \n:a");
        ArrayList<ByteList> expected = new ArrayList<ByteList>();
        expected.add(this.s(":a"));
        this.assertLoad(expected, "--- \n[:a]");
        HashMap<ByteList, Object> expected2 = new HashMap<ByteList, Object>();
        expected2.put(this.s(":year"), this.s(":last"));
        expected2.put(this.s(":month"), this.s(":jan"));
        this.assertLoad(expected2, "--- \n{:year: :last, :month: :jan}");
        expected2 = new HashMap();
        ArrayList<ByteList> l = new ArrayList<ByteList>();
        l.add(this.s(":year"));
        expected2.put(this.s("order"), l);
        this.assertLoad(expected2, "--- \norder: [:year]");
    }

    public void testLoadOfAsterisk() throws Exception {
        this.assertLoad((Object)this.s("*.rb"), "--- \n*.rb");
        this.assertLoad((Object)this.s("*.rb"), "--- \n'*.rb'");
        this.assertLoad((Object)this.s("&.rb"), "--- \n&.rb");
        this.assertLoad((Object)this.s("&.rb"), "--- \n'&.rb'");
        try {
            this.assertLoad(null, "--- \n*r.b");
            SimpleLoadTest.assertTrue((boolean)false);
        }
        catch (ScannerException e) {
            SimpleLoadTest.assertTrue((boolean)true);
        }
        try {
            this.assertLoad(null, "--- \n&r.b");
            SimpleLoadTest.assertTrue((boolean)false);
        }
        catch (ScannerException e) {
            SimpleLoadTest.assertTrue((boolean)true);
        }
    }

    public void testSimpleFailure() throws Exception {
        try {
            this.assertLoad(null, "--- -\nh");
        }
        catch (AssertionFailedError e) {
            SimpleLoadTest.assertTrue((String)("should fail on faulty YAML: " + (Object)((Object)e)), (boolean)false);
        }
        catch (ScannerException e) {
            SimpleLoadTest.assertTrue((boolean)true);
        }
    }

    public void testEmptyDocument() throws Exception {
        this.assertLoad(null, "---\n");
        this.assertLoad(null, "--- \n");
        this.assertLoad((Object)this.s("---"), "---");
    }

    public void testBase64UnevenBinary() throws Exception {
        this.assertLoad10(this.s("<131>Mar 26 01:42:54 ControlTowerServer[68251\u0000\u0000").bytes(), "--- !binary 'PDEzMT5NYXIgMjYgMDE6NDI6NTQgQ29udHJvbFRvd2VyU2VydmVyWzY4MjUxAAA='\n");
        this.assertLoad10(this.s("<131>Mar 26 01:42:54 ControlTowerServer[68251\u0000\u0000").bytes(), "--- !binary 'PDEzMT5NYXIgMjYgMDE6NDI6NTQgQ29udHJvbFRvd2VyU2VydmVyWzY4MjUx\n  AAA=\n  '\n");
    }
}

