/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.coverage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MavenCoverageProvider
implements CoverageProvider {
    private static final String GROUP_COBERTURA = "org.codehaus.mojo";
    private static final String ARTIFACT_COBERTURA = "cobertura-maven-plugin";
    private static final String GROUP_JOCOCO = "org.jacoco";
    private static final String ARTIFACT_JOCOCO = "jacoco-maven-plugin";
    private static final Logger LOG = Logger.getLogger(MavenCoverageProvider.class.getName());
    private final Project p;
    private Map<String, MavenSummary> summaryCache;
    private FileChangeListener listener;

    public MavenCoverageProvider(Project p) {
        this.p = p;
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    private boolean hasPlugin(String groupId, String artifactId) {
        NbMavenProject prj = (NbMavenProject)this.p.getLookup().lookup(NbMavenProject.class);
        if (prj == null) {
            return false;
        }
        MavenProject mp = prj.getMavenProject();
        if (PluginPropertyUtils.getReportPluginVersion((MavenProject)mp, (String)groupId, (String)artifactId) != null) {
            return true;
        }
        return PluginPropertyUtils.getPluginVersion((MavenProject)mp, (String)groupId, (String)artifactId) != null;
    }

    public boolean isEnabled() {
        return this.hasPlugin(GROUP_COBERTURA, ARTIFACT_COBERTURA) || this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO);
    }

    public boolean isAggregating() {
        throw new UnsupportedOperationException();
    }

    public void setAggregating(boolean aggregating) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getMimeTypes() {
        return Collections.singleton("text/x-java");
    }

    public void setEnabled(boolean enabled) {
    }

    @CheckForNull
    private File report() {
        if (this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO)) {
            String outputDirectory = PluginPropertyUtils.getReportPluginProperty((Project)this.p, (String)GROUP_JOCOCO, (String)ARTIFACT_JOCOCO, (String)"outputDirectory", null);
            if (outputDirectory == null) {
                outputDirectory = PluginPropertyUtils.getPluginProperty((Project)this.p, (String)GROUP_JOCOCO, (String)ARTIFACT_JOCOCO, (String)"outputDirectory", (String)"report", null);
            }
            if (outputDirectory == null) {
                try {
                    outputDirectory = (String)PluginPropertyUtils.createEvaluator((Project)this.p).evaluate("${project.reporting.outputDirectory}/jacoco");
                }
                catch (ExpressionEvaluationException x) {
                    LOG.log(Level.WARNING, null, x);
                    return null;
                }
            }
            File outputFile = FileUtil.normalizeFile((File)new File(outputDirectory));
            return FileUtil.normalizeFile((File)new File(outputDirectory, "jacoco.xml"));
        }
        String outputDirectory = PluginPropertyUtils.getReportPluginProperty((Project)this.p, (String)GROUP_COBERTURA, (String)ARTIFACT_COBERTURA, (String)"outputDirectory", null);
        if (outputDirectory == null) {
            outputDirectory = PluginPropertyUtils.getPluginProperty((Project)this.p, (String)GROUP_COBERTURA, (String)ARTIFACT_COBERTURA, (String)"outputDirectory", null, null);
        }
        if (outputDirectory == null) {
            try {
                outputDirectory = (String)PluginPropertyUtils.createEvaluator((Project)this.p).evaluate("${project.reporting.outputDirectory}/cobertura");
            }
            catch (ExpressionEvaluationException x) {
                LOG.log(Level.WARNING, null, x);
                return null;
            }
        }
        return FileUtil.normalizeFile((File)new File(outputDirectory, "coverage.xml"));
    }

    public synchronized void clear() {
        File r = this.report();
        if (r != null && r.isFile() && r.delete()) {
            this.summaryCache = null;
            CoverageManager.INSTANCE.resultsUpdated(this.p, (CoverageProvider)this);
        }
    }

    @CheckForNull
    private Pair<File, org.w3c.dom.Document> parse() {
        File r = this.report();
        if (r == null) {
            LOG.fine("undefined report location");
            return null;
        }
        CoverageManager.INSTANCE.setEnabled(this.p, true);
        if (this.listener == null) {
            this.listener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    this.fire();
                }

                public void fileDataCreated(FileEvent fe) {
                    this.fire();
                }

                public void fileDeleted(FileEvent fe) {
                    this.fire();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void fire() {
                    MavenCoverageProvider mavenCoverageProvider = MavenCoverageProvider.this;
                    synchronized (mavenCoverageProvider) {
                        MavenCoverageProvider.this.summaryCache = null;
                    }
                    CoverageManager.INSTANCE.resultsUpdated(MavenCoverageProvider.this.p, (CoverageProvider)MavenCoverageProvider.this);
                }
            };
            FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)r);
        }
        if (!r.isFile()) {
            LOG.log(Level.FINE, "missing {0}", r);
            return null;
        }
        if (r.length() == 0L) {
            LOG.log(Level.FINE, "empty {0}", r);
            return null;
        }
        try {
            org.w3c.dom.Document report = XMLUtil.parse((InputSource)new InputSource(r.toURI().toString()), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            LOG.log(Level.FINE, "parsed {0}", r);
            return Pair.of((Object)r, (Object)report);
        }
        catch (Exception x) {
            LOG.log(Level.INFO, "Could not parse " + r, x);
            return null;
        }
    }

    private ClassPath srcPath() {
        ProjectSourcesClassPathProvider pscp = (ProjectSourcesClassPathProvider)this.p.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        assert (pscp != null);
        ClassPath cp = pscp.getProjectSourcesClassPath("classpath/source");
        assert (cp != null);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCoverageDetails getDetails(FileObject fo, Document doc) {
        String path = this.srcPath().getResourceName(fo);
        if (path == null) {
            return null;
        }
        MavenDetails det = null;
        MavenCoverageProvider mavenCoverageProvider = this;
        synchronized (mavenCoverageProvider) {
            MavenSummary summ;
            MavenSummary mavenSummary = summ = this.summaryCache != null ? this.summaryCache.get(path) : null;
            if (summ != null) {
                det = summ.getDetails();
                det.lineCount = doc.getDefaultRootElement().getElementCount();
            }
        }
        return det;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileCoverageSummary> getResults() {
        Pair<File, org.w3c.dom.Document> r = this.parse();
        if (r == null) {
            return null;
        }
        ClassPath src = this.srcPath();
        ArrayList<FileCoverageSummary> summs = new ArrayList<FileCoverageSummary>();
        HashMap<String, MavenSummary> summaries = new HashMap<String, MavenSummary>();
        boolean jacoco = this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO);
        NodeList nl = ((org.w3c.dom.Document)r.second()).getElementsByTagName(jacoco ? "sourcefile" : "class");
        for (int i = 0; i < nl.getLength(); ++i) {
            String name;
            ArrayList<Element> lines;
            String filename;
            Element clazz = (Element)nl.item(i);
            if (jacoco) {
                filename = ((Element)clazz.getParentNode()).getAttribute("name") + '/' + clazz.getAttribute("name");
                lines = new ArrayList<Element>();
                for (Element line : XMLUtil.findSubElements((Element)clazz)) {
                    if (!line.getTagName().equals("line")) continue;
                    lines.add(line);
                }
                name = filename.replaceFirst("[.]java$", "").replace('/', '.');
            } else {
                filename = clazz.getAttribute("filename");
                Element linesE = XMLUtil.findElement((Element)clazz, (String)"lines", null);
                lines = linesE != null ? XMLUtil.findSubElements((Element)linesE) : Collections.emptyList();
                name = clazz.getAttribute("name").replace('$', '.');
            }
            FileObject java = src.findResource(filename);
            if (java == null) continue;
            MavenSummary summar = this.summaryOf(java, name, lines, jacoco, ((File)r.first()).lastModified());
            summaries.put(filename, summar);
            summs.add(summar);
        }
        MavenCoverageProvider mavenCoverageProvider = this;
        synchronized (mavenCoverageProvider) {
            this.summaryCache = summaries;
        }
        return summs;
    }

    private MavenSummary summaryOf(FileObject java, String name, List<Element> lines, boolean jacoco, long lastUpdated) {
        int lineCount = 0;
        int executedLineCount = 0;
        HashMap<Integer, Integer> detLines = new HashMap<Integer, Integer>();
        for (Element line : lines) {
            ++lineCount;
            String attr = line.getAttribute(jacoco ? "ci" : "hits");
            String num = line.getAttribute(jacoco ? "nr" : "number");
            detLines.put(Integer.valueOf(num) - 1, Integer.valueOf(attr));
            if (attr.equals("0")) continue;
            ++executedLineCount;
        }
        MavenDetails det = new MavenDetails(java, lastUpdated, lineCount, detLines);
        MavenSummary s = new MavenSummary(java, name, det, executedLineCount);
        return s;
    }

    public String getTestAllAction() {
        return this.hasPlugin(GROUP_JOCOCO, ARTIFACT_JOCOCO) ? "jacoco" : "cobertura";
    }

    private static class MavenDetails
    implements FileCoverageDetails {
        private final FileObject fileObject;
        private final long lastUpdated;
        private FileCoverageSummary summary;
        private final Map<Integer, Integer> lineHitCounts;
        int lineCount;

        public MavenDetails(FileObject fileObject, long lastUpdated, int lineCount, Map<Integer, Integer> lineHitCounts) {
            this.fileObject = fileObject;
            this.lastUpdated = lastUpdated;
            this.lineHitCounts = lineHitCounts;
            this.lineCount = lineCount;
        }

        public FileObject getFile() {
            return this.fileObject;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public boolean hasHitCounts() {
            return true;
        }

        public long lastUpdated() {
            return this.lastUpdated;
        }

        public FileCoverageSummary getSummary() {
            return this.summary;
        }

        public void setSummary(FileCoverageSummary summary) {
            this.summary = summary;
        }

        public CoverageType getType(int lineNo) {
            Integer count = this.lineHitCounts.get(lineNo);
            return count == null ? CoverageType.INFERRED : (count == 0 ? CoverageType.NOT_COVERED : CoverageType.COVERED);
        }

        public int getHitCount(int lineNo) {
            Integer ret = this.lineHitCounts.get(lineNo);
            if (ret == null) {
                return 0;
            }
            return ret;
        }
    }

    private static class MavenSummary
    extends FileCoverageSummary {
        private final MavenDetails details;

        public MavenSummary(FileObject file, String displayName, MavenDetails details, int executedLineCount) {
            super(file, displayName, details.getLineCount(), executedLineCount, 0, 0);
            this.details = details;
            details.setSummary(this);
        }

        MavenDetails getDetails() {
            return this.details;
        }
    }
}

