/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.spi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.payara.common.PayaraInstanceProvider;
import org.netbeans.modules.payara.common.ServerDetails;
import org.netbeans.modules.payara.common.wizards.PayaraWizardProvider;
import org.netbeans.modules.payara.spi.Utils;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class ServerUtilities {
    public static final int ACTION_TIMEOUT = 15000;
    public static final TimeUnit ACTION_TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    public static final String PF_MODULES_DIR_NAME = "modules";
    public static final String PF_LIB_DIR_NAME = "lib";
    public static final String VERSION_MATCHER = "(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String GF_JAR_MATCHER = "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String PROP_FIRST_RUN = "first_run";
    private final PayaraInstanceProvider pip;
    private final PayaraWizardProvider pwp;

    private ServerUtilities(PayaraInstanceProvider pip, PayaraWizardProvider pwp) {
        assert (null != pip);
        this.pip = pip;
        this.pwp = pwp;
    }

    public static ServerUtilities getEe6Utilities() {
        PayaraInstanceProvider pip = PayaraInstanceProvider.getProvider();
        return null == pip ? null : new ServerUtilities(pip, PayaraWizardProvider.createEe6());
    }

    public static ServerUtilities getEe7Utilities() {
        PayaraInstanceProvider pip = PayaraInstanceProvider.getProvider();
        return null == pip ? null : new ServerUtilities(pip, PayaraWizardProvider.createEe7());
    }

    public static ServerUtilities getEe8Utilities() {
        PayaraInstanceProvider pip = PayaraInstanceProvider.getProvider();
        return null == pip ? null : new ServerUtilities(pip, PayaraWizardProvider.createEe8());
    }

    public ServerInstance getServerInstance(String uri) {
        ServerInstance retVal = this.pip.getInstance(uri);
        return retVal;
    }

    public static WizardDescriptor.InstantiatingIterator getInstantiatingIterator() {
        return ServerDetails.getInstantiatingIterator();
    }

    public boolean isRegisteredUri(String uri) {
        return this.pip.getInstance(uri) != null || PayaraInstanceProvider.activeRegistrationSet.contains(uri);
    }

    public Lookup getLookupFor(ServerInstance instance) {
        return this.pip.getLookupFor(instance);
    }

    public <T> T getInstanceByCapability(String uri, Class<T> serverFacadeClass) {
        return this.pip.getInstanceByCapability(uri, serverFacadeClass);
    }

    public <T> List<T> getInstancesByCapability(Class<T> serverFacadeClass) {
        return this.pip.getInstancesByCapability(serverFacadeClass);
    }

    public ServerInstanceProvider getServerProvider() {
        return this.pip;
    }

    public static File getJarName(String payaraHome, String jarNamePattern) {
        return ServerUtilities.getJarName(payaraHome, jarNamePattern, PF_MODULES_DIR_NAME);
    }

    public static File getJarName(String payaraHome, String jarNamePattern, String subdirectoryName) {
        File searchDirectory = new File(payaraHome + File.separatorChar + subdirectoryName);
        return Utils.getFileFromPattern(jarNamePattern, searchDirectory);
    }

    public static File getWsJarName(String payaraHome, String jarNamePattern) {
        File modulesDir = new File(payaraHome + File.separatorChar + PF_MODULES_DIR_NAME);
        File retVal = Utils.getFileFromPattern(jarNamePattern, modulesDir);
        if (null == retVal) {
            retVal = Utils.getFileFromPattern(jarNamePattern, new File(modulesDir, "endorsed"));
        }
        return retVal;
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    public static final String quote(String path) {
        return path.indexOf(32) == -1 ? path : "\"" + path + "\"";
    }

    public static boolean isTP2(String gfRoot) {
        return ServerUtilities.getJarName(gfRoot, GF_JAR_MATCHER).getName().indexOf("-tp-2-") > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> filterByManifest(List<String> jarList, FileObject parent, int depth, boolean escape) {
        if (null != parent) {
            int parentLength = parent.getPath().length();
            if (depth == 1) {
                parentLength = parent.getParent().getPath().length();
            }
            for (FileObject candidate : parent.getChildren()) {
                if (candidate.isFolder()) {
                    if (depth >= 1) continue;
                    ServerUtilities.filterByManifest(jarList, candidate, depth + 1, escape);
                    continue;
                }
                if (!candidate.getNameExt().endsWith(".jar")) continue;
                JarFile jarFile = null;
                try {
                    String bundleName;
                    Attributes attrs;
                    jarFile = new JarFile(FileUtil.toFile((FileObject)candidate), false);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null || (attrs = manifest.getMainAttributes()) == null || (bundleName = attrs.getValue("Bundle-SymbolicName")) == null || !bundleName.contains("javax")) continue;
                    String val = candidate.getPath().substring(parentLength);
                    if (escape) {
                        val = val.replace("\\", "\\\\");
                    }
                    jarList.add(val);
                }
                catch (IOException ex) {
                    Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, candidate.getPath(), ex);
                }
                finally {
                    if (null != jarFile) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, candidate.getPath(), ex);
                        }
                        jarFile = null;
                    }
                }
            }
        } else {
            Logger.getLogger(ServerUtilities.class.getName()).log(Level.FINER, "Null FileObject passed in as the parent parameter. Returning the original list");
        }
        return jarList;
    }
}

