/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.common.ServerUtil;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.wizard.DelegatingWizardDescriptorPanel;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.MessageGenerator;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.MultiTargetChooserPanel;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MdbLocationPanel;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MdbPropertiesPanel;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.javaee.specs.support.api.JmsSupport;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class MdbWizard
implements WizardDescriptor.InstantiatingIterator {
    private static final Logger LOG = Logger.getLogger(MdbWizard.class.getName());
    public static final String PROP_DESTINATION_TYPE = "DESTINATION_TYPE";
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private MdbLocationPanel ejbPanel;
    private MdbPropertiesPanel propertiesPanel;
    private WizardDescriptor wiz;
    private static final Map<Profile, String> MAVEN_JAVAEE_API_LIBS = new HashMap<Profile, String>(2);
    private static final String[] MAVEN_JAVAEE_WEB_API_LIBS = new String[]{"javaee-web-api-6.0", "javaee-web-api-7.0"};
    private static final String[] SESSION_STEPS = new String[]{NbBundle.getMessage(MdbWizard.class, (String)"LBL_SpecifyEJBInfo"), NbBundle.getMessage(MdbWizard.class, (String)"LBL_SpecifyActivationProperties")};

    public String name() {
        return NbBundle.getMessage(MdbWizard.class, (String)"LBL_MessageEJBWizardTitle");
    }

    public void uninitialize(WizardDescriptor wiz) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        this.ejbPanel = new MdbLocationPanel(this.wiz);
        ValidatingPanel locationPanel = new ValidatingPanel(new MultiTargetChooserPanel(project, sourceGroups, (WizardDescriptor.Panel)this.ejbPanel, true));
        this.propertiesPanel = new MdbPropertiesPanel(wizardDescriptor);
        this.panels = new WizardDescriptor.Panel[]{locationPanel, this.propertiesPanel};
        Wizards.mergeSteps((WizardDescriptor)this.wiz, (WizardDescriptor.Panel[])this.panels, (String[])SESSION_STEPS);
    }

    public Set instantiate() throws IOException {
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)pkg);
        Profile profile = ejbModule.getJ2eeProfile();
        boolean isSimplified = profile != null && profile.isAtLeast(Profile.JAVA_EE_5);
        MessageGenerator generator = MessageGenerator.create(profile, Templates.getTargetName((WizardDescriptor)this.wiz), pkg, this.ejbPanel.getDestination(), isSimplified, this.propertiesPanel.getProperties(), JmsSupport.getInstance((J2eePlatform)ProjectUtil.getPlatform((Project)Templates.getProject((WizardDescriptor)this.wiz))));
        FileObject result = generator.generate();
        this.updateProjectJavaEESupport();
        return result == null ? Collections.EMPTY_SET : Collections.singleton(result);
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    private boolean isJmsOnClasspath() throws IOException {
        ClassPath classPath = Utils.getCompileClassPath(Templates.getProject((WizardDescriptor)this.wiz));
        return classPath == null || classPath.findResource("javax/jms") != null;
    }

    private Profile getTargetFullProfile() {
        Profile profile = JavaEEProjectSettings.getProfile((Project)Templates.getProject((WizardDescriptor)this.wiz));
        if (profile != null) {
            if (profile.isAtLeast(Profile.JAKARTA_EE_8_WEB)) {
                return Profile.JAKARTA_EE_8_FULL;
            }
            if (profile.isAtLeast(Profile.JAVA_EE_8_WEB)) {
                return Profile.JAVA_EE_8_FULL;
            }
            if (profile.isAtLeast(Profile.JAVA_EE_7_WEB)) {
                return Profile.JAVA_EE_7_FULL;
            }
            if (profile.isAtLeast(Profile.JAVA_EE_6_WEB)) {
                return Profile.JAVA_EE_6_FULL;
            }
            LOG.severe("Unknown JavaEE web profile.");
        } else {
            LOG.severe("Project profile was not recognized correctly.");
        }
        return null;
    }

    private boolean removeWebApiJarsFromClasspath() throws IOException {
        ArrayList<Library> toRemove = new ArrayList<Library>();
        for (String libraryName : MAVEN_JAVAEE_WEB_API_LIBS) {
            Library library = LibraryManager.getDefault().getLibrary(libraryName);
            if (library == null) continue;
            toRemove.add(library);
        }
        return Utils.removeLibraryFromClasspath(Templates.getProject((WizardDescriptor)this.wiz), toRemove.toArray(new Library[toRemove.size()]));
    }

    private void enhanceProjectClasspath(Profile targetProfile) throws IOException {
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        String fullLibraryName = MAVEN_JAVAEE_API_LIBS.get(targetProfile);
        Library targetLibrary = LibraryManager.getDefault().getLibrary(fullLibraryName);
        if (targetLibrary != null) {
            Utils.addLibraryToClasspath(project, targetLibrary);
        }
    }

    private void updateProjectJavaEESupport() {
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        try {
            Profile targetFullProfile;
            AntBasedProjectType abpt = (AntBasedProjectType)project.getLookup().lookup(AntBasedProjectType.class);
            if (abpt == null && !this.isJmsOnClasspath() && (targetFullProfile = this.getTargetFullProfile()) != null && this.removeWebApiJarsFromClasspath()) {
                this.enhanceProjectClasspath(targetFullProfile);
                JavaEEProjectSettings.setProfile((Project)project, (Profile)targetFullProfile);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static {
        MAVEN_JAVAEE_API_LIBS.put(Profile.JAVA_EE_6_FULL, "javaee-api-6.0");
        MAVEN_JAVAEE_API_LIBS.put(Profile.JAVA_EE_7_FULL, "javaee-api-7.0");
        MAVEN_JAVAEE_API_LIBS.put(Profile.JAVA_EE_8_FULL, "javaee-api-8.0");
    }

    private static final class ValidatingPanel
    extends DelegatingWizardDescriptorPanel {
        public ValidatingPanel(WizardDescriptor.Panel delegate) {
            super(delegate);
        }

        public boolean isValid() {
            if (!ServerUtil.isValidServerInstance((Project)this.getProject())) {
                this.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MdbWizard.class, (String)"ERR_MissingServer"));
                return false;
            }
            return super.isValid();
        }
    }
}

