/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.singlesourcefile;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.singlesourcefile.RunProcess;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class SingleJavaSourceRunActionProvider
implements ActionProvider {
    private static final String FILE_ARGUMENTS = "single_file_run_arguments";
    private static final String FILE_VM_OPTIONS = "single_file_vm_options";

    public String[] getSupportedActions() {
        return new String[]{"run.single"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        FileObject fileObject = this.getJavaFileWithoutProjectFromLookup(context);
        if (fileObject == null) {
            return;
        }
        ExecutionDescriptor descriptor = new ExecutionDescriptor().controllable(true).frontWindow(true).preExecution(null).postExecution(null);
        RunProcess process = this.invokeActionHelper(command, fileObject);
        ExecutionService exeService = ExecutionService.newService((Callable)process, (ExecutionDescriptor)descriptor, (String)"Running Single Java File");
        Future exitCode = exeService.run();
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        int version = Integer.parseInt(javaVersion);
        FileObject fileObject = this.getJavaFileWithoutProjectFromLookup(context);
        return version >= 11 && fileObject != null;
    }

    final RunProcess invokeActionHelper(String command, FileObject fileObject) {
        String filePath = fileObject.getPath();
        Object argumentsObject = fileObject.getAttribute(FILE_ARGUMENTS);
        String arguments = argumentsObject != null ? (String)argumentsObject : "";
        Object vmOptionsObject = fileObject.getAttribute(FILE_VM_OPTIONS);
        String vmOptions = vmOptionsObject != null ? (String)vmOptionsObject : "";
        ArrayList<String> commandsList = new ArrayList<String>();
        if (Utilities.isUnix()) {
            commandsList.add("bash");
            commandsList.add("-c");
        }
        File javaPathFile = new File(new File(new File(System.getProperty("java.home")), "bin"), "java");
        String javaPath = "\"" + javaPathFile.getAbsolutePath() + "\"";
        commandsList.add(javaPath + " " + vmOptions + " " + filePath + " " + arguments);
        return new RunProcess(commandsList);
    }

    private FileObject getJavaFileWithoutProjectFromLookup(Lookup lookup) {
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p != null || !fObj.getExt().equalsIgnoreCase("java")) continue;
            return fObj;
        }
        return null;
    }
}

