/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.WebLogicalViewProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;

public final class SetupDirNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        WebProject project = (WebProject)p.getLookup().lookup(WebProject.class);
        assert (project != null);
        return new SetupDirNodeList(project);
    }

    private static class SetupDirNodeList
    extends FileChangeAdapter
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String SETUP_DIR = "setupDir";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        SetupDirNodeList(WebProject proj) {
            this.project = proj;
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this);
            WebLogicalViewProvider logView = (WebLogicalViewProvider)((Object)this.project.getLookup().lookup(WebLogicalViewProvider.class));
            assert (logView != null);
        }

        public List<String> keys() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.project.getProjectDirectory().getFileObject("setup") != null) {
                result.add(SETUP_DIR);
            }
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public Node node(String key) {
            if (SETUP_DIR.equals(key)) {
                return J2eeProjectView.createServerResourcesNode((Project)this.project);
            }
            assert (false) : "No node for key: " + key;
            return null;
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireChange();
        }

        private void fireChange() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SetupDirNodeList.this.changeSupport.fireChange();
                }
            });
        }
    }
}

