/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NumberUtils;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class, receiverType=Integer.class)
final class DefaultIntegerExports {
    DefaultIntegerExports() {
    }

    @ExportMessage
    static boolean isNumber(Integer receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInByte(Integer receiver) {
        int i = receiver;
        byte b = (byte)i;
        return b == i;
    }

    @ExportMessage
    static boolean fitsInShort(Integer receiver) {
        int i = receiver;
        short s = (short)i;
        return s == i;
    }

    @ExportMessage
    static boolean fitsInFloat(Integer receiver) {
        return NumberUtils.inSafeFloatRange(receiver);
    }

    @ExportMessage
    static byte asByte(Integer receiver) throws UnsupportedMessageException {
        int i = receiver;
        byte b = (byte)i;
        if (b == i) {
            return b;
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static short asShort(Integer receiver) throws UnsupportedMessageException {
        int i = receiver;
        short s = (short)i;
        if (s == i) {
            return s;
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static float asFloat(Integer receiver) throws UnsupportedMessageException {
        int i = receiver;
        if (NumberUtils.inSafeFloatRange(i)) {
            return i;
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean fitsInInt(Integer receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInLong(Integer receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInDouble(Integer receiver) {
        return true;
    }

    @ExportMessage
    static int asInt(Integer receiver) {
        return receiver;
    }

    @ExportMessage
    static long asLong(Integer receiver) {
        return receiver.intValue();
    }

    @ExportMessage
    static double asDouble(Integer receiver) {
        return receiver.intValue();
    }
}

