/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.NumberPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NumberPrototypeBuiltins.class)
public final class NumberPrototypeBuiltinsFactory {

    @GeneratedBy(value=NumberPrototypeBuiltins.JSNumberToPrecisionNode.class)
    public static final class JSNumberToPrecisionNodeGen
    extends NumberPrototypeBuiltins.JSNumberToPrecisionNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberToPrecisionNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    if ((state & 1) != 0 && JSGuards.isJSNumber(arguments0Value__) && JSGuards.isUndefined(arguments1Value_)) {
                        return this.toPrecisionUndefined(arguments0Value__, arguments1Value_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSNumber(arguments0Value__) && !JSGuards.isUndefined(arguments1Value_)) {
                        return this.toPrecision(arguments0Value__, arguments1Value_);
                    }
                }
                if ((state & 0x1C) != 0) {
                    if ((state & 4) != 0 && JSGuards.isJavaNumber(arguments0Value_) && JSGuards.isUndefined(arguments1Value_)) {
                        return this.toPrecisionPrimitiveUndefined(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 8) != 0 && JSGuards.isJavaNumber(arguments0Value_) && !JSGuards.isUndefined(arguments1Value_)) {
                        return this.toPrecisionPrimitive(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 0x10) != 0 && !JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isJavaNumber(arguments0Value_)) {
                        return this.toPrecision(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (JSGuards.isJSNumber(arguments0Value_) && JSGuards.isUndefined(arguments1Value)) {
                    this.state_ = state |= 1;
                    return this.toPrecisionUndefined(arguments0Value_, arguments1Value);
                }
                if (JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isUndefined(arguments1Value)) {
                    this.state_ = state |= 2;
                    return this.toPrecision(arguments0Value_, arguments1Value);
                }
            }
            if (JSGuards.isJavaNumber(arguments0Value) && JSGuards.isUndefined(arguments1Value)) {
                this.state_ = state |= 4;
                return this.toPrecisionPrimitiveUndefined(arguments0Value, arguments1Value);
            }
            if (JSGuards.isJavaNumber(arguments0Value) && !JSGuards.isUndefined(arguments1Value)) {
                this.state_ = state |= 8;
                return this.toPrecisionPrimitive(arguments0Value, arguments1Value);
            }
            if (!JSGuards.isJSNumber(arguments0Value) && !JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 0x10;
                return this.toPrecision(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "toPrecisionUndefined";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "toPrecision";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "toPrecisionPrimitiveUndefined";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "toPrecisionPrimitive";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "toPrecision";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberPrototypeBuiltins.JSNumberToPrecisionNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberToPrecisionNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberPrototypeBuiltins.JSNumberToExponentialNode.class)
    public static final class JSNumberToExponentialNodeGen
    extends NumberPrototypeBuiltins.JSNumberToExponentialNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile digitsError;

        private JSNumberToExponentialNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                if ((state & 3) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                    if ((state & 1) != 0 && JSGuards.isJSNumber(arguments0Value__) && JSGuards.isUndefined(arguments1Value_)) {
                        return this.toExponentialUndefined(arguments0Value__, arguments1Value_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSNumber(arguments0Value__) && !JSGuards.isUndefined(arguments1Value_)) {
                        return this.toExponential(arguments0Value__, arguments1Value_, this.digitsError);
                    }
                }
                if ((state & 0x1C) != 0) {
                    if ((state & 4) != 0 && JSGuards.isJavaNumber(arguments0Value_) && JSGuards.isUndefined(arguments1Value_)) {
                        return this.toExponentialPrimitiveUndefined(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 8) != 0 && JSGuards.isJavaNumber(arguments0Value_) && !JSGuards.isUndefined(arguments1Value_)) {
                        return this.toExponentialPrimitive(arguments0Value_, arguments1Value_, this.digitsError);
                    }
                    if ((state & 0x10) != 0 && !JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isJavaNumber(arguments0Value_)) {
                        return this.toExponential(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                String string;
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSGuards.isJSNumber(arguments0Value_) && JSGuards.isUndefined(arguments1Value)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        String string2 = this.toExponentialUndefined(arguments0Value_, arguments1Value);
                        return string2;
                    }
                    if (JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isUndefined(arguments1Value)) {
                        if (this.digitsError == null) {
                            this.digitsError = BranchProfile.create();
                        }
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        String string3 = this.toExponential(arguments0Value_, arguments1Value, this.digitsError);
                        return string3;
                    }
                }
                if (JSGuards.isJavaNumber(arguments0Value) && JSGuards.isUndefined(arguments1Value)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    string = this.toExponentialPrimitiveUndefined(arguments0Value, arguments1Value);
                    return string;
                }
                if (JSGuards.isJavaNumber(arguments0Value) && !JSGuards.isUndefined(arguments1Value)) {
                    if (this.digitsError == null) {
                        this.digitsError = BranchProfile.create();
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    string = this.toExponentialPrimitive(arguments0Value, arguments1Value, this.digitsError);
                    return string;
                }
                if (!JSGuards.isJSNumber(arguments0Value) && !JSGuards.isJavaNumber(arguments0Value)) {
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    string = this.toExponential(arguments0Value, arguments1Value);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<BranchProfile>> cached;
            Object[] data = new Object[6];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "toExponentialUndefined";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "toExponential";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<BranchProfile>>();
                cached.add(Arrays.asList(this.digitsError));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "toExponentialPrimitiveUndefined";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "toExponentialPrimitive";
            if ((state & 8) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.digitsError));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[4] = s;
            s = new Object[3];
            s[0] = "toExponential";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberPrototypeBuiltins.JSNumberToExponentialNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberToExponentialNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberPrototypeBuiltins.JSNumberToFixedNode.class)
    public static final class JSNumberToFixedNodeGen
    extends NumberPrototypeBuiltins.JSNumberToFixedNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberToFixedNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSNumber(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.toFixed(arguments0Value__, arguments1Value_);
                }
                if ((state & 6) != 0) {
                    if ((state & 2) != 0 && JSGuards.isJavaNumber(arguments0Value_)) {
                        return this.toFixedJava(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 4) != 0 && !JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isJavaNumber(arguments0Value_)) {
                        return this.toFixedGeneric(arguments0Value_, arguments1Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSNumber(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.toFixed(arguments0Value_, arguments1Value);
            }
            if (JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 2;
                return this.toFixedJava(arguments0Value, arguments1Value);
            }
            if (!JSGuards.isJSNumber(arguments0Value) && !JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 4;
                return this.toFixedGeneric(arguments0Value, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "toFixed";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "toFixedJava";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "toFixedGeneric";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberPrototypeBuiltins.JSNumberToFixedNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberToFixedNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberPrototypeBuiltins.JSNumberValueOfNode.class)
    public static final class JSNumberValueOfNodeGen
    extends NumberPrototypeBuiltins.JSNumberValueOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberValueOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSNumber(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.valueOf(arguments0Value__);
            }
            if ((state & 6) != 0) {
                if ((state & 2) != 0 && JSGuards.isJavaNumber(arguments0Value_)) {
                    return this.valueOfPrimitive(arguments0Value_);
                }
                if ((state & 4) != 0 && !JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isJavaNumber(arguments0Value_)) {
                    return this.valueOf(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 5) != 0) {
                return JSTypesGen.expectDouble(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 2) != 0 && JSGuards.isJavaNumber(arguments0Value_)) {
                return this.valueOfPrimitive(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 5) == 0 && state != 0) {
                    this.executeDouble(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSNumber(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.valueOf(arguments0Value_);
            }
            if (JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 2;
                return this.valueOfPrimitive(arguments0Value);
            }
            if (!JSGuards.isJSNumber(arguments0Value) && !JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 4;
                return this.valueOf(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "valueOf";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "valueOfPrimitive";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "valueOf";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberPrototypeBuiltins.JSNumberValueOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberValueOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberPrototypeBuiltins.JSNumberToLocaleStringIntlNode.class)
    public static final class JSNumberToLocaleStringIntlNodeGen
    extends NumberPrototypeBuiltins.JSNumberToLocaleStringIntlNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberToLocaleStringIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSNumber(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.jsNumberToLocaleString(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 6) != 0) {
                    if ((state & 2) != 0 && JSGuards.isJavaNumber(arguments0Value_)) {
                        return this.javaNumberToLocaleString(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    if ((state & 4) != 0 && !JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isJavaNumber(arguments0Value_)) {
                        return this.failForNonNumbers(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSNumber(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.jsNumberToLocaleString(arguments0Value_, arguments1Value, arguments2Value);
            }
            if (JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 2;
                return this.javaNumberToLocaleString(arguments0Value, arguments1Value, arguments2Value);
            }
            if (!JSGuards.isJSNumber(arguments0Value) && !JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 4;
                return this.failForNonNumbers(arguments0Value, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "jsNumberToLocaleString";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "javaNumberToLocaleString";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "failForNonNumbers";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberPrototypeBuiltins.JSNumberToLocaleStringIntlNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberToLocaleStringIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberPrototypeBuiltins.JSNumberToLocaleStringNode.class)
    public static final class JSNumberToLocaleStringNodeGen
    extends NumberPrototypeBuiltins.JSNumberToLocaleStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private JSNumberToLocaleStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject arguments0Value__;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSNumber(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.toLocaleString(arguments0Value__);
            }
            if ((state & 6) != 0) {
                if ((state & 2) != 0 && JSGuards.isJavaNumber(arguments0Value_)) {
                    return this.toLocaleStringPrimitive(arguments0Value_);
                }
                if ((state & 4) != 0 && !JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isJavaNumber(arguments0Value_)) {
                    return this.toLocaleString(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value) {
            DynamicObject arguments0Value_;
            int state = this.state_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSNumber(arguments0Value_ = (DynamicObject)arguments0Value)) {
                this.state_ = state |= 1;
                return this.toLocaleString(arguments0Value_);
            }
            if (JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 2;
                return this.toLocaleStringPrimitive(arguments0Value);
            }
            if (!JSGuards.isJSNumber(arguments0Value) && !JSGuards.isJavaNumber(arguments0Value)) {
                this.state_ = state |= 4;
                return this.toLocaleString(arguments0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "toLocaleString";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "toLocaleStringPrimitive";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "toLocaleString";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberPrototypeBuiltins.JSNumberToLocaleStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberToLocaleStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=NumberPrototypeBuiltins.JSNumberToStringNode.class)
    public static final class JSNumberToStringNodeGen
    extends NumberPrototypeBuiltins.JSNumberToStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private JSNumberToStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xDF) == 0 && state != 0) {
                return this.execute_int0(frameValue, state);
            }
            return this.execute_generic1(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state & 0x20) != 0);
            if (arguments0Value_ instanceof Number) {
                Number arguments0Value__ = (Number)arguments0Value_;
                return this.toStringPrimitiveRadixInt(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic1(VirtualFrame frameValue, int state) {
            Object arguments0Value__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0x1F) != 0) {
                if ((state & 7) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                    arguments0Value__ = (DynamicObject)arguments0Value_;
                    if ((state & 1) != 0 && JSGuards.isJSNumber(arguments0Value__) && JSGuards.isJSNumberInteger(arguments0Value__) && this.isRadix10(arguments1Value_)) {
                        return this.toStringIntRadix10((DynamicObject)arguments0Value__, arguments1Value_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSNumber(arguments0Value__) && this.isRadix10(arguments1Value_)) {
                        return this.toStringRadix10((DynamicObject)arguments0Value__, arguments1Value_);
                    }
                    if ((state & 4) != 0 && JSGuards.isJSNumber(arguments0Value__) && !JSGuards.isUndefined(arguments1Value_)) {
                        return this.toString((DynamicObject)arguments0Value__, arguments1Value_);
                    }
                }
                if ((state & 0x18) != 0) {
                    if ((state & 8) != 0 && JSGuards.isJavaNumber(arguments0Value_) && JSGuards.isNumberInteger(arguments0Value_) && this.isRadix10(arguments1Value_)) {
                        return this.toStringPrimitiveIntRadix10(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 0x10) != 0 && JSGuards.isJavaNumber(arguments0Value_) && this.isRadix10(arguments1Value_)) {
                        return this.toStringPrimitiveRadix10(arguments0Value_, arguments1Value_);
                    }
                }
            }
            if ((state & 0x60) != 0 && arguments0Value_ instanceof Number) {
                arguments0Value__ = (Number)arguments0Value_;
                if ((state & 0x20) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    return this.toStringPrimitiveRadixInt((Number)arguments0Value__, arguments1Value__);
                }
                if ((state & 0x40) != 0 && !JSGuards.isUndefined(arguments1Value_)) {
                    return this.toStringPrimitive((Number)arguments0Value__, arguments1Value_);
                }
            }
            if ((state & 0x80) != 0 && !JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isJavaNumber(arguments0Value_)) {
                return this.toStringNoNumber(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                Object arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    arguments0Value_ = (DynamicObject)arguments0Value;
                    if (JSGuards.isJSNumber(arguments0Value_) && JSGuards.isJSNumberInteger(arguments0Value_) && this.isRadix10(arguments1Value)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        String string = this.toStringIntRadix10((DynamicObject)arguments0Value_, arguments1Value);
                        return string;
                    }
                    if (JSGuards.isJSNumber(arguments0Value_) && this.isRadix10(arguments1Value)) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        String string = this.toStringRadix10((DynamicObject)arguments0Value_, arguments1Value);
                        return string;
                    }
                    if (JSGuards.isJSNumber(arguments0Value_) && !JSGuards.isUndefined(arguments1Value)) {
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        String string = this.toString((DynamicObject)arguments0Value_, arguments1Value);
                        return string;
                    }
                }
                if (JSGuards.isJavaNumber(arguments0Value) && JSGuards.isNumberInteger(arguments0Value) && this.isRadix10(arguments1Value)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_ = this.toStringPrimitiveIntRadix10(arguments0Value, arguments1Value);
                    return arguments0Value_;
                }
                if (JSGuards.isJavaNumber(arguments0Value) && this.isRadix10(arguments1Value)) {
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    arguments0Value_ = this.toStringPrimitiveRadix10(arguments0Value, arguments1Value);
                    return arguments0Value_;
                }
                if (arguments0Value instanceof Number) {
                    arguments0Value_ = (Number)arguments0Value;
                    if (exclude == 0 && arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        this.state_ = state |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        String string = this.toStringPrimitiveRadixInt((Number)arguments0Value_, arguments1Value_);
                        return string;
                    }
                    if (!JSGuards.isUndefined(arguments1Value)) {
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFDF;
                        this.state_ = state |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        String string = this.toStringPrimitive((Number)arguments0Value_, arguments1Value);
                        return string;
                    }
                }
                if (!JSGuards.isJSNumber(arguments0Value) && !JSGuards.isJavaNumber(arguments0Value)) {
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toStringNoNumber(arguments0Value, arguments1Value);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[9];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "toStringIntRadix10";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "toStringRadix10";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "toString";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "toStringPrimitiveIntRadix10";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "toStringPrimitiveRadix10";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "toStringPrimitiveRadixInt";
            s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[6] = s;
            s = new Object[3];
            s[0] = "toStringPrimitive";
            s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[7] = s;
            s = new Object[3];
            s[0] = "toStringNoNumber";
            s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[8] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static NumberPrototypeBuiltins.JSNumberToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSNumberToStringNodeGen(context, builtin, arguments);
        }
    }
}

