/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PropertyGetNode.class)
public final class PropertyGetNodeFactory {

    @GeneratedBy(value=PropertyGetNode.GetPropertyFromJSObjectNode.class)
    static final class GetPropertyFromJSObjectNodeGen
    extends PropertyGetNode.GetPropertyFromJSObjectNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private JSObjectCachedData jSObjectCached_cache;

        private GetPropertyFromJSObjectNodeGen(Object key, boolean isRequired) {
            super(key, isRequired);
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeWithJSObject(DynamicObject arg0Value, Object arg1Value, Object arg2Value, PropertyGetNode arg3Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    JSObjectCachedData s1_ = this.jSObjectCached_cache;
                    while (s1_ != null) {
                        if (s1_.cachedClass_ == this.getJSClass(arg0Value)) {
                            return this.doJSObjectCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedClass_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doJSObjectDirect(arg0Value, arg1Value, arg2Value, arg3Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(DynamicObject arg0Value, Object arg1Value, Object arg2Value, PropertyGetNode arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    JSClass cachedClass__;
                    int count1_ = 0;
                    JSObjectCachedData s1_ = this.jSObjectCached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && s1_.cachedClass_ != this.getJSClass(arg0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (cachedClass__ = this.getJSClass(arg0Value)) == this.getJSClass(arg0Value) && count1_ < 2) {
                        s1_ = new JSObjectCachedData(this.jSObjectCached_cache);
                        s1_.cachedClass_ = cachedClass__;
                        this.jSObjectCached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doJSObjectCached(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedClass_);
                        return object;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.jSObjectCached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doJSObjectDirect(arg0Value, arg1Value, arg2Value, arg3Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            JSObjectCachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.jSObjectCached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doJSObjectCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSClass>> cached = new ArrayList<List<JSClass>>();
                JSObjectCachedData s1_ = this.jSObjectCached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedClass_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doJSObjectDirect";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static PropertyGetNode.GetPropertyFromJSObjectNode create(Object key, boolean isRequired) {
            return new GetPropertyFromJSObjectNodeGen(key, isRequired);
        }

        @GeneratedBy(value=PropertyGetNode.GetPropertyFromJSObjectNode.class)
        private static final class JSObjectCachedData {
            @CompilerDirectives.CompilationFinal
            JSObjectCachedData next_;
            @CompilerDirectives.CompilationFinal
            JSClass cachedClass_;

            JSObjectCachedData(JSObjectCachedData next_) {
                this.next_ = next_;
            }
        }
    }
}

