/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.util.CompilableFunction;

public abstract class JSFunctionFactory {
    protected final JSContext context;

    public static JSFunctionFactory create(JSContext context, DynamicObjectFactory factory) {
        return new Default(context, factory);
    }

    static JSFunctionFactory createIntrinsic(JSContext context, CompilableFunction<JSRealm, DynamicObject> intrinsicDefaultProto, boolean isStrict, boolean isAnonymous, boolean isConstructor, boolean isGenerator, boolean isBound, boolean isAsync, int slot) {
        if (context.isMultiContext()) {
            return new IntrinsicMulti(context, intrinsicDefaultProto, isStrict, isAnonymous, isConstructor, isGenerator, isBound, isAsync);
        }
        return new IntrinsicRealm(context, intrinsicDefaultProto, isStrict, isAnonymous, isConstructor, isGenerator, isBound, isAsync, slot);
    }

    static DynamicObjectFactory makeFactory(JSContext context, DynamicObject prototype, boolean isStrict, boolean isAnonymous, boolean isConstructor, boolean isGenerator, boolean isBound, boolean isAsync) {
        Shape initialShape = isBound ? JSFunction.makeInitialBoundFunctionShape(context, prototype, isAnonymous) : (isGenerator ? JSFunction.makeInitialGeneratorFunctionShape(context, prototype, isAsync, isAnonymous) : (isConstructor ? JSFunction.makeInitialFunctionShape(context, prototype, isStrict, isAnonymous, true, false) : JSFunction.makeInitialFunctionShape(context, prototype, isStrict, isAnonymous)));
        return initialShape.createFactory();
    }

    protected JSFunctionFactory(JSContext context) {
        this.context = context;
    }

    public final DynamicObject create(JSFunctionData functionData, MaterializedFrame enclosingFrame, Object classPrototype, JSRealm realm) {
        return this.createWithPrototype(functionData, enclosingFrame, classPrototype, realm, this.getPrototype(realm));
    }

    public final DynamicObject createWithPrototype(JSFunctionData functionData, MaterializedFrame enclosingFrame, Object classPrototype, JSRealm realm, DynamicObject prototype) {
        DynamicObjectFactory factory = this.getFactory(realm, prototype);
        assert (functionData != null);
        assert (enclosingFrame != null);
        assert (factory.getShape().getObjectType() == JSFunction.INSTANCE);
        if (this.context.getEcmaScriptVersion() < 6 && functionData.hasStrictFunctionProperties()) {
            return this.createES5Strict(factory, functionData, enclosingFrame, classPrototype, realm, prototype);
        }
        if (this.isInObjectProto()) {
            return JSObjectFactory.newInstance(factory, prototype, functionData, enclosingFrame, classPrototype, realm);
        }
        assert (JSObjectFactory.verifyPrototype(factory, prototype));
        return JSObjectFactory.newInstance(factory, functionData, enclosingFrame, classPrototype, realm);
    }

    private DynamicObject createES5Strict(DynamicObjectFactory factory, JSFunctionData functionData, MaterializedFrame enclosingFrame, Object classPrototype, JSRealm realm, DynamicObject prototype) {
        if (this.isInObjectProto()) {
            return JSObjectFactory.newInstance(factory, prototype, functionData, enclosingFrame, classPrototype, realm, realm.getThrowerAccessor(), realm.getThrowerAccessor());
        }
        assert (JSObjectFactory.verifyPrototype(factory, prototype));
        return JSObjectFactory.newInstance(factory, functionData, enclosingFrame, classPrototype, realm, realm.getThrowerAccessor(), realm.getThrowerAccessor());
    }

    public final DynamicObject createBound(JSFunctionData functionData, Object classPrototype, JSRealm realm, DynamicObject boundTargetFunction, Object boundThis, Object[] boundArguments) {
        DynamicObject prototype = this.getPrototype(realm);
        DynamicObjectFactory factory = this.getFactory(realm, prototype);
        assert (functionData != null);
        assert (factory.getShape().getObjectType() == JSFunction.INSTANCE);
        assert (functionData.hasStrictFunctionProperties());
        if (this.context.getEcmaScriptVersion() < 6) {
            return this.createBoundES5(factory, functionData, classPrototype, realm, prototype, boundTargetFunction, boundThis, boundArguments);
        }
        if (this.isInObjectProto()) {
            return JSObjectFactory.newInstance(factory, prototype, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, classPrototype, realm, boundTargetFunction, boundThis, boundArguments);
        }
        assert (JSObjectFactory.verifyPrototype(factory, prototype));
        return JSObjectFactory.newInstance(factory, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, classPrototype, realm, boundTargetFunction, boundThis, boundArguments);
    }

    private DynamicObject createBoundES5(DynamicObjectFactory factory, JSFunctionData functionData, Object classPrototype, JSRealm realm, DynamicObject prototype, DynamicObject boundTargetFunction, Object boundThis, Object[] boundArguments) {
        if (this.isInObjectProto()) {
            return JSObjectFactory.newInstance(factory, prototype, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, classPrototype, realm, boundTargetFunction, boundThis, boundArguments, realm.getThrowerAccessor(), realm.getThrowerAccessor());
        }
        assert (JSObjectFactory.verifyPrototype(factory, prototype));
        return JSObjectFactory.newInstance(factory, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME, classPrototype, realm, boundTargetFunction, boundThis, boundArguments, realm.getThrowerAccessor(), realm.getThrowerAccessor());
    }

    protected abstract DynamicObject getPrototype(JSRealm var1);

    protected abstract DynamicObjectFactory getFactory(JSRealm var1, DynamicObject var2);

    protected abstract boolean isInObjectProto();

    private static final class IntrinsicRealm
    extends JSFunctionFactory {
        private final CompilableFunction<JSRealm, DynamicObject> getProto;
        private final boolean isStrict;
        private final boolean isAnonymous;
        private final boolean isConstructor;
        private final boolean isGenerator;
        private final boolean isBound;
        private final boolean isAsync;
        private final int slot;

        protected IntrinsicRealm(JSContext context, CompilableFunction<JSRealm, DynamicObject> getProto, boolean isStrict, boolean isAnonymous, boolean isConstructor, boolean isGenerator, boolean isBound, boolean isAsync, int slot) {
            super(context);
            this.getProto = getProto;
            this.isStrict = isStrict;
            this.isAnonymous = isAnonymous;
            this.isConstructor = isConstructor;
            this.isGenerator = isGenerator;
            this.isBound = isBound;
            this.isAsync = isAsync;
            this.slot = slot;
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            return (DynamicObject)this.getProto.apply(realm);
        }

        @Override
        protected DynamicObjectFactory getFactory(JSRealm realm, DynamicObject prototype) {
            DynamicObjectFactory realmFactory = realm.getObjectFactories().factories[this.slot];
            if (realmFactory == null) {
                DynamicObjectFactory newFactory;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                realmFactory = realm.getObjectFactories().factories[this.slot] = (newFactory = IntrinsicRealm.makeFactory(this.context, prototype, this.isStrict, this.isAnonymous, this.isConstructor, this.isGenerator, this.isBound, this.isAsync));
            }
            return realmFactory;
        }

        @Override
        protected boolean isInObjectProto() {
            return false;
        }
    }

    private static final class IntrinsicMulti
    extends JSFunctionFactory {
        private final CompilableFunction<JSRealm, DynamicObject> getProto;
        private final DynamicObjectFactory factory;

        protected IntrinsicMulti(JSContext context, CompilableFunction<JSRealm, DynamicObject> getProto, boolean isStrict, boolean isAnonymous, boolean isConstructor, boolean isGenerator, boolean isBound, boolean isAsync) {
            super(context);
            this.factory = IntrinsicMulti.makeFactory(context, null, isStrict, isAnonymous, isConstructor, isGenerator, isBound, isAsync);
            this.getProto = getProto;
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            return (DynamicObject)this.getProto.apply(realm);
        }

        @Override
        protected DynamicObjectFactory getFactory(JSRealm realm, DynamicObject prototype) {
            return this.factory;
        }

        @Override
        protected boolean isInObjectProto() {
            return true;
        }
    }

    private static final class Default
    extends JSFunctionFactory {
        private final DynamicObjectFactory factory;
        private final boolean inObjectProto;

        protected Default(JSContext context, DynamicObjectFactory factory) {
            super(context);
            this.factory = factory;
            this.inObjectProto = JSObjectFactory.hasInObjectProto(factory);
        }

        @Override
        protected DynamicObject getPrototype(JSRealm realm) {
            return realm.getFunctionPrototype();
        }

        @Override
        protected DynamicObjectFactory getFactory(JSRealm realm, DynamicObject prototype) {
            return this.factory;
        }

        @Override
        protected boolean isInObjectProto() {
            return this.inObjectProto;
        }
    }
}

