/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public final class PathUiSupport {
    private PathUiSupport() {
    }

    public static DefaultListModel<BasePathSupport.Item> createListModel(Iterator<BasePathSupport.Item> it) {
        DefaultListModel<BasePathSupport.Item> model = new DefaultListModel<BasePathSupport.Item>();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        return model;
    }

    public static Iterator<BasePathSupport.Item> getIterator(DefaultListModel<BasePathSupport.Item> model) {
        return PathUiSupport.getList(model).iterator();
    }

    public static List<BasePathSupport.Item> getList(DefaultListModel<BasePathSupport.Item> model) {
        return Collections.list(NbCollections.checkedEnumerationByFilter(model.elements(), BasePathSupport.Item.class, (boolean)true));
    }

    public static int[] moveUp(DefaultListModel<BasePathSupport.Item> listModel, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) assert (false) : "MoveUp button should be disabled";
        for (i = 0; i < indices.length; ++i) {
            BasePathSupport.Item item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] - 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] - 1;
        }
        return indices;
    }

    public static boolean canMoveUp(ListSelectionModel selectionModel) {
        return selectionModel.getMinSelectionIndex() > 0;
    }

    public static int[] moveDown(DefaultListModel<BasePathSupport.Item> listModel, int[] indices) {
        int i;
        assert (indices != null);
        if (indices.length == 0) assert (false) : "MoveDown button should be disabled";
        for (i = indices.length - 1; i >= 0; --i) {
            BasePathSupport.Item item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] + 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + 1;
        }
        return indices;
    }

    public static boolean canMoveDown(ListSelectionModel selectionModel, int modelSize) {
        int iMax = selectionModel.getMaxSelectionIndex();
        return iMax != -1 && iMax < modelSize - 1;
    }

    public static int[] remove(DefaultListModel<BasePathSupport.Item> listModel, int[] indices) {
        assert (indices != null);
        if (indices.length == 0) assert (false) : "Remove button should be disabled";
        for (int i = indices.length - 1; i >= 0; --i) {
            listModel.remove(indices[i]);
        }
        if (!listModel.isEmpty()) {
            int selectedIndex = indices[indices.length - 1] - indices.length + 1;
            if (selectedIndex > listModel.size() - 1) {
                selectedIndex = listModel.size() - 1;
            }
            return new int[]{selectedIndex};
        }
        return new int[0];
    }

    public static int[] addFolders(DefaultListModel<BasePathSupport.Item> listModel, int[] indices, String[] files) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[files.length];
        int i = 0;
        int delta = 0;
        while (i + delta < files.length) {
            int current = lastIndex + 1 + i;
            BasePathSupport.Item item = BasePathSupport.Item.create(files[i + delta], null);
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[delta + i] = current;
                ++i;
                continue;
            }
            indexes[i + delta] = listModel.indexOf(item);
            ++delta;
        }
        return indexes;
    }

    public static final class EditMediator
    implements ActionListener,
    ListSelectionListener {
        private final PhpProject project;
        private final JList<BasePathSupport.Item> list;
        private final DefaultListModel<BasePathSupport.Item> listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addFolder;
        private final ButtonModel remove;
        private final ButtonModel moveUp;
        private final ButtonModel moveDown;
        private final FileChooserDirectoryHandler directoryHandler;

        private EditMediator(JList<BasePathSupport.Item> list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            this(null, list, addFolder, remove, moveUp, moveDown, directoryHandler);
        }

        private EditMediator(PhpProject project, JList<BasePathSupport.Item> list, ButtonModel addFolder, ButtonModel remove, FileChooserDirectoryHandler directoryHandler) {
            this(project, list, addFolder, remove, null, null, directoryHandler);
        }

        private EditMediator(PhpProject project, JList<BasePathSupport.Item> list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            assert (directoryHandler != null);
            this.list = list;
            if (!(list.getModel() instanceof DefaultListModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = (DefaultListModel)list.getModel();
            this.selectionModel = list.getSelectionModel();
            this.addFolder = addFolder;
            this.remove = remove;
            this.moveUp = moveUp;
            this.moveDown = moveDown;
            this.project = project;
            this.directoryHandler = directoryHandler;
        }

        public static void register(PhpProject project, JList<BasePathSupport.Item> list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            EditMediator em = new EditMediator(project, list, addFolder, remove, moveUp, moveDown, directoryHandler);
            addFolder.addActionListener(em);
            remove.addActionListener(em);
            moveUp.addActionListener(em);
            moveDown.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        public static void register(PhpProject project, JList<BasePathSupport.Item> list, ButtonModel addFolder, ButtonModel remove, FileChooserDirectoryHandler directoryHandler) {
            EditMediator em = new EditMediator(project, list, addFolder, remove, directoryHandler);
            addFolder.addActionListener(em);
            remove.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        public static void register(JList<BasePathSupport.Item> list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            EditMediator em = new EditMediator(list, addFolder, remove, moveUp, moveDown, directoryHandler);
            addFolder.addActionListener(em);
            remove.addActionListener(em);
            moveUp.addActionListener(em);
            moveDown.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.addFolder) {
                this.addFolders();
            } else if (source == this.remove) {
                int[] newSelection = PathUiSupport.remove(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (this.moveUp != null && source == this.moveUp) {
                int[] newSelection = PathUiSupport.moveUp(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (this.moveDown != null && source == this.moveDown) {
                int[] newSelection = PathUiSupport.moveDown(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.remove.setEnabled(this.selectionModel.getMinSelectionIndex() != -1);
            if (this.moveUp != null) {
                this.moveUp.setEnabled(PathUiSupport.canMoveUp(this.selectionModel));
            }
            if (this.moveDown != null) {
                this.moveDown.setEnabled(PathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
            }
        }

        private void addFolders() {
            File[] selectedFiles;
            FileChooserBuilder builder = new FileChooserBuilder(this.directoryHandler.getDirKey()).setDirectoriesOnly(true).setTitle(NbBundle.getMessage(PathUiSupport.class, (String)"LBL_AddFolders_DialogTitle"));
            File currentDirectory = this.directoryHandler.getCurrentDirectory();
            if (currentDirectory != null) {
                builder.forceUseOfDefaultWorkingDirectory(true).setDefaultWorkingDirectory(currentDirectory);
            }
            if ((selectedFiles = builder.showMultiOpenDialog()) != null && selectedFiles.length > 0) {
                String[] paths = new String[selectedFiles.length];
                for (int i = 0; i < selectedFiles.length; ++i) {
                    paths[i] = selectedFiles[i].getAbsolutePath();
                }
                int[] newSelection = PathUiSupport.addFolders(this.listModel, this.list.getSelectedIndices(), paths);
                this.list.setSelectedIndices(newSelection);
            }
        }

        public static interface FileChooserDirectoryHandler {
            public String getDirKey();

            public File getCurrentDirectory();
        }
    }

    public static class ClassPathListCellRenderer
    implements ListCellRenderer<BasePathSupport.Item> {
        private static final long serialVersionUID = 78866546546546546L;
        private static final String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/php/project/ui/resources/brokenProjectBadge.gif";
        private static final ImageIcon ICON_BROKEN_BADGE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/brokenProjectBadge.gif", (boolean)false);
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_BROKEN_FOLDER = null;
        private final DefaultListCellRenderer delegate = new DefaultListCellRenderer();
        private final PropertyEvaluator evaluator;
        private final FileObject projectFolder;
        private static final Map<String, String> WELL_KNOWN_PATHS_NAMES = new HashMap<String, String>();

        public ClassPathListCellRenderer() {
            this(null, null);
        }

        public ClassPathListCellRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
            this.evaluator = evaluator;
            this.projectFolder = projectFolder;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends BasePathSupport.Item> list, BasePathSupport.Item value, int index, boolean isSelected, boolean cellHasFocus) {
            BasePathSupport.Item item = value;
            JLabel component = (JLabel)this.delegate.getListCellRendererComponent(list, this.getDisplayName(item), index, isSelected, cellHasFocus);
            component.setIcon(ClassPathListCellRenderer.getIcon(item));
            component.setToolTipText(this.getToolTipText(item));
            return component;
        }

        private String getDisplayName(BasePathSupport.Item item) {
            switch (item.getType()) {
                case CLASSPATH: {
                    String name = WELL_KNOWN_PATHS_NAMES.get(BasePathSupport.getAntPropertyName(item.getReference()));
                    return name == null ? item.getReference() : name;
                }
            }
            if (item.isBroken()) {
                if (new File(item.getFilePath()).isAbsolute()) {
                    return NbBundle.getMessage(PathUiSupport.class, (String)"LBL_MissingFile", (Object)this.getFileRefName(item));
                }
                return NbBundle.getMessage(PathUiSupport.class, (String)"LBL_BrokenReference", (Object)this.getFileRefName(item));
            }
            return item.getAbsoluteFilePath(this.projectFolder);
        }

        private static Icon getIcon(BasePathSupport.Item item) {
            switch (item.getType()) {
                case CLASSPATH: {
                    return ImageUtilities.image2Icon((Image)Utils.getIncludePathIcon(false));
                }
            }
            if (item.isBroken()) {
                if (ICON_BROKEN_FOLDER == null) {
                    ICON_BROKEN_FOLDER = new ImageIcon(ImageUtilities.mergeImages((Image)ClassPathListCellRenderer.getFolderIcon().getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                }
                return ICON_BROKEN_FOLDER;
            }
            return ClassPathListCellRenderer.getFolderIcon();
        }

        private String getToolTipText(BasePathSupport.Item item) {
            switch (item.getType()) {
                case FOLDER: {
                    if (item.isBroken()) {
                        if (this.evaluator != null) {
                            return this.evaluator.evaluate(item.getReference());
                        }
                        return item.getReference();
                    }
                    return item.getAbsoluteFilePath(this.projectFolder);
                }
            }
            return null;
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getFileRefName(BasePathSupport.Item item) {
            switch (item.getType()) {
                case FOLDER: {
                    return item.getFilePath();
                }
            }
            return item.getReference();
        }

        static {
            WELL_KNOWN_PATHS_NAMES.put("php.global.include.path", NbBundle.getMessage(PathUiSupport.class, (String)"LBL_GlobalIncludePath_DisplayName"));
        }
    }
}

