/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser.model;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.parser.model.Attribute;
import org.netbeans.modules.html.parser.model.EDHtmlTag;
import org.netbeans.modules.html.parser.model.EDHtmlTagAttribute;
import org.netbeans.modules.html.parser.model.ElementDescriptor;
import org.netbeans.modules.html.parser.model.UnknownHtmlTag;

public class HtmlTagProvider {
    private static Map<ElementDescriptor, HtmlTag> ED_TAGS = new EnumMap<ElementDescriptor, HtmlTag>(ElementDescriptor.class);
    private static Map<String, HtmlTag> TAGS = new HashMap<String, HtmlTag>();
    private static Map<Attribute, HtmlTagAttribute> ATTRS = new EnumMap<Attribute, HtmlTagAttribute>(Attribute.class);

    public static synchronized HtmlTag forElementDescriptor(ElementDescriptor descriptor) {
        HtmlTag impl = ED_TAGS.get((Object)descriptor);
        if (impl == null) {
            impl = new EDHtmlTag(descriptor);
            ED_TAGS.put(descriptor, impl);
        }
        return impl;
    }

    public static synchronized HtmlTag forUnknownTag(String name) {
        HtmlTag impl = TAGS.get(name);
        if (impl == null) {
            impl = new UnknownHtmlTag(name);
            TAGS.put(name, impl);
        }
        return impl;
    }

    public static synchronized HtmlTag getTagForElement(String name) {
        assert (name != null);
        ElementDescriptor descriptor = ElementDescriptor.forName(name);
        return descriptor != null ? HtmlTagProvider.forElementDescriptor(descriptor) : HtmlTagProvider.forUnknownTag(name);
    }

    static synchronized Collection<HtmlTag> convert(Collection<ElementDescriptor> elements) {
        LinkedList<HtmlTag> converted = new LinkedList<HtmlTag>();
        for (ElementDescriptor element : elements) {
            converted.add(HtmlTagProvider.forElementDescriptor(element));
        }
        return converted;
    }

    static synchronized HtmlTagAttribute getHtmlTagAttributeInstance(Attribute attr) {
        HtmlTagAttribute htmlTagAttribute = ATTRS.get((Object)attr);
        if (htmlTagAttribute == null) {
            htmlTagAttribute = new EDHtmlTagAttribute(attr);
            ATTRS.put(attr, htmlTagAttribute);
        }
        return htmlTagAttribute;
    }
}

