/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.gradle.actions.DefaultActionMapping;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ActionMappingScanner {
    private static final EntityResolver DTD_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.contains("action-mapping.dtd")) {
                return new InputSource(ActionMappingScanner.class.getResourceAsStream("action-mapping.dtd"));
            }
            return null;
        }
    };
    Document document;
    Set<String> withPlugins = Collections.emptySet();
    DefaultActionMapping mapping;
    Set<ActionMapping> mappings = new HashSet<ActionMapping>();

    ActionMappingScanner(Document document) {
        this.document = document;
    }

    void visitDocument() {
        Element element = this.document.getDocumentElement();
        if (element != null && element.getTagName().equals("actions")) {
            this.visitElement_actions(element);
        }
    }

    public static Set<ActionMapping> loadMappings(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(DTD_RESOLVER);
        Document document = builder.parse(is);
        ActionMappingScanner scanner = new ActionMappingScanner(document);
        scanner.visitDocument();
        return Collections.unmodifiableSet(scanner.mappings);
    }

    void visitElement_actions(Element element) {
        NodeList nodes = element.getChildNodes();
        block8: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element nodeElement = (Element)node;
            switch (nodeElement.getTagName()) {
                case "apply-for": {
                    this.visitElement_apply_for(nodeElement);
                    continue block8;
                }
                case "action": {
                    this.visitElement_action(nodeElement);
                }
            }
        }
    }

    void visitElement_apply_for(Element element) {
        this.withPlugins = new LinkedHashSet<String>();
        String plugins = element.getAttribute("plugins");
        if (plugins != null) {
            this.withPlugins.addAll(Arrays.asList(plugins.split(",\\s*")));
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals("action")) continue;
            this.visitElement_action(nodeElement);
        }
        this.withPlugins = Collections.emptySet();
    }

    void visitElement_action(Element element) {
        String name = element.getAttribute("name");
        this.mapping = new DefaultActionMapping(name);
        this.mapping.withPlugins = this.withPlugins;
        NamedNodeMap attrs = element.getAttributes();
        block20: for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String value = attr.getValue();
            switch (attr.getName()) {
                case "displayName": {
                    this.mapping.displayName = value;
                    continue block20;
                }
                case "repeatable": {
                    this.mapping.repeatableAction = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "priority": {
                    try {
                        this.mapping.priority = Integer.parseInt(value);
                        continue block20;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        NodeList nodes = element.getChildNodes();
        block21: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element nodeElement = (Element)node;
            switch (nodeElement.getTagName()) {
                case "reload": {
                    this.visitElement_reload(nodeElement);
                    continue block21;
                }
                case "args": {
                    this.mapping.args = this.visitElement_args(nodeElement);
                }
            }
        }
        this.mappings.add(this.mapping);
    }

    void visitElement_reload(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("rule")) continue;
            this.mapping.reloadRule = ActionMapping.ReloadRule.valueOf(attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals("args")) continue block4;
                    this.mapping.reloadArgs = this.visitElement_args(nodeElement);
                }
            }
        }
    }

    String visitElement_args(Element element) {
        return element.hasChildNodes() ? ((Text)element.getFirstChild()).getData() : null;
    }
}

