/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.ConcurrentQueue;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectorFactory {
    public static final int DEFAULT_MAX_SELECTORS = 20;
    private static volatile int maxSelectors = 20;
    private static final ConcurrentQueue<Selector> selectors = new ConcurrentQueue("temporary-selectors-queue");
    private static volatile boolean initialized = false;
    private static volatile long timeout = Long.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxSelectors(int size) throws IOException {
        ConcurrentQueue<Selector> concurrentQueue = selectors;
        synchronized (concurrentQueue) {
            int toAdd;
            if (size < 0) {
                SelectorThread.logger().log(Level.WARNING, " tried to remove too many selectors " + size + ">=" + maxSelectors, new Exception());
                return;
            }
            int n = toAdd = initialized ? size - maxSelectors : size;
            if (toAdd > 0) {
                while (toAdd-- > 0) {
                    selectors.add(SelectorFactory.createSelector());
                }
            } else {
                SelectorFactory.reduce(-toAdd);
            }
            maxSelectors = size;
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeSelectorsBy(int delta) throws IOException {
        ConcurrentQueue<Selector> concurrentQueue = selectors;
        synchronized (concurrentQueue) {
            SelectorFactory.setMaxSelectors(maxSelectors + delta);
        }
    }

    public static int getMaxSelectors() {
        return maxSelectors;
    }

    public static Selector getSelector() {
        if (!initialized) {
            try {
                SelectorFactory.setMaxSelectors(maxSelectors);
            }
            catch (IOException ex) {
                SelectorThread.logger().log(Level.WARNING, "static init of SelectorFactory failed", ex);
            }
        }
        Selector selector = null;
        try {
            selector = (Selector)selectors.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            SelectorThread.logger().log(Level.FINE, "Interrupted during selector polling", e);
        }
        if (selector == null) {
            SelectorThread.logger().warning("No Selector available. Increase default: " + maxSelectors);
        }
        return selector;
    }

    public static void returnSelector(Selector s) {
        selectors.offer(s);
    }

    public static void selectNowAndReturnSelector(Selector s) {
        try {
            s.selectNow();
            SelectorFactory.returnSelector(s);
        }
        catch (IOException e) {
            Logger logger = SelectorThread.logger();
            logger.log(Level.WARNING, "Unexpected problem when releasing temporary Selector", e);
            try {
                s.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                SelectorFactory.reimburseSelector();
            }
            catch (IOException ee) {
                logger.log(Level.WARNING, "Problematic Selector could not be reimbursed!", ee);
            }
        }
    }

    public static void reimburseSelector() throws IOException {
        SelectorFactory.returnSelector(SelectorFactory.createSelector());
    }

    private static void reduce(int tokill) {
        while (tokill-- > 0) {
            try {
                Selector selector = (Selector)selectors.poll();
                if (selector != null) {
                    selector.close();
                    continue;
                }
                SelectorThread.logger().warning("SelectorFactory cache could not remove the desired number, too few selectors in cache.");
                return;
            }
            catch (IOException e) {
                Logger logger = SelectorThread.logger();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "SelectorFactory.reduce", e);
            }
        }
    }

    protected static Selector createSelector() throws IOException {
        return Selector.open();
    }

    public static long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(timeout, TimeUnit.MILLISECONDS);
    }

    public static void setTimeout(long timeout, TimeUnit timeUnit) {
        SelectorFactory.timeout = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }
}

