/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.shell;

import com.oracle.truffle.js.shell.JSLauncher;
import java.util.Map;
import org.graalvm.options.OptionCategory;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;

public class RepeatingLauncher
extends JSLauncher {
    private int engines = 1;
    private int runs = 1;

    @Override
    protected JSLauncher.PreprocessResult preprocessArgument(String argument, String value) {
        if (argument.equals("engines")) {
            this.engines = this.parsePositiveInteger(argument, value);
            return JSLauncher.PreprocessResult.Consumed;
        }
        if (argument.equals("runs")) {
            this.runs = this.parsePositiveInteger(argument, value);
            return JSLauncher.PreprocessResult.Consumed;
        }
        return super.preprocessArgument(argument, value);
    }

    protected int parsePositiveInteger(String optName, String optValue) {
        try {
            int val = Integer.parseInt(optValue);
            if (val >= 0) {
                return val;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw this.abort("The value of '" + optName + "' must be a positive integer");
    }

    @Override
    protected int executeScripts(Context.Builder contextBuilder) {
        int result = 0;
        for (int i = 0; i < this.engines; ++i) {
            int newResult = super.executeScripts(contextBuilder);
            if (Math.abs(newResult) <= Math.abs(result)) continue;
            result = newResult;
        }
        return result;
    }

    @Override
    Source[] parseSources() {
        Source[] originalSources = super.parseSources();
        if (this.runs == 1) {
            return originalSources;
        }
        Source[] newSources = new Source[originalSources.length * this.runs];
        for (int i = 0; i < originalSources.length; ++i) {
            for (int j = 0; j < this.runs; ++j) {
                newSources[i * this.runs + j] = originalSources[i];
            }
        }
        return newSources;
    }

    @Override
    protected void validateArguments(Map<String, String> polyglotOptions) {
        super.validateArguments(polyglotOptions);
        if (!this.hasSources()) {
            if (this.engines > 1) {
                throw this.abort("Can not use --engines with the REPL");
            }
            if (this.runs > 1) {
                throw this.abort("Can not use --runs with the REPL");
            }
        }
    }

    @Override
    protected void printHelp(OptionCategory maxCategory) {
        super.printHelp(maxCategory);
        System.out.println("\nCustom developer options:");
        RepeatingLauncher.printOption("--runs N", "run scripts N times");
        RepeatingLauncher.printOption("--engines N", "load scripts in N different engines");
    }
}

