/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorLocals;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;

public class TRegexBacktrackingNFAExecutorNode
extends TRegexExecutorNode {
    private final NFA nfa;
    private final int numberOfCaptureGroups;
    @Node.Child
    InputRegionMatchesNode regionMatchesNode;

    public TRegexBacktrackingNFAExecutorNode(NFA nfa, int numberOfCaptureGroups) {
        int i;
        this.nfa = nfa;
        nfa.setInitialLoopBack(!nfa.getAst().getFlags().isSticky());
        this.numberOfCaptureGroups = numberOfCaptureGroups;
        for (i = 0; i < nfa.getAnchoredEntry().length; ++i) {
            if (nfa.getState(nfa.getUnAnchoredEntry()[i].getTarget().getId()) == null || nfa.getAnchoredEntry()[i].getTarget() == nfa.getUnAnchoredEntry()[i].getTarget()) continue;
            nfa.getAnchoredEntry()[i].getTarget().addLoopBackNext(new NFAStateTransition(-1, nfa.getAnchoredEntry()[i].getTarget(), nfa.getUnAnchoredEntry()[i].getTarget(), GroupBoundaries.getEmptyInstance()));
        }
        for (i = 0; i < nfa.getNumberOfTransitions(); ++i) {
            if (nfa.getTransitions()[i] == null) continue;
            nfa.getTransitions()[i].getGroupBoundaries().materializeArrays();
        }
    }

    public int getNumberOfCaptureGroups() {
        return this.numberOfCaptureGroups;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        return new TRegexBacktrackingNFAExecutorLocals(input, fromIndex, index, maxIndex, this.numberOfCaptureGroups);
    }

    @Override
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        TRegexBacktrackingNFAExecutorLocals locals = (TRegexBacktrackingNFAExecutorLocals)abstractLocals;
        int offset = Math.min(locals.getIndex(), this.nfa.getAnchoredEntry().length - 1);
        locals.setIndex(locals.getIndex() - offset);
        int pc = (locals.getIndex() == 0 ? this.nfa.getAnchoredEntry() : this.nfa.getUnAnchoredEntry())[offset].getTarget().getId();
        if (this.nfa.getState(pc) == null) {
            return null;
        }
        NFAState curState;
        while (!(curState = this.nfa.getState(pc)).isFinalState(true)) {
            int firstMatch = -1;
            if (locals.getIndex() < this.getInputLength(locals)) {
                char c = this.getChar(locals);
                for (int i = TRegexBacktrackingNFAExecutorNode.getStartingTransition(curState); i >= 0; --i) {
                    if (curState.getNext()[i].getTarget().isAnchoredFinalState(true) || !curState.getNext()[i].getTarget().getCharSet().contains(c)) continue;
                    if (firstMatch >= 0) {
                        if (curState.getNext()[firstMatch].getTarget().isUnAnchoredFinalState(true)) {
                            locals.pushResult(curState.getNext()[firstMatch]);
                        } else {
                            locals.push(curState.getNext()[firstMatch]);
                        }
                    }
                    firstMatch = i;
                }
            } else if (curState.hasTransitionToFinalState(true)) {
                firstMatch = curState.getFirstTransitionToFinalStateIndex(true);
            }
            if (firstMatch < 0) {
                if (locals.canPopResult()) {
                    return locals.popResult();
                }
                if (locals.canPop()) {
                    pc = locals.pop();
                    continue;
                }
                return null;
            }
            locals.apply(curState.getNext()[firstMatch]);
            locals.incIndex(1);
            pc = curState.getNext()[firstMatch].getTarget().getId();
        }
        return locals.toResult();
    }

    private static int getStartingTransition(NFAState curState) {
        return curState.hasTransitionToUnAnchoredFinalState(true) ? curState.getTransitionToUnAnchoredFinalStateId(true) : curState.getNext().length - 1;
    }

    public boolean regionMatches(TRegexExecutorLocals locals, int startIndex1, int startIndex2, int length) {
        if (this.regionMatchesNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.regionMatchesNode = InputRegionMatchesNode.create();
        }
        return this.regionMatchesNode.execute(locals.getInput(), startIndex1, locals.getInput(), startIndex2, length, null);
    }
}

