/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.tregex.parser.RegexFeatures;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import java.util.ArrayList;
import java.util.Map;

public class RegexValidator {
    private final RegexSource source;
    private final RegexFlags flags;
    private final RegexLexer lexer;
    private RegexFeatures features;

    public RegexValidator(RegexSource source, RegexFlags flags, RegexOptions options) {
        this.source = source;
        this.flags = flags;
        this.lexer = new RegexLexer(source, flags, options);
    }

    @CompilerDirectives.TruffleBoundary
    public static void validate(RegexSource source) throws RegexSyntaxException {
        new RegexValidator(source, RegexFlags.parseFlags(source.getFlags()), RegexOptions.DEFAULT).validate();
    }

    @CompilerDirectives.TruffleBoundary
    public void validate() throws RegexSyntaxException {
        this.features = new RegexFeatures();
        this.parseDryRun();
    }

    public RegexFeatures getFeatures() {
        assert (this.features != null);
        return this.features;
    }

    @CompilerDirectives.TruffleBoundary
    public int getNumberOfCaptureGroups() {
        return this.lexer.numberOfCaptureGroups();
    }

    @CompilerDirectives.TruffleBoundary
    public Map<String, Integer> getNamedCaptureGroups() {
        return this.lexer.getNamedCaptureGroups();
    }

    private void parseDryRun() throws RegexSyntaxException {
        ArrayList<RegexStackElem> syntaxStack = new ArrayList<RegexStackElem>();
        int lookBehindDepth = 0;
        CurTermState curTermState = CurTermState.Null;
        while (this.lexer.hasNext()) {
            Token token = this.lexer.next();
            if (lookBehindDepth > 0 && token.kind != Token.Kind.charClass && token.kind != Token.Kind.groupEnd) {
                this.features.setNonLiteralLookBehindAssertions();
            }
            block0 : switch (token.kind) {
                case caret: {
                    curTermState = CurTermState.Other;
                    break;
                }
                case dollar: {
                    if (lookBehindDepth > 0 && !this.flags.isMultiline()) {
                        this.features.setEndOfStringAssertionsInLookBehind();
                    }
                    curTermState = CurTermState.Other;
                    break;
                }
                case wordBoundary: 
                case nonWordBoundary: {
                    if (lookBehindDepth > 0) {
                        this.features.setWordBoundaryAssertionsInLookBehind();
                    }
                    curTermState = CurTermState.Other;
                    break;
                }
                case backReference: {
                    this.features.setBackReferences();
                    if (lookBehindDepth > 0) {
                        this.features.setBackReferencesInLookBehind();
                    }
                    curTermState = CurTermState.Other;
                    break;
                }
                case charClass: {
                    curTermState = CurTermState.Other;
                    break;
                }
                case quantifier: {
                    switch (curTermState) {
                        case Null: {
                            throw this.syntaxError("Quantifier without target");
                        }
                        case LookAheadAssertion: {
                            if (!this.flags.isUnicode()) break;
                            throw this.syntaxError("Quantifier on lookahead assertion");
                        }
                        case LookBehindAssertion: {
                            throw this.syntaxError("Quantifier on lookbehind assertion");
                        }
                        case Other: {
                            Token.Quantifier quantifier = (Token.Quantifier)token;
                            if (lookBehindDepth > 0 && quantifier.getMin() != quantifier.getMax()) {
                                this.features.setNonTrivialQuantifiersInLookBehind();
                            }
                            if (quantifier.getMin() <= 40 && quantifier.getMax() <= 40) break;
                            this.features.setLargeCountedRepetitions();
                        }
                    }
                    curTermState = CurTermState.Other;
                    break;
                }
                case alternation: {
                    curTermState = CurTermState.Null;
                    break;
                }
                case captureGroupBegin: 
                case nonCaptureGroupBegin: {
                    syntaxStack.add(RegexStackElem.Group);
                    curTermState = CurTermState.Null;
                    break;
                }
                case lookAheadAssertionBegin: {
                    if (((Token.LookAheadAssertionBegin)token).isNegated()) {
                        this.features.setNegativeLookAheadAssertions();
                    }
                    if (lookBehindDepth > 0) {
                        this.features.setLookAheadAssertionsInLookBehind();
                    }
                    syntaxStack.add(RegexStackElem.LookAheadAssertion);
                    curTermState = CurTermState.Null;
                    break;
                }
                case lookBehindAssertionBegin: {
                    if (((Token.LookBehindAssertionBegin)token).isNegated()) {
                        this.features.setNegativeLookBehindAssertions();
                        if (lookBehindDepth > 0) {
                            this.features.setNegativeLookBehindAssertionsInLookBehind();
                        }
                    }
                    syntaxStack.add(RegexStackElem.LookBehindAssertion);
                    ++lookBehindDepth;
                    curTermState = CurTermState.Null;
                    break;
                }
                case groupEnd: {
                    if (syntaxStack.isEmpty()) {
                        throw this.syntaxError("Unmatched ')'");
                    }
                    RegexStackElem poppedElem = (RegexStackElem)((Object)syntaxStack.remove(syntaxStack.size() - 1));
                    switch (poppedElem) {
                        case LookAheadAssertion: {
                            curTermState = CurTermState.LookAheadAssertion;
                            break block0;
                        }
                        case LookBehindAssertion: {
                            --lookBehindDepth;
                            curTermState = CurTermState.LookBehindAssertion;
                            break block0;
                        }
                        case Group: {
                            curTermState = CurTermState.Other;
                        }
                    }
                }
            }
        }
        if (!syntaxStack.isEmpty()) {
            throw this.syntaxError("Unterminated group");
        }
    }

    private RegexSyntaxException syntaxError(String msg) {
        return new RegexSyntaxException(this.source, msg);
    }

    private static enum CurTermState {
        Null,
        LookAheadAssertion,
        LookBehindAssertion,
        Other;

    }

    private static enum RegexStackElem {
        Group,
        LookAheadAssertion,
        LookBehindAssertion;

    }
}

