/**
 * All HTML element interfaces derive from this class. Elements that only expose the HTML core attributes are represented by the base HTMLElement interface. These elements are as follows:Note: The style attribute of an HTML element is accessible through the ElementCSSInlineStyle interface which is defined in the CSS module [DOM Level 2 Style Sheets and CSS].
 */
var HTMLElement = new Element();
/**
 * The element's identifier. See the id attribute definition in HTML 4.01.
 * @syntax hTMLElement.id
 * @returns {String} 
 */
HTMLElement.prototype.id = new String();

/**
 * The element's advisory title. See the title attribute definition in HTML 4.01.
 * @syntax hTMLElement.title
 * @returns {String} 
 */
HTMLElement.prototype.title = new String();

/**
 * The style attribute.
 * @syntax elementCSSInlineStyle.style
 * @returns {CSSStyleDeclaration} 
 */
HTMLElement.prototype.style = new CSSStyleDeclaration();

/**
 * Specifies the base direction of directionally neutral text and the directionality of tables. See the dir attribute definition in HTML 4.01.
 * @syntax hTMLElement.dir
 * @returns {String} 
 */
HTMLElement.prototype.dir = new String();

/**
 * The class attribute of the element. This attribute has been renamed due to conflicts with the "class" keyword exposed by many languages. See the class attribute definition in HTML 4.01.
 * @syntax hTMLElement.className
 * @returns {String} 
 */
HTMLElement.prototype.className = new String();

/**
 * Language code defined in RFC 1766. See the lang attribute definition in HTML 4.01.
 * @syntax hTMLElement.lang
 * @returns {String} 
 */
HTMLElement.prototype.lang = new String();

/**
 * Represents the HTMLElement prototype object.
 * @syntax HTMLElement.prototype
 * @static
 */
HTMLElement.prototype;

