/**
 * The NameList interface provides the abstraction of an ordered collection of parallel pairs of name and namespace values (which could be null values), without defining or constraining how this collection is implemented. The items in the NameList are accessible via an integral index, starting from 0.
 */
var NameList = {
}
/**
 * Test if the pair namespaceURI/name is part of this NameList.
 * @syntax nameList.containsNS(namespaceURI, name)
 * @param {String} namespaceURI The namespace URI to look for.
 * @param {String} name The name to look for.
 * @returns {boolean} true if the pair namespaceURI/name has been found, false otherwise.
 */
NameList.prototype.containsNS = function(namespaceURI,  name) {};

/**
 * Returns the indexth name item in the collection.
 * @syntax nameList.getName(index)
 * @param {Number} index Index into the collection.
 * @returns {String} The name at the indexth position in the NameList, or null if there is no name for the specified index or if the index is out of range.
 */
NameList.prototype.getName = function(index) {};

/**
 * Returns the indexth namespaceURI item in the collection.
 * @syntax nameList.getNamespaceURI(index)
 * @param {Number} index Index into the collection.
 * @returns {String} The namespace URI at the indexth position in the NameList, or null if there is no name for the specified index or if the index is out of range.
 */
NameList.prototype.getNamespaceURI = function(index) {};

/**
 * The number of pairs (name and namespaceURI) in the list. The range of valid child node indices is 0 to length-1 inclusive.
 * @syntax nameList.length
 * @returns {Number} 
 */
NameList.prototype.length = new Number();

/**
 * Test if a name is part of this NameList.
 * @syntax nameList.contains(str)
 * @param {String} str The name to look for.
 * @returns {boolean} true if the name has been found, false otherwise.
 */
NameList.prototype.contains = function(str) {};

/**
 * Represents the NameList prototype object.
 * @syntax NameList.prototype
 * @static
 */
NameList.prototype;

