/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import gnu.trove.THashMap;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JetBrainsProtocolHandler {
    public static final String PROTOCOL = "jetbrains://";
    public static final String FRAGMENT_PARAM_NAME = "__fragment";
    public static final String REQUIRED_PLUGINS_KEY = "idea.required.plugins.id";
    private static String ourMainParameter = null;
    private static String ourCommand = null;
    private static Map<String, String> ourParameters = Collections.emptyMap();
    private static boolean initialized = false;

    public static void processJetBrainsLauncherParameters(@NotNull String url) {
        if (url == null) {
            JetBrainsProtocolHandler.$$$reportNull$$$0(0);
        }
        System.setProperty(JetBrainsProtocolHandler.class.getName(), url);
        URI uri = URI.create(url.substring(PROTOCOL.length()));
        String path = uri.getPath();
        List<String> urlParts = StringUtil.split(path, "/");
        if (urlParts.size() < 2) {
            System.err.print("Wrong URL: jetbrains://" + url);
            return;
        }
        ourCommand = urlParts.get(1);
        ourMainParameter = ContainerUtil.getOrElse(urlParts, 2, null);
        THashMap parameters = new THashMap();
        JetBrainsProtocolHandler.computeParameters(uri.getRawQuery(), (Map<String, String>)parameters);
        parameters.put(FRAGMENT_PARAM_NAME, uri.getFragment());
        ourParameters = Collections.unmodifiableMap(parameters);
        initialized = true;
    }

    private static void computeParameters(@Nullable String rawQuery, Map<String, String> parameters) {
        if (StringUtil.isEmpty(rawQuery)) {
            return;
        }
        for (String keyValue : StringUtil.split(rawQuery, "&")) {
            if (keyValue.contains("=")) {
                int ind = keyValue.indexOf(61);
                String key = URLUtil.unescapePercentSequences(keyValue, 0, ind).toString();
                String value = URLUtil.unescapePercentSequences(keyValue, ind + 1, keyValue.length()).toString();
                if (REQUIRED_PLUGINS_KEY.equals(key)) {
                    System.setProperty(key, value);
                    continue;
                }
                parameters.put(key, value);
                continue;
            }
            parameters.put(keyValue, "");
        }
    }

    @Nullable
    public static String getCommand() {
        JetBrainsProtocolHandler.init();
        return ourCommand;
    }

    private static void init() {
        if (initialized) {
            return;
        }
        String property = System.getProperty(JetBrainsProtocolHandler.class.getName());
        if (property != null && property.startsWith(PROTOCOL)) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters(property);
        }
    }

    public static String getMainParameter() {
        JetBrainsProtocolHandler.init();
        return ourMainParameter;
    }

    public static boolean appStartedWithCommand() {
        String property = System.getProperty(JetBrainsProtocolHandler.class.getName());
        return property != null && property.startsWith(PROTOCOL);
    }

    public static void clear() {
        ourCommand = null;
    }

    @NotNull
    public static Map<String, String> getParameters() {
        JetBrainsProtocolHandler.init();
        Map<String, String> map = ourParameters;
        if (map == null) {
            JetBrainsProtocolHandler.$$$reportNull$$$0(1);
        }
        return map;
    }

    public static boolean isShutdownCommand() {
        return "shutdown".equals(JetBrainsProtocolHandler.getCommand());
    }

    public static String @NotNull [] checkForJetBrainsProtocolCommand(String @NotNull [] args) {
        String[] stringArray;
        String property;
        if (args == null) {
            JetBrainsProtocolHandler.$$$reportNull$$$0(2);
        }
        if ((property = System.getProperty(JetBrainsProtocolHandler.class.getName())) != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = property;
        } else {
            stringArray = args;
        }
        if (stringArray == null) {
            JetBrainsProtocolHandler.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/JetBrainsProtocolHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/JetBrainsProtocolHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkForJetBrainsProtocolCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processJetBrainsLauncherParameters";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkForJetBrainsProtocolCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

