/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.openapi.util.Couple;
import com.intellij.serialization.FieldAccessor;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.PropertyAccessor;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PropertyCollector {
    private final ConcurrentMap<Class<?>, List<MutableAccessor>> classToOwnFields = new ConcurrentHashMap();
    private final boolean collectAccessors;
    private final boolean collectPrivateFields;
    private final boolean collectFinalFields;
    public static final byte COLLECT_ACCESSORS = 1;
    public static final byte COLLECT_PRIVATE_FIELDS = 2;
    public static final byte COLLECT_FINAL_FIELDS = 4;

    public PropertyCollector(byte flags) {
        this.collectAccessors = BitUtil.isSet(flags, (byte)1);
        this.collectPrivateFields = BitUtil.isSet(flags, (byte)2);
        this.collectFinalFields = BitUtil.isSet(flags, (byte)4);
    }

    @NotNull
    public List<MutableAccessor> collect(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PropertyCollector.$$$reportNull$$$0(0);
        }
        ArrayList<MutableAccessor> accessors = new ArrayList<MutableAccessor>();
        Map<Object, Object> nameToAccessors = !this.collectAccessors || aClass == Rectangle.class ? Collections.emptyMap() : this.collectPropertyAccessors(aClass, accessors);
        int propertyAccessorCount = accessors.size();
        this.collectFieldAccessors(aClass, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = ((MutableAccessor)accessors.get(j)).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!((MutableAccessor)accessors.get(i)).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        ArrayList<MutableAccessor> arrayList = accessors;
        if (arrayList == null) {
            PropertyCollector.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private void collectFieldAccessors(@NotNull Class<?> originalClass, @NotNull List<? super MutableAccessor> totalProperties) {
        if (originalClass == null) {
            PropertyCollector.$$$reportNull$$$0(2);
        }
        if (totalProperties == null) {
            PropertyCollector.$$$reportNull$$$0(3);
        }
        Class<?> currentClass = originalClass;
        do {
            ArrayList<FieldAccessor> ownFields;
            if ((ownFields = (ArrayList<FieldAccessor>)this.classToOwnFields.get(currentClass)) != null) {
                if (ownFields.isEmpty()) continue;
                totalProperties.addAll((Collection<? super MutableAccessor>)ownFields);
                continue;
            }
            for (Field field : currentClass.getDeclaredFields()) {
                Class<?> fieldType;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !this.hasStoreAnnotations(field) && (!this.collectPrivateFields && !Modifier.isPublic(modifiers) || !this.collectFinalFields && Modifier.isFinal(modifiers) && !Collection.class.isAssignableFrom(fieldType = field.getType()) && !Map.class.isAssignableFrom(fieldType) || this.isAnnotatedAsTransient(field))) continue;
                if (ownFields == null) {
                    ownFields = new ArrayList<FieldAccessor>();
                }
                ownFields.add(new FieldAccessor(field));
            }
            this.classToOwnFields.putIfAbsent(currentClass, ContainerUtil.notNullize(ownFields));
            if (ownFields == null) continue;
            totalProperties.addAll((Collection<? super MutableAccessor>)ownFields);
        } while ((currentClass = currentClass.getSuperclass()) != null && !this.isAnnotatedAsTransient(currentClass) && currentClass != Object.class);
    }

    @NotNull
    private Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<? super MutableAccessor> accessors) {
        if (aClass == null) {
            PropertyCollector.$$$reportNull$$$0(4);
        }
        if (accessors == null) {
            PropertyCollector.$$$reportNull$$$0(5);
        }
        TreeMap<String, Couple<Method>> candidates = new TreeMap<String, Couple<Method>>();
        for (Method method : aClass.getMethods()) {
            NameAndIsSetter propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = PropertyCollector.getPropertyData(method.getName())) == null || method.getParameterCount() != (propertyData.isSetter ? 1 : 0) || propertyData.name.equals("class")) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.name);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if ((propertyData.isSetter ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = new Couple<Method>(propertyData.isSetter ? (Method)candidate.first : method, propertyData.isSetter ? method : (Method)candidate.second);
            candidates.put(propertyData.name, candidate);
        }
        Iterator iterator = candidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry candidate = iterator.next();
            Couple methods = (Couple)candidate.getValue();
            Method getter = (Method)methods.first;
            Method setter = (Method)methods.second;
            if (this.isAcceptableProperty(getter, setter)) {
                accessors.add(new PropertyAccessor((String)candidate.getKey(), getter.getReturnType(), getter, setter));
                continue;
            }
            iterator.remove();
        }
        TreeMap<String, Couple<Method>> treeMap = candidates;
        if (treeMap == null) {
            PropertyCollector.$$$reportNull$$$0(6);
        }
        return treeMap;
    }

    protected void clearSerializationCaches() {
        this.classToOwnFields.clear();
    }

    @Nullable
    private static NameAndIsSetter getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            PropertyCollector.$$$reportNull$$$0(7);
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2);
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3);
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            if (part.endsWith("$annotations")) {
                return null;
            }
            part = part.substring(0, suffixIndex);
        }
        return new NameAndIsSetter(PropertyCollector.decapitalize(part), isSetter);
    }

    @NotNull
    private static String decapitalize(@NotNull String name) {
        if (name == null) {
            PropertyCollector.$$$reportNull$$$0(8);
        }
        if (name.isEmpty() || name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            String string = name;
            if (string == null) {
                PropertyCollector.$$$reportNull$$$0(9);
            }
            return string;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(name.charAt(0));
        return new String(chars);
    }

    private boolean isAcceptableProperty(@Nullable Method getter, @Nullable Method setter) {
        if (getter == null || this.isAnnotatedAsTransient(getter)) {
            return false;
        }
        if (setter == null) {
            return (Collection.class.isAssignableFrom(getter.getReturnType()) || Map.class.isAssignableFrom(getter.getReturnType())) && this.hasStoreAnnotations(getter);
        }
        return !this.isAnnotatedAsTransient(setter) && getter.getReturnType().equals(setter.getParameterTypes()[0]);
    }

    protected boolean isAnnotatedAsTransient(@NotNull AnnotatedElement element) {
        if (element == null) {
            PropertyCollector.$$$reportNull$$$0(10);
        }
        return false;
    }

    protected boolean hasStoreAnnotations(@NotNull AccessibleObject element) {
        if (element == null) {
            PropertyCollector.$$$reportNull$$$0(11);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/serialization/PropertyCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "totalProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/serialization/PropertyCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertyAccessors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldAccessors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertyAccessors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedAsTransient";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasStoreAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NameAndIsSetter {
        final String name;
        final boolean isSetter;

        NameAndIsSetter(String name, boolean isSetter) {
            this.name = name;
            this.isSetter = isSetter;
        }
    }
}

