/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.committed.BrowseCommittedChangesActionKt;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesViewManager;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/BrowseCommittedChangesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.vcs.impl"})
public final class BrowseCommittedChangesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(false);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"e.getData(VIRTUAL_FILE) ?: return");
        VirtualFile file = virtualFile;
        AbstractVcs abstractVcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project2);
        if (abstractVcs == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"getVcsForFile(file, project) ?: return");
        AbstractVcs vcs = abstractVcs;
        if (!CommittedChangesViewManager.Companion.isCommittedChangesAvailable(vcs)) {
            return;
        }
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setVisible(true);
        Presentation presentation3 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
        presentation3.setEnabled(vcs.allowsRemoteCalls(file) && AbstractVcs.fileInVcsByFileStatus((Project)vcs.getProject(), (VirtualFile)file));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project!!");
        Project project2 = project;
        Object object = e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getData(VIRTUAL_FILE)!!");
        VirtualFile file = (VirtualFile)object;
        AbstractVcs abstractVcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project2);
        if (abstractVcs == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"getVcsForFile(file, project)!!");
        AbstractVcs vcs = abstractVcs;
        ChangeBrowserSettings settings = BrowseCommittedChangesActionKt.access$getChangeBrowserSettings(vcs);
        CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
        if (committedChangesProvider == null) {
            Intrinsics.throwNpe();
        }
        if (new CommittedChangesFilterDialog(project2, committedChangesProvider.createFilterUI(true), settings).showAndGet()) {
            BrowseCommittedChangesActionKt.access$showCommittedChanges(vcs, file, settings);
        }
    }
}

