/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/ui/util/BoundedRangeModelThresholdListener;", "Ljavax/swing/event/ChangeListener;", "model", "Ljavax/swing/BoundedRangeModel;", "(Ljavax/swing/BoundedRangeModel;)V", "isAtThreshold", "", "onThresholdReached", "", "stateChanged", "e", "Ljavax/swing/event/ChangeEvent;", "Companion", "intellij.vcs.github"})
public abstract class BoundedRangeModelThresholdListener
implements ChangeListener {
    private final BoundedRangeModel model;
    public static final Companion Companion = new Companion(null);

    @Override
    public void stateChanged(@NotNull ChangeEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.isAtThreshold()) {
            this.onThresholdReached();
        }
    }

    public abstract void onThresholdReached();

    private final boolean isAtThreshold() {
        int visibleAmount = this.model.getExtent();
        int value = this.model.getValue();
        int maximum = this.model.getMaximum();
        if (maximum == 0) {
            return false;
        }
        float scrollFraction = (float)(visibleAmount + value) / (float)maximum;
        return !((double)scrollFraction < 0.5);
    }

    private BoundedRangeModelThresholdListener(BoundedRangeModel model2) {
        this.model = model2;
    }

    public /* synthetic */ BoundedRangeModelThresholdListener(BoundedRangeModel model2, DefaultConstructorMarker $constructor_marker) {
        this(model2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/ui/util/BoundedRangeModelThresholdListener$Companion;", "", "()V", "install", "", "scrollBar", "Ljavax/swing/JScrollBar;", "listener", "Lkotlin/Function0;", "intellij.vcs.github"})
    public static final class Companion {
        public final void install(@NotNull JScrollBar scrollBar, @NotNull Function0<Unit> listener2) {
            Intrinsics.checkParameterIsNotNull((Object)scrollBar, (String)"scrollBar");
            Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
            BoundedRangeModel boundedRangeModel = scrollBar.getModel();
            BoundedRangeModel boundedRangeModel2 = scrollBar.getModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)boundedRangeModel2, (String)"scrollBar.model");
            boundedRangeModel.addChangeListener(new BoundedRangeModelThresholdListener(listener2, scrollBar, boundedRangeModel2){
                final /* synthetic */ Function0 $listener;
                final /* synthetic */ JScrollBar $scrollBar;

                public void onThresholdReached() {
                    this.$listener.invoke();
                }
                {
                    this.$listener = $captured_local_variable$0;
                    this.$scrollBar = $captured_local_variable$1;
                    super($super_call_param$2, null);
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

