/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCellUtil {
    public static boolean hasCells(@NotNull PsiFile file) {
        if (file == null) {
            PyCellUtil.$$$reportNull$$$0(0);
        }
        for (PsiElement el = file.getFirstChild(); el != null; el = el.getNextSibling()) {
            if (!PyCellUtil.isBlockCell(el)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getCellStart(@NotNull PsiElement element) {
        if (element == null) {
            PyCellUtil.$$$reportNull$$$0(1);
        }
        PsiElement el = element;
        while (el != null && !PyCellUtil.isBlockCell(el)) {
            el = PsiTreeUtil.prevLeaf((PsiElement)el);
        }
        if (el == null) {
            return element.getContainingFile().getFirstChild();
        }
        return PsiTreeUtil.nextLeaf((PsiElement)el);
    }

    public static boolean isBlockCell(PsiElement element) {
        return element instanceof PsiComment && (element.getText().startsWith("# %%") || element.getText().startsWith("#%%") || element.getText().startsWith("# <codecell>")) || element.getText().startsWith("# In[");
    }

    @NotNull
    public static String getCodeInCell(@Nullable PsiElement element) {
        StringBuilder text2 = new StringBuilder();
        while (element != null && !PyCellUtil.isBlockCell(element)) {
            text2.append(element.getText());
            element = element.getNextSibling();
        }
        String string = StringUtil.trim((String)text2.toString());
        if (string == null) {
            PyCellUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static PsiElement findNextCell(PsiElement startElement) {
        PsiElement el = PsiTreeUtil.nextLeaf((PsiElement)PsiTreeUtil.getDeepestFirst((PsiElement)startElement));
        while (el != null) {
            if (PyCellUtil.isBlockCell(el)) {
                return el;
            }
            el = PsiTreeUtil.nextLeaf((PsiElement)el);
        }
        return null;
    }

    public static PsiElement findPrevCell(PsiElement startElement) {
        PsiElement el = PsiTreeUtil.prevLeaf((PsiElement)PsiTreeUtil.getDeepestFirst((PsiElement)startElement));
        while (el != null) {
            if (PyCellUtil.isBlockCell(el)) {
                return el;
            }
            el = PsiTreeUtil.prevLeaf((PsiElement)el);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyCellUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyCellUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInCell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasCells";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCellStart";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

