/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAssignmentToLoopOrWithParameterInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static boolean isDeclaredInElse(@NotNull PsiElement elementToCheck, @NotNull PyForStatement forStatement) {
        PyElsePart elsePart;
        if (elementToCheck == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(2);
        }
        if (forStatement == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(3);
        }
        return (elsePart = forStatement.getElsePart()) != null && PsiTreeUtil.isAncestor((PsiElement)elsePart, (PsiElement)elementToCheck, (boolean)false);
    }

    @NotNull
    private static PsiElement handleSubscriptionsAndResolveSafely(@NotNull PyExpression element) {
        if (element == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(4);
        }
        if (element instanceof PySubscriptionExpression) {
            element = ((PySubscriptionExpression)element).getRootOperand();
        }
        PsiElement psiElement = PyUtil.resolveToTheTop((PsiElement)element);
        if (psiElement == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    private static boolean isRequiredStatement(PsiElement element) {
        assert (element != null);
        return element instanceof PyWithStatement || element instanceof PyForStatement;
    }

    @NotNull
    private static List<PyExpression> getNamedElementsOfForAndWithStatements(@NotNull PsiElement element) {
        if (element == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(6);
        }
        if (element instanceof PyForStatement) {
            PyForStatement forStatement = (PyForStatement)element;
            PyExpression target = forStatement.getForPart().getTarget();
            return PyAssignmentToLoopOrWithParameterInspection.dropUnderscores(PyUtil.flattenedParensAndStars(target));
        }
        if (element instanceof PyWithStatement) {
            PyWithStatement withStatement = (PyWithStatement)element;
            ArrayList<PyExpression> result = new ArrayList<PyExpression>();
            for (PyWithItem item : withStatement.getWithItems()) {
                PyExpression target = item.getTarget();
                if (target == null) continue;
                result.addAll(PyUtil.flattenedParensAndTuples(target));
            }
            return PyAssignmentToLoopOrWithParameterInspection.dropUnderscores(result);
        }
        List<PyExpression> list = Collections.emptyList();
        if (list == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<PyExpression> dropUnderscores(@NotNull List<PyExpression> expressions) {
        if (expressions == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.filter(expressions, expression -> !"_".equals(expression.getText()));
        if (list == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleSubscriptionsAndResolveSafely";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElementsOfForAndWithStatements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dropUnderscores";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredInElse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleSubscriptionsAndResolveSafely";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElementsOfForAndWithStatements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dropUnderscores";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Filter
    implements Condition<PsiElement> {
        private final PsiElement myNode;

        private Filter(PsiElement node) {
            this.myNode = node;
        }

        public boolean value(PsiElement psiElement) {
            if (psiElement instanceof ScopeOwner) {
                return true;
            }
            if (!PyAssignmentToLoopOrWithParameterInspection.isRequiredStatement(psiElement)) {
                return false;
            }
            List varsDeclaredInStatement = PyAssignmentToLoopOrWithParameterInspection.getNamedElementsOfForAndWithStatements(psiElement);
            for (PyExpression varDeclaredInStatement : varsDeclaredInStatement) {
                PsiReference reference = PyAssignmentToLoopOrWithParameterInspection.handleSubscriptionsAndResolveSafely(varDeclaredInStatement).getReference();
                if (reference == null || !reference.isReferenceTo(this.myNode)) continue;
                return true;
            }
            return false;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyWithStatement(PyWithStatement node) {
            this.checkNotReDeclaringUpperLoopOrStatement(node);
        }

        @Override
        public void visitPyForStatement(PyForStatement node) {
            this.checkNotReDeclaringUpperLoopOrStatement(node);
        }

        private void checkNotReDeclaringUpperLoopOrStatement(@NotNull PsiElement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            for (PyExpression declaredVar : PyAssignmentToLoopOrWithParameterInspection.getNamedElementsOfForAndWithStatements(statement)) {
                Filter filter = new Filter(PyAssignmentToLoopOrWithParameterInspection.handleSubscriptionsAndResolveSafely(declaredVar));
                PsiElement firstParent = PsiTreeUtil.findFirstParent((PsiElement)statement, (boolean)true, (Condition)filter);
                if (firstParent == null || !PyAssignmentToLoopOrWithParameterInspection.isRequiredStatement(firstParent) || firstParent instanceof PyForStatement && PyAssignmentToLoopOrWithParameterInspection.isDeclaredInElse(statement, (PyForStatement)firstParent)) continue;
                this.registerProblem((PsiElement)declaredVar, PyPsiBundle.message("INSP.NAME.assignment.to.loop.or.with.parameter.display.message", declaredVar.getText()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNotReDeclaringUpperLoopOrStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

