/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyCompatibilityInspection;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ReplaceFunctionWithSetLiteralQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySetFunctionToLiteralInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PySetFunctionToLiteralInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PySetFunctionToLiteralInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    public static PyElement[] getSetCallArguments(PyCallExpression node) {
        PyExpression argument = node.getArguments()[0];
        if (argument instanceof PyStringLiteralExpression) {
            return PyElement.EMPTY_ARRAY;
        }
        if (argument instanceof PySequenceExpression || argument instanceof PyParenthesizedExpression && ((PyParenthesizedExpression)argument).getContainedExpression() instanceof PyTupleExpression) {
            if (argument instanceof PySequenceExpression) {
                return ((PySequenceExpression)argument).getElements();
            }
            PyExpression tuple = ((PyParenthesizedExpression)argument).getContainedExpression();
            if (tuple instanceof PyTupleExpression) {
                return ((PyTupleExpression)tuple).getElements();
            }
        }
        return PyElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyElement[] elements;
            PyExpression[] arguments;
            if (!Visitor.isAvailable(node)) {
                return;
            }
            PyExpression callee = node.getCallee();
            if (node.isCalleeText("set") && callee != null && PyBuiltinCache.isInBuiltins(callee) && (arguments = node.getArguments()).length == 1 && (elements = PySetFunctionToLiteralInspection.getSetCallArguments(node)).length != 0) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.NAME.set.function.to.literal", new Object[0]), new ReplaceFunctionWithSetLiteralQuickFix());
            }
        }

        private static boolean isAvailable(PyCallExpression node) {
            InspectionProfileEntry inspection;
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)node.getProject()).getCurrentProfile();
            InspectionToolWrapper inspectionTool = profile.getInspectionTool("PyCompatibilityInspection", node.getProject());
            if (inspectionTool != null && (inspection = inspectionTool.getTool()) instanceof PyCompatibilityInspection) {
                JDOMExternalizableStringList versions = ((PyCompatibilityInspection)inspection).ourVersions;
                for (String s : versions) {
                    if (LanguageLevel.fromPythonVersion(s).supportsSetLiterals()) continue;
                    return false;
                }
            }
            return LanguageLevel.forElement((PsiElement)node).supportsSetLiterals();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection$Visitor", "<init>"));
        }
    }
}

