/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveUnnecessaryBackslashQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnnecessaryBackslashInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyParameterList(PyParameterList list) {
            this.findProblem((PsiElement)list);
        }

        @Override
        public void visitPyArgumentList(PyArgumentList list) {
            this.findProblem((PsiElement)list);
        }

        @Override
        public void visitPyTupleExpression(PyTupleExpression node) {
            if (node.getParent() instanceof PyParenthesizedExpression) {
                this.findProblem((PsiElement)node);
            }
        }

        @Override
        public void visitPyParenthesizedExpression(PyParenthesizedExpression expression) {
            Stack stack = new Stack();
            stack.push((Object)expression);
            while (!stack.isEmpty()) {
                PsiElement element = (PsiElement)stack.pop();
                if (element instanceof PyTupleExpression) continue;
                this.findProblem(element);
                if (element == null) continue;
                for (PsiElement psiElement : element.getChildren()) {
                    stack.push((Object)psiElement);
                }
            }
        }

        @Override
        public void visitPyDictLiteralExpression(PyDictLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyListLiteralExpression(PyListLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPySetLiteralExpression(PySetLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression stringLiteralExpression) {
            PsiElement parent = stringLiteralExpression.getParent();
            if (parent instanceof PyListLiteralExpression || parent instanceof PyParenthesizedExpression || parent instanceof PySetLiteralExpression || parent instanceof PyKeyValueExpression || parent instanceof PyNamedParameter || parent instanceof PyArgumentList) {
                this.findProblem(stringLiteralExpression);
            }
        }

        private void findProblem(@Nullable PsiElement expression) {
            PsiWhiteSpace[] children2 = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, PsiWhiteSpace.class);
            if (children2 != null) {
                for (PsiWhiteSpace ws : children2) {
                    if (!ws.getText().contains("\\")) continue;
                    this.registerProblem((PsiElement)ws, "Unnecessary backslash in expression.", new RemoveUnnecessaryBackslashQuickFix());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection$Visitor", "<init>"));
        }
    }
}

